/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.FixReadsPhase;
import org.graalvm.compiler.phases.schedule.SchedulePhase;
import org.graalvm.compiler.phases.tiers.LowTierContext;

public class RawConditionalEliminationPhase
extends BasePhase<LowTierContext> {
    private final boolean replaceInputsWithConstants;

    public RawConditionalEliminationPhase(boolean replaceInputsWithConstants) {
        this.replaceInputsWithConstants = replaceInputsWithConstants;
    }

    @Override
    protected void run(StructuredGraph graph, LowTierContext context) {
        if (GraalOptions.RawConditionalElimination.getValue(graph.getOptions()).booleanValue()) {
            SchedulePhase schedulePhase = new SchedulePhase(SchedulePhase.SchedulingStrategy.LATEST, true);
            schedulePhase.apply(graph, context);
            StructuredGraph.ScheduleResult schedule = graph.getLastSchedule();
            schedule.getCFG().visitDominatorTree(new FixReadsPhase.RawConditionalEliminationVisitor(graph, schedule, context.getMetaAccess(), this.replaceInputsWithConstants), false);
        }
    }
}

