/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.options;

import java.util.EnumSet;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.options.OptionKey;

public class EnumOptionKey<T extends Enum<T>>
extends OptionKey<T> {
    final Class<T> enumClass;

    public EnumOptionKey(T value) {
        super(value);
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null");
        }
        this.enumClass = ((Enum)value).getDeclaringClass();
    }

    public EnumSet<T> getAllValues() {
        return EnumSet.allOf(this.enumClass);
    }

    public Object valueOf(String name) {
        try {
            return Enum.valueOf(this.enumClass, name);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("\"" + name + "\" is not a valid option for " + this.getName() + ". Valid values are " + this.getAllValues());
        }
    }

    @Override
    protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, T oldValue, T newValue) {
        assert (this.enumClass.isInstance(newValue)) : newValue + " is not a valid value for " + this.getName();
    }
}

