/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.spi;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.PrimitiveStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueNodeInterface;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.extended.IntegerSwitchNode;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.compiler.nodes.util.GraphUtil;

@SuppressFBWarnings(value={"UCF"}, justification="javac spawns useless control flow in static initializer when using assert(asNode().isAlive())")
public interface SwitchFoldable
extends ValueNodeInterface {
    public static final Comparator<KeyData> SORTER;

    public Node getNextSwitchFoldableBranch();

    public ValueNode switchValue();

    public AbstractBeginNode getDefault();

    public boolean isInSwitch(ValueNode var1);

    public void cutOffCascadeNode();

    public void cutOffLowestCascadeNode();

    public int intKeyAt(int var1);

    public double keyProbability(int var1);

    public AbstractBeginNode keySuccessor(int var1);

    public double defaultProbability();

    public ProfileData.ProfileSource profileSource();

    default public int keyCount() {
        return 1;
    }

    default public boolean isDefaultSuccessor(AbstractBeginNode successor) {
        return successor == this.getDefault();
    }

    default public boolean isNonInitializedProfile() {
        return false;
    }

    public static boolean maybeIsInSwitch(LogicNode condition) {
        return condition instanceof IntegerEqualsNode && ((IntegerEqualsNode)condition).getY().isJavaConstant();
    }

    public static boolean sameSwitchValue(LogicNode condition, ValueNode switchValue) {
        return ((IntegerEqualsNode)condition).getX() == switchValue;
    }

    default public boolean switchTransformationOptimization(SimplifierTool tool) {
        ValueNode switchValue = this.switchValue();
        if (!1.$assertionsDisabled && !this.asNode().isAlive()) {
            throw new AssertionError();
        }
        if (switchValue == null || !this.isInSwitch(switchValue) || Helper.getParentSwitchNode(this, switchValue) == null && Helper.getChildSwitchNode(this, switchValue) == null) {
            return false;
        }
        Stamp switchStamp = switchValue.stamp(NodeView.DEFAULT);
        if (!(switchStamp instanceof IntegerStamp)) {
            return false;
        }
        if (PrimitiveStamp.getBits(switchStamp) > 32) {
            return false;
        }
        SwitchFoldable iteratingNode = this;
        SwitchFoldable topMostSwitchNode = this;
        while (iteratingNode != null) {
            topMostSwitchNode = iteratingNode;
            iteratingNode = Helper.getParentSwitchNode(iteratingNode, switchValue);
        }
        QuickQueryKeyData keyData = new QuickQueryKeyData();
        QuickQueryList<AbstractBeginNode> successors = new QuickQueryList<AbstractBeginNode>();
        QuickQueryList<AbstractBeginNode> potentiallyUnreachable = new QuickQueryList<AbstractBeginNode>();
        double[] cumulative = new double[]{1.0};
        double[] totalProbability = new double[]{0.0};
        iteratingNode = topMostSwitchNode;
        SwitchFoldable lowestSwitchNode = topMostSwitchNode;
        ProfileData.ProfileSource profileSource = topMostSwitchNode.profileSource();
        boolean uninitializedProfiles = true;
        while (iteratingNode != null) {
            lowestSwitchNode = iteratingNode;
            Helper.updateSwitchData(iteratingNode, keyData, successors, cumulative, totalProbability, potentiallyUnreachable);
            if (!iteratingNode.isNonInitializedProfile()) {
                uninitializedProfiles = false;
            }
            profileSource.combine(iteratingNode.profileSource());
            iteratingNode = Helper.getChildSwitchNode(iteratingNode, switchValue);
        }
        if (keyData.size() < 4 || lowestSwitchNode == topMostSwitchNode) {
            return false;
        }
        StructuredGraph graph = this.asNode().graph();
        keyData.sort();
        totalProbability[0] = totalProbability[0] + cumulative[0];
        if (!1.$assertionsDisabled && !(totalProbability[0] > 0.0)) {
            throw new AssertionError();
        }
        double normalizationFactor = 1.0 / totalProbability[0];
        int newKeyCount = keyData.list.size();
        int[] keys = new int[newKeyCount];
        double[] keyProbabilities = new double[newKeyCount + 1];
        int[] keySuccessors = new int[newKeyCount + 1];
        int nonDeoptSuccessorCount = Helper.countNonDeoptSuccessors(keyData) + (cumulative[0] > 0.0 ? 1 : 0);
        double uniform = uninitializedProfiles && nonDeoptSuccessorCount > 0 ? 1.0 / (double)nonDeoptSuccessorCount : 1.0;
        keyProbabilities[newKeyCount] = uninitializedProfiles && cumulative[0] > 0.0 ? uniform : normalizationFactor * cumulative[0];
        keySuccessors[newKeyCount] = Helper.addDefault(lowestSwitchNode, successors);
        for (int i = 0; i < newKeyCount; ++i) {
            KeyData data = keyData.get(i);
            keys[i] = data.key;
            keyProbabilities[i] = uninitializedProfiles && data.keyProbability > 0.0 ? uniform : normalizationFactor * data.keyProbability;
            keySuccessors[i] = data.keySuccessor != -2 ? data.keySuccessor : keySuccessors[newKeyCount];
        }
        ValueNode adapter = null;
        adapter = ((IntegerStamp)switchStamp).getBits() < 32 ? (ValueNode)graph.addOrUnique(new SignExtendNode(switchValue, 32)) : switchValue;
        IntegerSwitchNode toInsert = new IntegerSwitchNode(adapter, successors.size(), keys, keySuccessors, ProfileData.SwitchProbabilityData.create(keyProbabilities, profileSource));
        graph.add(toInsert);
        lowestSwitchNode.cutOffLowestCascadeNode();
        iteratingNode = lowestSwitchNode;
        while (iteratingNode != null) {
            if (iteratingNode != lowestSwitchNode) {
                iteratingNode.cutOffCascadeNode();
            }
            iteratingNode = Helper.getParentSwitchNode(iteratingNode, switchValue);
        }
        topMostSwitchNode.asNode().replaceAtPredecessor(toInsert);
        topMostSwitchNode.asNode().replaceAtUsages(toInsert);
        int pos = 0;
        for (AbstractBeginNode begin : successors.list) {
            if (begin.isUnregistered()) {
                graph.add(begin.next());
                graph.add(begin);
                begin.setNext(begin.next());
            }
            toInsert.setBlockSuccessor(pos++, begin);
        }
        GraphUtil.killCFG((FixedNode)((Object)topMostSwitchNode));
        for (AbstractBeginNode duplicate : potentiallyUnreachable.list) {
            if (duplicate.predecessor() != null) continue;
            if (!1.$assertionsDisabled && !duplicate.isAlive()) {
                throw new AssertionError();
            }
            GraphUtil.killCFG(duplicate);
        }
        tool.addToWorkList(toInsert);
        return true;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        SORTER = Comparator.comparingInt(k -> k.key);
    }

    public static final class QuickQueryKeyData {
        private final List<KeyData> list = new ArrayList<KeyData>();
        private final EconomicMap<Integer, KeyData> map = EconomicMap.create();

        private void add(KeyData key) {
            assert (!this.map.containsKey((Object)key.key));
            this.list.add(key);
            this.map.put((Object)key.key, (Object)key);
        }

        private boolean contains(int key) {
            return this.map.containsKey((Object)key);
        }

        private KeyData get(int index) {
            return this.list.get(index);
        }

        private int size() {
            return this.list.size();
        }

        private KeyData fromKey(int key) {
            assert (this.contains(key));
            return (KeyData)this.map.get((Object)key);
        }

        private void sort() {
            this.list.sort(SORTER);
        }
    }

    public static final class QuickQueryList<T> {
        private final List<T> list = new ArrayList<T>();
        private final EconomicMap<T, Integer> map = EconomicMap.create((Equivalence)Equivalence.IDENTITY);

        private int indexOf(T begin) {
            return (Integer)this.map.get(begin, (Object)-1);
        }

        private boolean contains(T o) {
            return this.map.containsKey(o);
        }

        private T get(int index) {
            return this.list.get(index);
        }

        private boolean add(T item) {
            this.map.put(item, (Object)this.list.size());
            return this.list.add(item);
        }

        private void addUnique(T item) {
            this.list.add(item);
        }

        private int size() {
            return this.list.size();
        }
    }

    public static final class KeyData {
        private static final int KEY_UNKNOWN = -2;
        private final int key;
        private final double keyProbability;
        private int keySuccessor;

        KeyData(int key, double keyProbability, int keySuccessor) {
            this.key = key;
            this.keyProbability = keyProbability;
            this.keySuccessor = keySuccessor;
        }
    }

    public static class Helper {
        private Helper() {
        }

        private static boolean isDuplicateKey(int key, QuickQueryKeyData keyData) {
            return keyData.contains(key);
        }

        private static int duplicateIndex(AbstractBeginNode begin, QuickQueryList<AbstractBeginNode> successors) {
            return successors.indexOf(begin);
        }

        private static Node skipUpBegins(Node node) {
            Node result = node;
            while (result instanceof BeginNode && result.hasNoUsages()) {
                result = result.predecessor();
            }
            return result;
        }

        private static Node skipDownBegins(Node node) {
            Node result = node;
            while (result instanceof BeginNode && result.hasNoUsages()) {
                result = ((BeginNode)result).next();
            }
            return result;
        }

        private static SwitchFoldable getParentSwitchNode(SwitchFoldable node, ValueNode switchValue) {
            Node result = Helper.skipUpBegins(node.asNode().predecessor());
            if (result instanceof SwitchFoldable && ((SwitchFoldable)((Object)result)).isInSwitch(switchValue)) {
                return (SwitchFoldable)((Object)result);
            }
            return null;
        }

        private static SwitchFoldable getChildSwitchNode(SwitchFoldable node, ValueNode switchValue) {
            Node result = Helper.skipDownBegins(node.getNextSwitchFoldableBranch());
            if (result instanceof SwitchFoldable && ((SwitchFoldable)((Object)result)).isInSwitch(switchValue)) {
                return (SwitchFoldable)((Object)result);
            }
            return null;
        }

        private static int addDefault(SwitchFoldable node, QuickQueryList<AbstractBeginNode> successors) {
            AbstractBeginNode defaultBranch = node.getDefault();
            int index = successors.indexOf(defaultBranch);
            if (index == -1) {
                index = successors.size();
                successors.add(defaultBranch);
            }
            return index;
        }

        private static int countNonDeoptSuccessors(QuickQueryKeyData keyData) {
            int result = 0;
            for (KeyData key : keyData.list) {
                if (!(key.keyProbability > 0.0)) continue;
                ++result;
            }
            return result;
        }

        private static void updateSwitchData(SwitchFoldable node, QuickQueryKeyData keyData, QuickQueryList<AbstractBeginNode> newSuccessors, double[] cumulative, double[] totalProbabilities, QuickQueryList<AbstractBeginNode> duplicates) {
            for (int i = 0; i < node.keyCount(); ++i) {
                KeyData data;
                int key = node.intKeyAt(i);
                double keyProbability = cumulative[0] * node.keyProbability(i);
                AbstractBeginNode keySuccessor = node.keySuccessor(i);
                if (Helper.isDuplicateKey(key, keyData)) {
                    data = keyData.fromKey(key);
                    if (data.keySuccessor != -2) {
                        if (!keySuccessor.isAlive() || newSuccessors.contains(keySuccessor) || duplicates.contains(keySuccessor)) continue;
                        duplicates.add(keySuccessor);
                        continue;
                    }
                } else {
                    data = new KeyData(key, keyProbability, -2);
                    totalProbabilities[0] = totalProbabilities[0] + keyProbability;
                    keyData.add(data);
                }
                if (keySuccessor.isUnregistered()) {
                    data.keySuccessor = newSuccessors.size();
                    newSuccessors.addUnique(keySuccessor);
                    continue;
                }
                int pos = Helper.duplicateIndex(keySuccessor, newSuccessors);
                if (pos != -1) {
                    data.keySuccessor = pos;
                    continue;
                }
                if (node.isDefaultSuccessor(keySuccessor)) continue;
                data.keySuccessor = newSuccessors.size();
                newSuccessors.add(keySuccessor);
            }
            cumulative[0] = cumulative[0] * node.defaultProbability();
        }
    }
}

