/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;

@NodeInfo
public abstract class TernaryNode
extends FloatingNode
implements Canonicalizable.Ternary<ValueNode> {
    public static final NodeClass<TernaryNode> TYPE = NodeClass.create(TernaryNode.class);
    @Node.Input
    protected ValueNode x;
    @Node.Input
    protected ValueNode y;
    @Node.Input
    protected ValueNode z;

    @Override
    public ValueNode getX() {
        return this.x;
    }

    @Override
    public ValueNode getY() {
        return this.y;
    }

    @Override
    public ValueNode getZ() {
        return this.z;
    }

    public void setX(ValueNode x) {
        this.updateUsages(this.x, x);
        this.x = x;
    }

    public void setY(ValueNode y) {
        this.updateUsages(this.y, y);
        this.y = y;
    }

    public void setZ(ValueNode z) {
        this.updateUsages(this.z, z);
        this.z = z;
    }

    protected TernaryNode(NodeClass<? extends TernaryNode> c, Stamp stamp, ValueNode x, ValueNode y, ValueNode z) {
        super((NodeClass<? extends FloatingNode>)c, stamp);
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public boolean inferStamp() {
        return this.updateStamp(this.foldStamp(this.getX().stamp(NodeView.DEFAULT), this.getY().stamp(NodeView.DEFAULT), this.getZ().stamp(NodeView.DEFAULT)));
    }

    public abstract Stamp foldStamp(Stamp var1, Stamp var2, Stamp var3);
}

