/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.util.Map;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeFlood;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueProxyNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.util.CollectionsUtil;

@NodeInfo(nameTemplate="Phi({i#values}, {p#valueDescription})")
public class ValuePhiNode
extends PhiNode {
    public static final NodeClass<ValuePhiNode> TYPE = NodeClass.create(ValuePhiNode.class);
    @Node.Input
    protected NodeInputList<ValueNode> values;

    public ValuePhiNode(Stamp stamp, AbstractMergeNode merge) {
        this((NodeClass<? extends ValuePhiNode>)TYPE, stamp, merge);
    }

    protected ValuePhiNode(NodeClass<? extends ValuePhiNode> c, Stamp stamp, AbstractMergeNode merge) {
        super(c, stamp, merge);
        assert (stamp != StampFactory.forVoid());
        this.values = new NodeInputList(this);
    }

    public ValuePhiNode(Stamp stamp, AbstractMergeNode merge, ValueNode[] values) {
        super(TYPE, stamp, merge);
        assert (stamp != StampFactory.forVoid());
        this.values = new NodeInputList((Node)this, (Node[])values);
    }

    @Override
    public NodeInputList<ValueNode> values() {
        return this.values;
    }

    @Override
    public boolean inferStamp() {
        Stamp valuesStamp = StampTool.meetOrNull(this.values(), this);
        if (valuesStamp == null) {
            valuesStamp = this.stamp;
        } else if (this.stamp.isCompatible(valuesStamp)) {
            valuesStamp = this.stamp.join(valuesStamp);
        }
        Stamp maybeNonNullStamp = this.tryInferNonNullStamp(valuesStamp);
        if (maybeNonNullStamp != valuesStamp) {
            valuesStamp = maybeNonNullStamp;
        }
        return this.updateStamp(valuesStamp);
    }

    private Stamp tryInferNonNullStamp(Stamp valuesStamp) {
        AbstractPointerStamp pointerStamp;
        if (this.isAlive() && this.isLoopPhi() && valuesStamp instanceof AbstractPointerStamp && !(pointerStamp = (AbstractPointerStamp)valuesStamp).alwaysNull() && !pointerStamp.nonNull() && StampTool.isPointerNonNull(this.firstValue())) {
            for (ValueNode value : this.values()) {
                if (value == this || value instanceof ValuePhiNode || StampTool.isPointerNonNull(value)) continue;
                return valuesStamp;
            }
            NodeFlood flood = new NodeFlood(this.graph());
            flood.addAll(this.values().filter(ValuePhiNode.class));
            for (Node node : flood) {
                if (!(node instanceof ValuePhiNode)) continue;
                for (ValueNode value : ((ValuePhiNode)node).values()) {
                    if (value == this || value instanceof ValuePhiNode) {
                        flood.add(value);
                        continue;
                    }
                    if (StampTool.isPointerNonNull(value)) continue;
                    return valuesStamp;
                }
            }
            return ((AbstractPointerStamp)valuesStamp).asNonNull();
        }
        return valuesStamp;
    }

    @Override
    public boolean verify() {
        Stamp s = null;
        for (ValueNode input : this.values()) {
            assert (input != null);
            if (s == null) {
                s = input.stamp(NodeView.DEFAULT);
                continue;
            }
            if (s.isCompatible(input.stamp(NodeView.DEFAULT))) continue;
            this.fail("Phi Input Stamps are not compatible. Phi:%s inputs:%s", this, CollectionsUtil.mapAndJoin(this.values(), x -> x.toString() + ":" + x.stamp(NodeView.DEFAULT), ", "));
        }
        return super.verify();
    }

    @Override
    protected String valueDescription() {
        return this.stamp(NodeView.DEFAULT).unrestricted().toString();
    }

    @Override
    public Map<Object, Object> getDebugProperties(Map<Object, Object> map) {
        Map<Object, Object> properties = super.getDebugProperties(map);
        properties.put("valueDescription", this.valueDescription());
        return properties;
    }

    @Override
    public PhiNode duplicateOn(AbstractMergeNode newMerge) {
        return this.graph().addWithoutUnique(new ValuePhiNode(this.stamp(NodeView.DEFAULT), newMerge));
    }

    @Override
    public ProxyNode createProxyFor(LoopExitNode lex) {
        return this.graph().addWithoutUnique(new ValueProxyNode(this, lex));
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool) {
        ValueNode canonical = super.canonical(tool);
        if (canonical == this && this.isLoopPhi() && this.stamp(NodeView.DEFAULT) instanceof IntegerStamp) {
            ValueNode[] canonicalInputs = new ValueNode[this.valueCount()];
            canonicalInputs[0] = this.valueAt(0);
            boolean changedInput = false;
            for (int i = 1; i < this.valueCount(); ++i) {
                ValueNode inputValue = this.valueAt(i);
                ValueNode value = inputValue;
                if (value instanceof AddNode && ((AddNode)value).isAssociative()) {
                    int count = 0;
                    AddNode add = (AddNode)value;
                    ValueNode addend = null;
                    if (add.getY() instanceof AddNode && ((AddNode)add.getY()).getX() == add.getX()) {
                        addend = ((AddNode)value).getX();
                        while (value instanceof AddNode && ((AddNode)value).getX() == addend) {
                            ++count;
                            value = ((AddNode)value).getY();
                        }
                    } else if (add.getX() instanceof AddNode && ((AddNode)add.getX()).getY() == add.getY()) {
                        addend = ((AddNode)value).getY();
                        while (value instanceof AddNode && ((AddNode)value).getY() == addend) {
                            ++count;
                            value = ((AddNode)value).getX();
                        }
                    }
                    if (addend != null && count > 1 && value == this) {
                        ConstantNode n = ConstantNode.forIntegerStamp(this.stamp(NodeView.DEFAULT), count);
                        inputValue = BinaryArithmeticNode.add(BinaryArithmeticNode.mul(n, addend), this);
                        changedInput = true;
                    }
                }
                canonicalInputs[i] = inputValue;
            }
            if (changedInput) {
                canonical = new ValuePhiNode(this.stamp(NodeView.DEFAULT), this.merge(), canonicalInputs);
            }
        }
        return canonical;
    }
}

