/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.BeginStateSplitNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Simplifiable;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.compiler.nodes.util.GraphUtil;

@NodeInfo(allowedUsageTypes={InputType.Association}, cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_4)
public final class LoopExitNode
extends BeginStateSplitNode
implements IterableNodeType,
Simplifiable {
    public static final NodeClass<LoopExitNode> TYPE = NodeClass.create(LoopExitNode.class);
    @Node.Input(value=InputType.Association)
    AbstractBeginNode loopBegin;

    public LoopExitNode(LoopBeginNode loop) {
        super((NodeClass<? extends BeginStateSplitNode>)TYPE);
        assert (loop != null);
        this.loopBegin = loop;
    }

    public LoopBeginNode loopBegin() {
        return (LoopBeginNode)this.loopBegin;
    }

    public void setLoopBegin(AbstractBeginNode loopBegin) {
        this.updateUsages(this.loopBegin, loopBegin);
        this.loopBegin = loopBegin;
    }

    @Override
    public NodeIterable<Node> anchored() {
        return super.anchored().filter(n -> {
            if (n instanceof ProxyNode) {
                ProxyNode proxyNode = (ProxyNode)n;
                return proxyNode.proxyPoint() != this;
            }
            return true;
        });
    }

    @Override
    public void prepareDelete(FixedNode evacuateFrom) {
        this.removeProxies();
        super.prepareDelete(evacuateFrom);
    }

    public void removeProxies() {
        if (this.hasUsages()) {
            block0: while (true) {
                for (ProxyNode vpn : this.proxies().snapshot()) {
                    ValueNode value = vpn.value();
                    vpn.replaceAtUsagesAndDelete(value);
                    if (value != this) continue;
                    continue block0;
                }
                break;
            }
        }
    }

    public NodeIterable<ProxyNode> proxies() {
        return this.usages().filter(n -> {
            if (n instanceof ProxyNode) {
                ProxyNode proxyNode = (ProxyNode)n;
                return proxyNode.proxyPoint() == this;
            }
            return false;
        });
    }

    public void removeExit() {
        this.removeExit(false);
    }

    public void removeExit(boolean forKillCFG) {
        this.removeProxies();
        FrameState loopStateAfter = this.stateAfter();
        if (!forKillCFG || this.predecessor() != null) {
            this.graph().replaceFixedWithFixed(this, this.graph().add(new BeginNode()));
        }
        if (loopStateAfter != null) {
            GraphUtil.tryKillUnused(loopStateAfter);
        }
    }

    @Override
    public void simplify(SimplifierTool tool) {
        Node prev = this.predecessor();
        while (tool.allUsagesAvailable() && prev instanceof BeginNode && prev.hasNoUsages()) {
            AbstractBeginNode begin = (AbstractBeginNode)prev;
            if (prev.predecessor() instanceof InvokeWithExceptionNode) break;
            this.setNodeSourcePosition(begin.getNodeSourcePosition());
            this.graph().removeFixed(begin);
            prev = prev.predecessor();
        }
    }

    @Override
    public boolean verify() {
        assert (!this.graph().getGraphState().getFrameStateVerification().implies(GraphState.FrameStateVerificationFeature.LOOP_EXITS) || this.stateAfter != null) : "Loop exit must have a state until FSA " + this;
        assert (!(this.predecessor() instanceof InvokeWithExceptionNode));
        return super.verify();
    }
}

