/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.alloc.lsra;

import jdk.vm.ci.code.TargetDescription;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.lir.alloc.lsra.Interval;
import org.graalvm.compiler.lir.alloc.lsra.LinearScan;
import org.graalvm.compiler.lir.alloc.lsra.LinearScanAllocationPhase;
import org.graalvm.compiler.lir.alloc.lsra.LinearScanWalker;
import org.graalvm.compiler.lir.alloc.lsra.OptimizingLinearScanWalker;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.phases.AllocationPhase;

public final class LinearScanRegisterAllocationPhase
extends LinearScanAllocationPhase {
    private final LinearScan allocator;

    LinearScanRegisterAllocationPhase(LinearScan allocator) {
        this.allocator = allocator;
    }

    @Override
    protected void run(TargetDescription target, LIRGenerationResult result, AllocationPhase.AllocationContext context) {
        this.allocator.printIntervals("Before register allocation");
        this.allocateRegisters();
        this.allocator.printIntervals("After register allocation");
    }

    void allocateRegisters() {
        try (Indent indent = this.allocator.getDebug().logAndIndent("allocate registers");){
            Pair<Interval, Interval> result = this.allocator.createUnhandledLists(LinearScan.IS_PRECOLORED_INTERVAL, LinearScan.IS_VARIABLE_INTERVAL);
            Interval precoloredIntervals = (Interval)result.getLeft();
            Interval notPrecoloredIntervals = (Interval)result.getRight();
            LinearScanWalker lsw = OptimizingLinearScanWalker.Options.LSRAOptimization.getValue(this.allocator.getOptions()) != false ? new OptimizingLinearScanWalker(this.allocator, precoloredIntervals, notPrecoloredIntervals) : new LinearScanWalker(this.allocator, precoloredIntervals, notPrecoloredIntervals);
            lsw.walk();
            lsw.finishAllocation();
        }
    }
}

