/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.alloc.lsra;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.util.IntList;
import org.graalvm.compiler.core.common.util.Util;
import org.graalvm.compiler.debug.Assertions;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.alloc.lsra.LinearScan;
import org.graalvm.compiler.lir.alloc.lsra.Range;

public final class Interval {
    protected static final int END_MARKER_OPERAND_NUMBER = Integer.MIN_VALUE;
    public final AllocatableValue operand;
    public final int operandNumber;
    private AllocatableValue location;
    private AllocatableValue spillSlot;
    private ValueKind<?> kind;
    private Range first;
    private UsePosList usePosList;
    private Range current;
    Interval next;
    State state;
    private int cachedTo;
    private Interval splitParent;
    private List<Interval> splitChildren = Collections.emptyList();
    private Interval currentSplitChild;
    private boolean insertMoveWhenActivated;
    private SpillState spillState;
    private int spillDefinitionPos;
    private Interval locationHint;
    private Constant materializedValue;
    private int numMaterializationValuesAdded;

    void assignLocation(AllocatableValue newLocation) {
        if (ValueUtil.isRegister((Value)newLocation)) {
            assert (this.location == null) : "cannot re-assign location for " + this;
            if (newLocation.getValueKind().equals((Object)LIRKind.Illegal) && !this.kind.equals((Object)LIRKind.Illegal)) {
                this.location = ValueUtil.asRegister((Value)newLocation).asValue(this.kind);
                return;
            }
        } else if (ValueUtil.isIllegal((Value)newLocation)) {
            assert (this.canMaterialize());
        } else {
            assert (this.location == null || ValueUtil.isRegister((Value)this.location) || LIRValueUtil.isVirtualStackSlot((Value)this.location) && ValueUtil.isStackSlot((Value)newLocation)) : "cannot re-assign location for " + this;
            assert (LIRValueUtil.isStackSlotValue((Value)newLocation));
            assert (!newLocation.getValueKind().equals((Object)LIRKind.Illegal));
            assert (newLocation.getValueKind().equals(this.kind));
        }
        this.location = newLocation;
    }

    public boolean isEndMarker() {
        return this.operandNumber == Integer.MIN_VALUE;
    }

    public AllocatableValue location() {
        return this.location;
    }

    public ValueKind<?> kind() {
        assert (!ValueUtil.isRegister((Value)this.operand)) : "cannot access type for fixed interval";
        return this.kind;
    }

    public void setKind(ValueKind<?> kind) {
        assert (ValueUtil.isRegister((Value)this.operand) || this.kind().equals((Object)LIRKind.Illegal) || this.kind().equals(kind)) : "overwriting existing type";
        this.kind = kind;
    }

    public Range first() {
        return this.first;
    }

    public int from() {
        return this.first.from;
    }

    int to() {
        if (this.cachedTo == -1) {
            this.cachedTo = this.calcTo();
        }
        assert (this.cachedTo == this.calcTo()) : "invalid cached value";
        return this.cachedTo;
    }

    int numUsePositions() {
        return this.usePosList.size();
    }

    public void setLocationHint(Interval interval) {
        this.locationHint = interval;
    }

    public boolean isSplitParent() {
        return this.splitParent == this;
    }

    boolean isSplitChild() {
        return this.splitParent != this;
    }

    public Interval splitParent() {
        assert (this.splitParent.isSplitParent()) : "not a split parent: " + this;
        return this.splitParent;
    }

    public AllocatableValue spillSlot() {
        return this.splitParent().spillSlot;
    }

    public void setSpillSlot(AllocatableValue slot) {
        assert (LIRValueUtil.isStackSlotValue((Value)slot));
        assert (this.splitParent().spillSlot == null || LIRValueUtil.isVirtualStackSlot((Value)this.splitParent().spillSlot) && ValueUtil.isStackSlot((Value)slot)) : "connot overwrite existing spill slot";
        this.splitParent().spillSlot = slot;
    }

    Interval currentSplitChild() {
        return this.splitParent().currentSplitChild;
    }

    void makeCurrentSplitChild() {
        this.splitParent().currentSplitChild = this;
    }

    boolean insertMoveWhenActivated() {
        return this.insertMoveWhenActivated;
    }

    void setInsertMoveWhenActivated(boolean b) {
        this.insertMoveWhenActivated = b;
    }

    public SpillState spillState() {
        return this.splitParent().spillState;
    }

    public int spillDefinitionPos() {
        return this.splitParent().spillDefinitionPos;
    }

    public void setSpillState(SpillState state) {
        assert (state.ordinal() >= this.spillState().ordinal()) : "state cannot decrease";
        this.splitParent().spillState = state;
    }

    public void setSpillDefinitionPos(int pos) {
        assert (this.spillState() == SpillState.SpillInDominator || this.spillState() == SpillState.NoDefinitionFound || this.spillDefinitionPos() == -1) : "cannot set the position twice";
        this.splitParent().spillDefinitionPos = pos;
    }

    public boolean alwaysInMemory() {
        return SpillState.ALWAYS_IN_MEMORY.contains((Object)this.spillState()) && !this.canMaterialize();
    }

    void removeFirstUsePos() {
        this.usePosList.removeLowestUsePos();
    }

    boolean intersects(Interval i) {
        return this.first.intersects(i.first);
    }

    int intersectsAt(Interval i) {
        return this.first.intersectsAt(i.first);
    }

    void rewindRange() {
        this.current = this.first;
    }

    void nextRange() {
        assert (!this.isEndMarker()) : "not allowed on sentinel";
        this.current = this.current.next;
    }

    int currentFrom() {
        return this.current.from;
    }

    int currentTo() {
        return this.current.to;
    }

    boolean currentAtEnd() {
        return this.current.isEndMarker();
    }

    boolean currentIntersects(Interval it) {
        return this.current.intersects(it.current);
    }

    int currentIntersectsAt(Interval it) {
        return this.current.intersectsAt(it.current);
    }

    Interval(AllocatableValue operand, int operandNumber, Interval intervalEndMarker, Range rangeEndMarker) {
        assert (operand != null);
        this.operand = operand;
        this.operandNumber = operandNumber;
        if (ValueUtil.isRegister((Value)operand)) {
            this.location = operand;
        } else assert (ValueUtil.isIllegal((Value)operand) || LIRValueUtil.isVariable((Value)operand));
        this.kind = LIRKind.Illegal;
        this.first = rangeEndMarker;
        this.usePosList = new UsePosList(4);
        this.current = rangeEndMarker;
        this.next = intervalEndMarker;
        this.cachedTo = -1;
        this.spillState = SpillState.NoDefinitionFound;
        this.spillDefinitionPos = -1;
        this.splitParent = this;
        this.currentSplitChild = this;
    }

    public void addMaterializationValue(Constant value) {
        this.materializedValue = this.numMaterializationValuesAdded == 0 ? value : null;
        ++this.numMaterializationValuesAdded;
    }

    public boolean canMaterialize() {
        return this.getMaterializedValue() != null;
    }

    public Constant getMaterializedValue() {
        return this.splitParent().materializedValue;
    }

    int calcTo() {
        assert (!this.first.isEndMarker()) : "interval has no range";
        Range r = this.first;
        while (!r.next.isEndMarker()) {
            r = r.next;
        }
        return r.to;
    }

    boolean checkSplitChildren() {
        if (!this.splitChildren.isEmpty()) {
            assert (this.isSplitParent()) : "only split parents can have children";
            for (int i = 0; i < this.splitChildren.size(); ++i) {
                Interval i1 = this.splitChildren.get(i);
                assert (i1.splitParent() == this) : "not a split child of this interval";
                assert (i1.kind().equals(this.kind())) : "must be equal for all split children";
                assert (i1.spillSlot() == null && this.spillSlot == null || i1.spillSlot().equals((Object)this.spillSlot())) : "must be equal for all split children";
                for (int j = i + 1; j < this.splitChildren.size(); ++j) {
                    Interval i2 = this.splitChildren.get(j);
                    assert (!i1.operand.equals((Object)i2.operand)) : "same register number";
                    if (i1.from() < i2.from()) {
                        assert (i1.to() <= i2.from() && i1.to() < i2.to()) : "intervals overlapping";
                        continue;
                    }
                    assert (i2.from() < i1.from()) : "intervals start at same opId";
                    assert (i2.to() <= i1.from() && i2.to() < i1.to()) : "intervals overlapping";
                }
            }
        }
        return true;
    }

    public Interval locationHint(boolean searchSplitChild) {
        if (!searchSplitChild) {
            return this.locationHint;
        }
        if (this.locationHint != null) {
            assert (this.locationHint.isSplitParent()) : "ony split parents are valid hint registers";
            if (this.locationHint.location != null && ValueUtil.isRegister((Value)this.locationHint.location)) {
                return this.locationHint;
            }
            if (!this.locationHint.splitChildren.isEmpty()) {
                int len = this.locationHint.splitChildren.size();
                for (int i = 0; i < len; ++i) {
                    Interval interval = this.locationHint.splitChildren.get(i);
                    if (interval.location == null || !ValueUtil.isRegister((Value)interval.location)) continue;
                    return interval;
                }
            }
        }
        return null;
    }

    Interval getSplitChildAtOpId(int opId, LIRInstruction.OperandMode mode, LinearScan allocator) {
        assert (this.isSplitParent()) : "can only be called for split parents";
        assert (opId >= 0) : "invalid opId (method cannot be called for spill moves)";
        if (this.splitChildren.isEmpty()) {
            assert (this.covers(opId, mode)) : this + " does not cover " + opId;
            return this;
        }
        Interval result = null;
        int len = this.splitChildren.size();
        int toOffset = mode == LIRInstruction.OperandMode.DEF ? 0 : 1;
        for (int i = 0; i < len; ++i) {
            Interval cur = this.splitChildren.get(i);
            if (cur.from() > opId || opId >= cur.to() + toOffset) continue;
            if (i > 0) {
                Util.atPutGrow(this.splitChildren, i, this.splitChildren.get(0), null);
                Util.atPutGrow(this.splitChildren, 0, cur, null);
            }
            result = cur;
            break;
        }
        assert (this.checkSplitChild(result, opId, allocator, toOffset, mode));
        return result;
    }

    private boolean checkSplitChild(Interval result, int opId, LinearScan allocator, int toOffset, LIRInstruction.OperandMode mode) {
        if (result == null) {
            StringBuilder msg = new StringBuilder(this.toString()).append(" has no child at ").append(opId);
            if (!this.splitChildren.isEmpty()) {
                Interval firstChild = this.splitChildren.get(0);
                Interval lastChild = this.splitChildren.get(this.splitChildren.size() - 1);
                msg.append(" (first = ").append(firstChild).append(", last = ").append(lastChild).append(")");
            }
            throw new GraalError("Linear Scan Error: %s", msg);
        }
        if (!this.splitChildren.isEmpty()) {
            for (Interval interval : this.splitChildren) {
                if (interval == result || interval.from() > opId || opId >= interval.to() + toOffset) continue;
                throw new GraalError("two valid result intervals found for opId %d: %d and %d\n%s\n", opId, result.operandNumber, interval.operandNumber, result.logString(allocator), interval.logString(allocator));
            }
        }
        assert (result.covers(opId, mode)) : "opId not covered by interval";
        return true;
    }

    Interval getIntervalCoveringOpId(int opId) {
        assert (opId >= 0) : "invalid opId";
        assert (opId < this.to()) : "can only look into the past";
        if (opId >= this.from()) {
            return this;
        }
        Interval parent = this.splitParent();
        Interval result = null;
        assert (!parent.splitChildren.isEmpty()) : "no split children available";
        int len = parent.splitChildren.size();
        for (int i = len - 1; i >= 0; --i) {
            Interval cur = parent.splitChildren.get(i);
            if (cur.from() > opId || opId >= cur.to()) continue;
            assert (result == null) : "covered by multiple split children " + result + " and " + cur;
            result = cur;
        }
        return result;
    }

    Interval getSplitChildBeforeOpId(int opId) {
        assert (opId >= 0) : "invalid opId";
        Interval parent = this.splitParent();
        Interval result = null;
        assert (!parent.splitChildren.isEmpty()) : "no split children available";
        int len = parent.splitChildren.size();
        for (int i = len - 1; i >= 0; --i) {
            Interval cur = parent.splitChildren.get(i);
            if (cur.to() > opId || result != null && result.to() >= cur.to()) continue;
            result = cur;
        }
        assert (result != null) : "no split child found";
        return result;
    }

    boolean splitChildCovers(int opId, LIRInstruction.OperandMode mode) {
        assert (this.isSplitParent()) : "can only be called for split parents";
        assert (opId >= 0) : "invalid opId (method can not be called for spill moves)";
        if (this.splitChildren.isEmpty()) {
            return this.covers(opId, mode);
        }
        int len = this.splitChildren.size();
        for (int i = 0; i < len; ++i) {
            Interval cur = this.splitChildren.get(i);
            if (!cur.covers(opId, mode)) continue;
            return true;
        }
        return false;
    }

    private RegisterPriority adaptPriority(RegisterPriority priority) {
        if (priority == RegisterPriority.ShouldHaveRegister && this.canMaterialize()) {
            return RegisterPriority.MustHaveRegister;
        }
        return priority;
    }

    int firstUsage(RegisterPriority minRegisterPriority) {
        assert (LIRValueUtil.isVariable((Value)this.operand)) : "cannot access use positions for fixed intervals";
        for (int i = this.usePosList.size() - 1; i >= 0; --i) {
            RegisterPriority registerPriority = this.adaptPriority(this.usePosList.registerPriority(i));
            if (!registerPriority.greaterEqual(minRegisterPriority)) continue;
            return this.usePosList.usePos(i);
        }
        return Integer.MAX_VALUE;
    }

    int nextUsage(RegisterPriority minRegisterPriority, int from) {
        assert (LIRValueUtil.isVariable((Value)this.operand)) : "cannot access use positions for fixed intervals";
        for (int i = this.usePosList.size() - 1; i >= 0; --i) {
            int usePos = this.usePosList.usePos(i);
            if (usePos < from || !this.adaptPriority(this.usePosList.registerPriority(i)).greaterEqual(minRegisterPriority)) continue;
            return usePos;
        }
        return Integer.MAX_VALUE;
    }

    int nextUsageExact(RegisterPriority exactRegisterPriority, int from) {
        assert (LIRValueUtil.isVariable((Value)this.operand)) : "cannot access use positions for fixed intervals";
        for (int i = this.usePosList.size() - 1; i >= 0; --i) {
            int usePos = this.usePosList.usePos(i);
            if (usePos < from || this.adaptPriority(this.usePosList.registerPriority(i)) != exactRegisterPriority) continue;
            return usePos;
        }
        return Integer.MAX_VALUE;
    }

    int previousUsage(RegisterPriority minRegisterPriority, int from) {
        assert (LIRValueUtil.isVariable((Value)this.operand)) : "cannot access use positions for fixed intervals";
        int prev = -1;
        for (int i = this.usePosList.size() - 1; i >= 0; --i) {
            int usePos = this.usePosList.usePos(i);
            if (usePos > from) {
                return prev;
            }
            if (!this.adaptPriority(this.usePosList.registerPriority(i)).greaterEqual(minRegisterPriority)) continue;
            prev = usePos;
        }
        return prev;
    }

    public void addUsePos(int pos, RegisterPriority registerPriority, boolean detailedAsserts) {
        assert (this.covers(pos, LIRInstruction.OperandMode.USE)) : String.format("use position %d not covered by live range of interval %s", pos, this);
        if (registerPriority != RegisterPriority.None && LIRValueUtil.isVariable((Value)this.operand)) {
            int len;
            if (detailedAsserts) {
                for (int i = 0; i < this.usePosList.size(); ++i) {
                    assert (pos <= this.usePosList.usePos(i)) : "already added a use-position with lower position";
                    if (i > 0) assert (this.usePosList.usePos(i) < this.usePosList.usePos(i - 1)) : "not sorted descending";
                }
            }
            if ((len = this.usePosList.size()) == 0 || this.usePosList.usePos(len - 1) > pos) {
                this.usePosList.add(pos, registerPriority);
            } else if (this.usePosList.registerPriority(len - 1).lessThan(registerPriority)) {
                assert (this.usePosList.usePos(len - 1) == pos) : "list not sorted correctly";
                this.usePosList.setRegisterPriority(len - 1, registerPriority);
            }
        }
    }

    public void addRange(int from, int to) {
        assert (from < to) : "invalid range";
        assert (this.first().isEndMarker() || to < this.first().next.from) : "not inserting at begin of interval";
        assert (from <= this.first().to) : "not inserting at begin of interval";
        if (this.first.from <= to) {
            assert (!this.first.isEndMarker());
            this.first.from = Math.min(from, this.first().from);
            this.first.to = Math.max(to, this.first().to);
        } else {
            this.first = new Range(from, to, this.first());
        }
    }

    Interval newSplitChild(LinearScan allocator) {
        Interval parent = this.splitParent();
        Interval result = allocator.createDerivedInterval(parent);
        result.setKind(this.kind());
        result.splitParent = parent;
        result.setLocationHint(parent);
        if (parent.splitChildren.isEmpty()) {
            assert (this.isSplitParent()) : "list must be initialized at first split";
            parent.splitChildren = new ArrayList<Interval>(4);
            parent.splitChildren.add(this);
        }
        parent.splitChildren.add(result);
        return result;
    }

    Interval split(int splitPos, LinearScan allocator) {
        assert (LIRValueUtil.isVariable((Value)this.operand)) : "cannot split fixed intervals";
        Interval result = this.newSplitChild(allocator);
        Range prev = null;
        Range cur = this.first;
        while (!cur.isEndMarker() && cur.to <= splitPos) {
            prev = cur;
            cur = cur.next;
        }
        assert (!cur.isEndMarker()) : "split interval after end of last range";
        if (cur.from < splitPos) {
            result.first = new Range(splitPos, cur.to, cur.next);
            cur.to = splitPos;
            cur.next = allocator.rangeEndMarker;
        } else {
            assert (prev != null) : "split before start of first range";
            result.first = cur;
            prev.next = allocator.rangeEndMarker;
        }
        result.current = result.first;
        this.cachedTo = -1;
        result.usePosList = this.usePosList.splitAt(splitPos);
        if (Assertions.detailedAssertionsEnabled(allocator.getOptions())) {
            int i;
            for (i = 0; i < this.usePosList.size(); ++i) {
                assert (this.usePosList.usePos(i) < splitPos);
            }
            for (i = 0; i < result.usePosList.size(); ++i) {
                assert (result.usePosList.usePos(i) >= splitPos);
            }
        }
        return result;
    }

    Interval splitFromStart(int splitPos, LinearScan allocator) {
        assert (LIRValueUtil.isVariable((Value)this.operand)) : "cannot split fixed intervals";
        assert (splitPos > this.from() && splitPos < this.to()) : "can only split inside interval";
        assert (splitPos > this.first.from && splitPos <= this.first.to) : "can only split inside first range";
        assert (this.firstUsage(RegisterPriority.None) > splitPos) : "can not split when use positions are present";
        Interval result = this.newSplitChild(allocator);
        result.addRange(this.first.from, splitPos);
        if (splitPos == this.first.to) {
            assert (!this.first.next.isEndMarker()) : "must not be at end";
            this.first = this.first.next;
        } else {
            this.first.from = splitPos;
        }
        return result;
    }

    boolean covers(int opId, LIRInstruction.OperandMode mode) {
        Range cur = this.first;
        while (!cur.isEndMarker() && cur.to < opId) {
            cur = cur.next;
        }
        if (!cur.isEndMarker()) {
            assert (cur.to != cur.next.from) : "ranges not separated";
            if (mode == LIRInstruction.OperandMode.DEF) {
                return cur.from <= opId && opId < cur.to;
            }
            return cur.from <= opId && opId <= cur.to;
        }
        return false;
    }

    boolean hasHoleBetween(int holeFrom, int holeTo) {
        assert (holeFrom < holeTo) : "check";
        assert (this.from() <= holeFrom && holeTo <= this.to()) : "index out of interval";
        Range cur = this.first;
        while (!cur.isEndMarker()) {
            assert (cur.to < cur.next.from) : "no space between ranges";
            if (holeFrom < cur.from) {
                return true;
            }
            if (holeTo <= cur.to) {
                return false;
            }
            if (holeFrom <= cur.to) {
                return true;
            }
            cur = cur.next;
        }
        return false;
    }

    public String toString() {
        String from = "?";
        String to = "?";
        if (this.first != null && !this.first.isEndMarker()) {
            from = String.valueOf(this.from());
            to = String.valueOf(this.calcTo());
        }
        String locationString = this.location == null ? "" : "@" + this.location;
        return this.operandNumber + ":" + this.operand + (ValueUtil.isRegister((Value)this.operand) ? "" : locationString) + "[" + from + "," + to + "]";
    }

    public UsePosList usePosList() {
        return this.usePosList;
    }

    public String logString(LinearScan allocator) {
        StringBuilder buf = new StringBuilder(100);
        buf.append(this.operandNumber).append(':').append(this.operand).append(' ');
        if (!ValueUtil.isRegister((Value)this.operand) && this.location != null) {
            buf.append("location{").append(this.location).append("} ");
        }
        buf.append("hints{").append(this.splitParent.operandNumber);
        Interval hint = this.locationHint(false);
        if (hint != null && hint.operandNumber != this.splitParent.operandNumber) {
            buf.append(", ").append(hint.operandNumber);
        }
        buf.append("} ranges{");
        Range cur = this.first;
        while (!cur.isEndMarker()) {
            if (cur != this.first) {
                buf.append(", ");
            }
            buf.append(cur);
            cur = cur.next;
            assert (cur != null) : "range list not closed with range sentinel";
        }
        buf.append("} uses{");
        int prev = -1;
        for (int i = this.usePosList.size() - 1; i >= 0; --i) {
            assert (prev < this.usePosList.usePos(i)) : "use positions not sorted";
            if (i != this.usePosList.size() - 1) {
                buf.append(", ");
            }
            buf.append(this.usePosList.usePos(i)).append(':').append((Object)this.usePosList.registerPriority(i));
            prev = this.usePosList.usePos(i);
        }
        buf.append("} spill-state{").append((Object)this.spillState()).append("}");
        if (this.canMaterialize()) {
            buf.append(" (remat:").append(this.getMaterializedValue().toString()).append(")");
        }
        return buf.toString();
    }

    List<Interval> getSplitChildren() {
        return Collections.unmodifiableList(this.splitChildren);
    }

    public static final class UsePosList {
        private IntList list;

        public UsePosList(int initialCapacity) {
            this.list = new IntList(initialCapacity * 2);
        }

        private UsePosList(IntList list) {
            this.list = list;
        }

        public UsePosList splitAt(int splitPos) {
            int i = this.size() - 1;
            int len = 0;
            while (i >= 0 && this.usePos(i) < splitPos) {
                --i;
                len += 2;
            }
            int listSplitIndex = (i + 1) * 2;
            IntList childList = this.list;
            this.list = IntList.copy(this.list, listSplitIndex, len);
            childList.setSize(listSplitIndex);
            UsePosList child = new UsePosList(childList);
            return child;
        }

        public int usePos(int index) {
            return this.list.get(index << 1);
        }

        public RegisterPriority registerPriority(int index) {
            return RegisterPriority.VALUES[this.list.get((index << 1) + 1)];
        }

        public void add(int usePos, RegisterPriority registerPriority) {
            assert (this.list.size() == 0 || this.usePos(this.size() - 1) > usePos);
            this.list.add(usePos);
            this.list.add(registerPriority.ordinal());
        }

        public int size() {
            return this.list.size() >> 1;
        }

        public void removeLowestUsePos() {
            this.list.setSize(this.list.size() - 2);
        }

        public void setRegisterPriority(int index, RegisterPriority registerPriority) {
            this.list.set((index << 1) + 1, registerPriority.ordinal());
        }

        public String toString() {
            StringBuilder buf = new StringBuilder("[");
            for (int i = this.size() - 1; i >= 0; --i) {
                if (buf.length() != 1) {
                    buf.append(", ");
                }
                RegisterPriority prio = this.registerPriority(i);
                buf.append(this.usePos(i)).append(" -> ").append(prio.ordinal()).append(':').append((Object)prio);
            }
            return buf.append("]").toString();
        }
    }

    public static enum SpillState {
        NoDefinitionFound,
        NoSpillStore,
        OneSpillStore,
        SpillInDominator,
        StoreAtDefinition,
        StartInMemory,
        NoOptimization;

        public static final EnumSet<SpillState> ALWAYS_IN_MEMORY;

        static {
            ALWAYS_IN_MEMORY = EnumSet.of(SpillInDominator, StoreAtDefinition, StartInMemory);
        }
    }

    static enum State {
        Unhandled,
        Active,
        Inactive,
        Handled;

    }

    static enum RegisterBinding {
        Fixed,
        Any,
        Stack;

        public static final RegisterBinding[] VALUES;

        static {
            VALUES = RegisterBinding.values();
        }
    }

    public static enum RegisterPriority {
        None,
        LiveAtLoopEnd,
        ShouldHaveRegister,
        MustHaveRegister;

        public static final RegisterPriority[] VALUES;

        public boolean greaterEqual(RegisterPriority other) {
            return this.ordinal() >= other.ordinal();
        }

        public boolean lessThan(RegisterPriority other) {
            return this.ordinal() < other.ordinal();
        }

        static {
            VALUES = RegisterPriority.values();
        }
    }

    static final class RegisterBindingLists {
        public Interval fixed;
        public Interval any;
        public Interval stack;

        RegisterBindingLists(Interval fixed, Interval any, Interval stack) {
            this.fixed = fixed;
            this.any = any;
            this.stack = stack;
        }

        public Interval get(RegisterBinding binding) {
            switch (binding) {
                case Any: {
                    return this.any;
                }
                case Fixed: {
                    return this.fixed;
                }
                case Stack: {
                    return this.stack;
                }
            }
            throw GraalError.shouldNotReachHere();
        }

        public void set(RegisterBinding binding, Interval list) {
            assert (list != null);
            switch (binding) {
                case Any: {
                    this.any = list;
                    break;
                }
                case Fixed: {
                    this.fixed = list;
                    break;
                }
                case Stack: {
                    this.stack = list;
                }
            }
        }

        public void addToListSortedByCurrentFromPositions(RegisterBinding binding, Interval interval) {
            Interval list = this.get(binding);
            Interval prev = null;
            Interval cur = list;
            while (cur.currentFrom() < interval.currentFrom()) {
                prev = cur;
                cur = cur.next;
            }
            Interval result = list;
            if (prev == null) {
                result = interval;
            } else {
                prev.next = interval;
            }
            interval.next = cur;
            this.set(binding, result);
        }

        public void addToListSortedByStartAndUsePositions(RegisterBinding binding, Interval interval) {
            Interval list = this.get(binding);
            Interval prev = null;
            Interval cur = list;
            while (cur.from() < interval.from() || cur.from() == interval.from() && cur.firstUsage(RegisterPriority.None) < interval.firstUsage(RegisterPriority.None)) {
                prev = cur;
                cur = cur.next;
            }
            if (prev == null) {
                list = interval;
            } else {
                prev.next = interval;
            }
            interval.next = cur;
            this.set(binding, list);
        }

        public void remove(RegisterBinding binding, Interval i) {
            Interval list = this.get(binding);
            Interval prev = null;
            Interval cur = list;
            while (cur != i) {
                assert (cur != null && !cur.isEndMarker()) : "interval has not been found in list: " + i;
                prev = cur;
                cur = cur.next;
            }
            if (prev == null) {
                this.set(binding, cur.next);
            } else {
                prev.next = cur.next;
            }
        }
    }
}

