/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@Opcode(value="ZERO_MEMORY")
public final class AArch64ZeroMemoryOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64ZeroMemoryOp> TYPE = LIRInstructionClass.create(AArch64ZeroMemoryOp.class);
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected Value addressValue;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected Value lengthValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value addressValueTemp;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value lengthValueTemp;
    private final boolean isAligned;
    private final boolean useDcZva;
    private final int zvaLength;

    public AArch64ZeroMemoryOp(Value address, Value length, boolean isAligned, boolean useDcZva, int zvaLength) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.addressValue = address;
        this.lengthValue = length;
        this.addressValueTemp = address;
        this.lengthValueTemp = length;
        this.useDcZva = useDcZva;
        this.zvaLength = zvaLength;
        this.isAligned = isAligned;
    }

    @Override
    protected void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register base = ValueUtil.asRegister((Value)this.addressValue);
        Register size = ValueUtil.asRegister((Value)this.lengthValue);
        try (AArch64MacroAssembler.ScratchRegister scratchRegister = masm.getScratchRegister();){
            Register alignmentBits = scratchRegister.getRegister();
            Label tail = new Label();
            Label done = new Label();
            masm.cbz(64, size, done);
            if (!this.isAligned) {
                Label baseAlignedTo2Bytes = new Label();
                Label baseAlignedTo4Bytes = new Label();
                Label baseAlignedTo8Bytes = new Label();
                masm.compare(64, size, 8);
                masm.branchConditionally(AArch64Assembler.ConditionFlag.LT, tail);
                masm.neg(64, alignmentBits, base);
                masm.and(64, alignmentBits, alignmentBits, 7L);
                masm.tbz(alignmentBits, 0, baseAlignedTo2Bytes);
                masm.sub(64, size, size, 1);
                masm.str(8, AArch64.zr, AArch64Address.createImmediateAddress(8, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, base, 1));
                masm.bind(baseAlignedTo2Bytes);
                masm.tbz(alignmentBits, 1, baseAlignedTo4Bytes);
                masm.sub(64, size, size, 2);
                masm.str(16, AArch64.zr, AArch64Address.createImmediateAddress(16, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, base, 2));
                masm.bind(baseAlignedTo4Bytes);
                masm.tbz(alignmentBits, 2, baseAlignedTo8Bytes);
                masm.sub(64, size, size, 4);
                masm.str(32, AArch64.zr, AArch64Address.createImmediateAddress(32, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, base, 4));
                masm.bind(baseAlignedTo8Bytes);
            }
            if (this.useDcZva && this.zvaLength > 0) {
                assert (CodeUtil.isPowerOf2((int)this.zvaLength) && 4 <= this.zvaLength && this.zvaLength <= 2048);
                Label preCheck = new Label();
                Label preLoop = new Label();
                Label mainCheck = new Label();
                Label mainLoop = new Label();
                Label postCheck = new Label();
                Label postLoop = new Label();
                masm.neg(64, alignmentBits, base);
                masm.and(64, alignmentBits, alignmentBits, this.zvaLength - 1);
                masm.cmp(64, size, alignmentBits);
                masm.branchConditionally(AArch64Assembler.ConditionFlag.LE, postCheck);
                masm.sub(64, size, size, alignmentBits);
                masm.jmp(preCheck);
                masm.align(crb.target.wordSize * 2);
                masm.bind(preLoop);
                masm.str(64, AArch64.zr, AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, base, 8));
                masm.bind(preCheck);
                masm.subs(64, alignmentBits, alignmentBits, 8);
                masm.branchConditionally(AArch64Assembler.ConditionFlag.GE, preLoop);
                masm.jmp(mainCheck);
                masm.align(crb.target.wordSize * 2);
                masm.bind(mainLoop);
                masm.dc(AArch64Assembler.DataCacheOperationType.ZVA, base);
                masm.add(64, base, base, this.zvaLength);
                masm.bind(mainCheck);
                masm.subs(64, size, size, this.zvaLength);
                masm.branchConditionally(AArch64Assembler.ConditionFlag.GE, mainLoop);
                masm.add(64, size, size, this.zvaLength);
                masm.jmp(postCheck);
                masm.align(crb.target.wordSize * 2);
                masm.bind(postLoop);
                masm.str(64, AArch64.zr, AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, base, 8));
                masm.bind(postCheck);
                masm.subs(64, size, size, 8);
                masm.branchConditionally(AArch64Assembler.ConditionFlag.GE, postLoop);
                if (!this.isAligned) {
                    masm.add(64, size, size, 8);
                }
            } else {
                Label mainCheck = new Label();
                Label mainLoop = new Label();
                if (!this.isAligned) {
                    masm.compare(64, size, 8);
                    masm.branchConditionally(AArch64Assembler.ConditionFlag.LT, tail);
                }
                masm.tbz(base, 3, mainCheck);
                masm.sub(64, size, size, 8);
                masm.str(64, AArch64.zr, AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, base, 8));
                masm.jmp(mainCheck);
                masm.align(crb.target.wordSize * 2);
                masm.bind(mainLoop);
                masm.stp(64, AArch64.zr, AArch64.zr, AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_PAIR_POST_INDEXED, base, 16));
                masm.bind(mainCheck);
                masm.subs(64, size, size, 16);
                masm.branchConditionally(AArch64Assembler.ConditionFlag.GE, mainLoop);
                masm.add(64, size, size, 16);
                masm.tbz(size, 3, tail);
                masm.str(64, AArch64.zr, AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, base, 8));
                if (!this.isAligned) {
                    masm.sub(64, size, size, 8);
                }
            }
            masm.bind(tail);
            if (!this.isAligned) {
                Label perByteZeroingLoop = new Label();
                masm.cbz(64, size, done);
                masm.align(crb.target.wordSize * 2);
                masm.bind(perByteZeroingLoop);
                masm.str(8, AArch64.zr, AArch64Address.createImmediateAddress(8, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, base, 1));
                masm.subs(64, size, size, 1);
                masm.branchConditionally(AArch64Assembler.ConditionFlag.NE, perByteZeroingLoop);
            }
            masm.bind(done);
        }
    }
}

