/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.ValueKind;

public class CastValue
extends AllocatableValue {
    private final AllocatableValue underlyingValue;

    public CastValue(ValueKind<?> kind, AllocatableValue underlyingValue) {
        super(kind);
        AllocatableValue inner = underlyingValue;
        while (inner instanceof CastValue) {
            assert (kind.getPlatformKind().getSizeInBytes() <= inner.getPlatformKind().getSizeInBytes());
            inner = ((CastValue)inner).underlyingValue;
        }
        assert (kind.getPlatformKind().getSizeInBytes() <= inner.getPlatformKind().getSizeInBytes()) : "can't cast " + inner + " " + inner.getPlatformKind() + " to larger kind " + kind.getPlatformKind();
        this.underlyingValue = inner;
    }

    public AllocatableValue underlyingValue() {
        return this.underlyingValue;
    }

    public String toString() {
        return "reinterpret: " + this.underlyingValue + " as: " + this.getValueKind();
    }

    public int hashCode() {
        return 47 * super.hashCode() + this.underlyingValue.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CastValue) {
            CastValue other = (CastValue)((Object)obj);
            return super.equals((Object)other) && this.underlyingValue.equals((Object)other.underlyingValue);
        }
        return false;
    }
}

