/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.bytecode.BytecodeStream;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.java.BciBlockMapping;
import org.graalvm.compiler.java.LargeLocalLiveness;
import org.graalvm.compiler.java.SmallLocalLiveness;

public abstract class LocalLiveness {
    protected final BciBlockMapping.BciBlock[] blocks;
    private final ArrayList<ArrayList<Integer>> asyncSuccessors;

    public static LocalLiveness compute(DebugContext debug, BytecodeStream stream, BciBlockMapping mapping, int maxLocals, int loopCount, boolean asyncLiveness) {
        LocalLiveness liveness = maxLocals <= 64 ? new SmallLocalLiveness(mapping, maxLocals, loopCount, asyncLiveness) : new LargeLocalLiveness(mapping, maxLocals, loopCount, asyncLiveness);
        liveness.computeLiveness(debug, stream);
        return liveness;
    }

    protected LocalLiveness(BciBlockMapping mapping, boolean asyncLiveness) {
        if (asyncLiveness && mapping.exceptionHandlers != null) {
            Pair<ArrayList<BciBlockMapping.BciBlock>, ArrayList<ArrayList<Integer>>> info = LocalLiveness.generateAsyncLivenessInfo(mapping);
            this.blocks = ((ArrayList)info.getLeft()).toArray(new BciBlockMapping.BciBlock[0]);
            this.asyncSuccessors = (ArrayList)info.getRight();
        } else {
            this.blocks = mapping.getBlocks();
            this.asyncSuccessors = null;
        }
    }

    private static Pair<ArrayList<BciBlockMapping.BciBlock>, ArrayList<ArrayList<Integer>>> generateAsyncLivenessInfo(BciBlockMapping mapping) {
        ArrayList<BciBlockMapping.BciBlock> blocks = new ArrayList<BciBlockMapping.BciBlock>(Arrays.asList(mapping.getBlocks()));
        ArrayList asyncSuccessors = new ArrayList();
        for (int id = 0; id < blocks.size(); ++id) {
            BciBlockMapping.BciBlock block = blocks.get(id);
            assert (block.getId() == id);
            assert (asyncSuccessors.size() == id);
            if (block.isInstructionBlock()) {
                BitSet handlerIDs = new BitSet();
                for (int bci = block.getStartBci(); bci <= block.getEndBci(); ++bci) {
                    BitSet bciHandlerIDs = mapping.getBciExceptionHandlerIDs(bci);
                    if (bciHandlerIDs == null) continue;
                    handlerIDs.or(bciHandlerIDs);
                }
                ArrayList<Integer> handlerBlockIDs = new ArrayList<Integer>();
                int handlerID = handlerIDs.nextSetBit(0);
                while (handlerID >= 0) {
                    BciBlockMapping.BciBlock handlerBlock = mapping.getHandlerBlock(handlerID);
                    if (handlerBlock.getId() == -1) {
                        int newID = blocks.size();
                        handlerBlock.setId(newID);
                        blocks.add(handlerBlock);
                    }
                    handlerBlockIDs.add(handlerBlock.getId());
                    if (handlerID == Integer.MAX_VALUE) break;
                    handlerID = handlerIDs.nextSetBit(handlerID + 1);
                }
                asyncSuccessors.add(handlerBlockIDs.isEmpty() ? null : handlerBlockIDs);
            } else {
                asyncSuccessors.add(null);
            }
            for (BciBlockMapping.BciBlock sux : block.getSuccessors()) {
                if (sux.getId() != -1) continue;
                int newID = blocks.size();
                sux.setId(newID);
                blocks.add(sux);
            }
        }
        return Pair.create(blocks, asyncSuccessors);
    }

    void computeLiveness(DebugContext debug, BytecodeStream stream) {
        boolean changed;
        for (BciBlockMapping.BciBlock block : this.blocks) {
            this.computeLocalLiveness(stream, block);
        }
        int iteration = 0;
        do {
            assert (LocalLiveness.traceIteration(debug, iteration));
            changed = false;
            for (int i = this.blocks.length - 1; i >= 0; --i) {
                int oldCardinality;
                boolean blockChanged;
                BciBlockMapping.BciBlock block;
                block = this.blocks[i];
                int blockID = block.getId();
                assert (this.traceStart(debug, block, blockID));
                boolean bl = blockChanged = iteration == 0;
                if (block.getSuccessorCount() > 0) {
                    oldCardinality = this.liveOutCardinality(blockID);
                    for (BciBlockMapping.BciBlock sux : block.getSuccessors()) {
                        assert (this.traceSuccessor(debug, sux));
                        this.propagateLiveness(blockID, sux.getId());
                    }
                    blockChanged |= oldCardinality != this.liveOutCardinality(blockID);
                }
                if (this.asyncSuccessors != null && this.asyncSuccessors.get(i) != null) {
                    oldCardinality = this.liveAsyncCardinality(blockID);
                    for (Integer suxId : this.asyncSuccessors.get(i)) {
                        this.propagateAsyncLiveness(blockID, suxId);
                    }
                    blockChanged |= oldCardinality != this.liveAsyncCardinality(blockID);
                }
                if (blockChanged) {
                    this.updateLiveness(blockID);
                    assert (this.traceEnd(debug, block, blockID));
                }
                changed |= blockChanged;
            }
            ++iteration;
        } while (changed);
    }

    private static boolean traceIteration(DebugContext debug, int iteration) {
        debug.log("Iteration %d", iteration);
        return true;
    }

    private boolean traceEnd(DebugContext debug, BciBlockMapping.BciBlock block, int blockID) {
        if (debug.isLogEnabled()) {
            debug.logv("  end   B%d  [%d, %d]  in: %s  out: %s  gen: %s  kill: %s", block.getId(), block.startBci, block.getEndBci(), this.debugLiveIn(blockID), this.debugLiveOut(blockID), this.debugLiveGen(blockID), this.debugLiveKill(blockID));
        }
        return true;
    }

    private boolean traceSuccessor(DebugContext debug, BciBlockMapping.BciBlock sux) {
        if (debug.isLogEnabled()) {
            debug.log("    Successor B%d: %s", sux.getId(), (Object)this.debugLiveIn(sux.getId()));
        }
        return true;
    }

    private boolean traceStart(DebugContext debug, BciBlockMapping.BciBlock block, int blockID) {
        if (debug.isLogEnabled()) {
            debug.logv("  start B%d  [%d, %d]  in: %s  out: %s  gen: %s  kill: %s", block.getId(), block.startBci, block.getEndBci(), this.debugLiveIn(blockID), this.debugLiveOut(blockID), this.debugLiveGen(blockID), this.debugLiveKill(blockID));
        }
        return true;
    }

    public abstract boolean localIsLiveIn(BciBlockMapping.BciBlock var1, int var2);

    public abstract boolean localIsChangedInLoop(int var1, int var2);

    public abstract boolean localIsLiveOut(BciBlockMapping.BciBlock var1, int var2);

    protected abstract String debugLiveIn(int var1);

    protected abstract String debugLiveOut(int var1);

    protected abstract String debugLiveGen(int var1);

    protected abstract String debugLiveKill(int var1);

    protected abstract int liveOutCardinality(int var1);

    protected abstract int liveAsyncCardinality(int var1);

    protected abstract void propagateLiveness(int var1, int var2);

    protected abstract void propagateAsyncLiveness(int var1, int var2);

    protected abstract void updateLiveness(int var1);

    protected abstract void loadOne(int var1, int var2);

    protected abstract void storeOne(int var1, int var2);

    private void computeLocalLiveness(BytecodeStream stream, BciBlockMapping.BciBlock block) {
        if (!block.isInstructionBlock()) {
            return;
        }
        int blockID = block.getId();
        stream.setBCI(block.startBci);
        while (stream.currentBCI() <= block.getEndBci()) {
            switch (stream.currentBC()) {
                case 22: 
                case 24: {
                    this.loadTwo(blockID, stream.readLocalIndex());
                    break;
                }
                case 30: 
                case 38: {
                    this.loadTwo(blockID, 0);
                    break;
                }
                case 31: 
                case 39: {
                    this.loadTwo(blockID, 1);
                    break;
                }
                case 32: 
                case 40: {
                    this.loadTwo(blockID, 2);
                    break;
                }
                case 33: 
                case 41: {
                    this.loadTwo(blockID, 3);
                    break;
                }
                case 132: {
                    int localIndex = stream.readLocalIndex();
                    this.loadOne(blockID, localIndex);
                    this.storeOne(blockID, localIndex);
                    break;
                }
                case 21: 
                case 23: 
                case 25: 
                case 169: {
                    this.loadOne(blockID, stream.readLocalIndex());
                    break;
                }
                case 26: 
                case 34: 
                case 42: {
                    this.loadOne(blockID, 0);
                    break;
                }
                case 27: 
                case 35: 
                case 43: {
                    this.loadOne(blockID, 1);
                    break;
                }
                case 28: 
                case 36: 
                case 44: {
                    this.loadOne(blockID, 2);
                    break;
                }
                case 29: 
                case 37: 
                case 45: {
                    this.loadOne(blockID, 3);
                    break;
                }
                case 55: 
                case 57: {
                    this.storeTwo(blockID, stream.readLocalIndex());
                    break;
                }
                case 63: 
                case 71: {
                    this.storeTwo(blockID, 0);
                    break;
                }
                case 64: 
                case 72: {
                    this.storeTwo(blockID, 1);
                    break;
                }
                case 65: 
                case 73: {
                    this.storeTwo(blockID, 2);
                    break;
                }
                case 66: 
                case 74: {
                    this.storeTwo(blockID, 3);
                    break;
                }
                case 54: 
                case 56: 
                case 58: {
                    this.storeOne(blockID, stream.readLocalIndex());
                    break;
                }
                case 59: 
                case 67: 
                case 75: {
                    this.storeOne(blockID, 0);
                    break;
                }
                case 60: 
                case 68: 
                case 76: {
                    this.storeOne(blockID, 1);
                    break;
                }
                case 61: 
                case 69: 
                case 77: {
                    this.storeOne(blockID, 2);
                    break;
                }
                case 62: 
                case 70: 
                case 78: {
                    this.storeOne(blockID, 3);
                }
            }
            stream.next();
        }
    }

    private void loadTwo(int blockID, int local) {
        this.loadOne(blockID, local);
        this.loadOne(blockID, local + 1);
    }

    private void storeTwo(int blockID, int local) {
        this.storeOne(blockID, local);
        this.storeOne(blockID, local + 1);
    }
}

