/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractStateSplit;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueNodeUtil;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_64, size=NodeSize.SIZE_16, allowedUsageTypes={InputType.Memory})
public class UnsafeCopyMemoryNode
extends AbstractStateSplit
implements Lowerable,
SingleMemoryKill,
MemoryAccess {
    public static final NodeClass<UnsafeCopyMemoryNode> TYPE = NodeClass.create(UnsafeCopyMemoryNode.class);
    @Node.Input
    ValueNode receiver;
    @Node.Input
    ValueNode srcBase;
    @Node.Input
    ValueNode srcOffset;
    @Node.Input
    ValueNode destBase;
    @Node.Input
    ValueNode desOffset;
    @Node.Input
    ValueNode bytes;
    @Node.OptionalInput(value=InputType.Memory)
    MemoryKill lastLocationAccess;
    private final boolean guarded;

    public UnsafeCopyMemoryNode(boolean guarded, ValueNode receiver, ValueNode srcBase, ValueNode srcOffset, ValueNode destBase, ValueNode desOffset, ValueNode bytes) {
        super((NodeClass<? extends AbstractStateSplit>)TYPE, StampFactory.forVoid());
        this.guarded = guarded;
        this.receiver = receiver;
        this.srcBase = srcBase;
        this.srcOffset = srcOffset;
        this.destBase = destBase;
        this.desOffset = desOffset;
        this.bytes = bytes;
    }

    public boolean isGuarded() {
        return this.guarded;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return this.getKilledLocationIdentity();
    }

    @Override
    public MemoryKill getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    @Override
    public void setLastLocationAccess(MemoryKill lla) {
        this.updateUsages(ValueNodeUtil.asNode(this.lastLocationAccess), ValueNodeUtil.asNode(lla));
        this.lastLocationAccess = lla;
    }

    @Node.NodeIntrinsic
    public static native void copyMemory(@Node.ConstantNodeParameter boolean var0, Object var1, Object var2, long var3, Object var5, long var6, long var8);
}

