/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import java.util.Arrays;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.spi.ForeignCallSignature;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProviderImpl;
import org.graalvm.word.LocationIdentity;

public class HotSpotForeignCallDescriptor
extends ForeignCallDescriptor {
    private final Transition transition;
    private final Reexecutability reexecutability;

    public HotSpotForeignCallDescriptor(Transition transition, Reexecutability reexecutability, LocationIdentity[] killedLocations, String name, Class<?> resultType, Class<?> ... argumentTypes) {
        super(name, resultType, argumentTypes, reexecutability == Reexecutability.REEXECUTABLE, killedLocations, transition == Transition.SAFEPOINT, transition == Transition.SAFEPOINT);
        this.transition = transition;
        this.reexecutability = reexecutability;
    }

    public HotSpotForeignCallDescriptor(Transition transition, Reexecutability reexecutability, LocationIdentity killedLocation, String name, Class<?> resultType, Class<?> ... argumentTypes) {
        LocationIdentity[] locationIdentityArray;
        if (killedLocation == null) {
            locationIdentityArray = HotSpotForeignCallsProviderImpl.NO_LOCATIONS;
        } else {
            LocationIdentity[] locationIdentityArray2 = new LocationIdentity[1];
            locationIdentityArray = locationIdentityArray2;
            locationIdentityArray2[0] = killedLocation;
        }
        this(transition, reexecutability, locationIdentityArray, name, resultType, argumentTypes);
    }

    public HotSpotForeignCallDescriptor(ForeignCallSignature signature, Transition transition, Reexecutability reexecutability, LocationIdentity[] killedLocations) {
        this(transition, reexecutability, killedLocations, signature.getName(), signature.getResultType(), signature.getArgumentTypes());
    }

    public Transition getTransition() {
        return this.transition;
    }

    public Reexecutability getReexecutability() {
        return this.reexecutability;
    }

    @Override
    public String toString() {
        return "HotSpotForeignCallDescriptor{" + this.signature + ", isReexecutable=" + this.isReexecutable + ", canDeoptimize=" + this.canDeoptimize + ", isGuaranteedSafepoint=" + this.isGuaranteedSafepoint + ", killedLocations=" + Arrays.toString(this.killedLocations) + ", transition=" + this.transition + ", reexecutability=" + this.reexecutability + "}";
    }

    public static enum Reexecutability {
        NOT_REEXECUTABLE,
        REEXECUTABLE;

    }

    public static enum Transition {
        LEAF_NO_VZERO,
        LEAF,
        STACK_INSPECTABLE_LEAF,
        SAFEPOINT;

    }
}

