/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.gen;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.VirtualObject;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.JavaValue;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Value;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.spi.MetaAccessExtensionProvider;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.ImplicitLIRFrameState;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.NodeValueMap;
import org.graalvm.compiler.nodes.spi.NodeWithState;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.nodes.virtual.EscapeObjectState;
import org.graalvm.compiler.nodes.virtual.MaterializedObjectState;
import org.graalvm.compiler.nodes.virtual.VirtualBoxingNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectState;
import org.graalvm.compiler.serviceprovider.GraalServices;

public class DebugInfoBuilder {
    protected final NodeValueMap nodeValueMap;
    protected final MetaAccessExtensionProvider metaAccessExtensionProvider;
    protected final DebugContext debug;
    private static final JavaValue[] NO_JAVA_VALUES = new JavaValue[0];
    private static final JavaKind[] NO_JAVA_KINDS = new JavaKind[0];
    protected final EconomicMap<VirtualObjectNode, VirtualObject> virtualObjects = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
    protected final EconomicMap<VirtualObjectNode, EscapeObjectState> objectStates = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
    protected final Queue<VirtualObjectNode> pendingVirtualObjects = new ArrayDeque<VirtualObjectNode>();
    private static final CounterKey STATE_VIRTUAL_OBJECTS = DebugContext.counter("StateVirtualObjects");
    private static final CounterKey STATE_ILLEGALS = DebugContext.counter("StateIllegals");
    private static final CounterKey STATE_VARIABLES = DebugContext.counter("StateVariables");
    private static final CounterKey STATE_CONSTANTS = DebugContext.counter("StateConstants");

    public DebugInfoBuilder(NodeValueMap nodeValueMap, MetaAccessExtensionProvider metaAccessExtensionProvider, DebugContext debug) {
        this.nodeValueMap = nodeValueMap;
        this.metaAccessExtensionProvider = metaAccessExtensionProvider;
        this.debug = debug;
    }

    public LIRFrameState build(NodeWithState node, FrameState topState, LabelRef exceptionEdge, JavaConstant deoptReasonAndAction, JavaConstant deoptSpeculation) {
        assert (this.virtualObjects.size() == 0);
        assert (this.objectStates.size() == 0);
        assert (this.pendingVirtualObjects.size() == 0);
        boolean validForDeoptimization = true;
        FrameState current = topState;
        do {
            if (current.virtualObjectMappingCount() > 0) {
                for (EscapeObjectState state : current.virtualObjectMappings()) {
                    if (this.objectStates.containsKey((Object)state.object()) || state instanceof MaterializedObjectState && ((MaterializedObjectState)state).materializedValue() == state.object()) continue;
                    this.objectStates.put((Object)state.object(), (Object)state);
                }
            }
            boolean bl = validForDeoptimization = validForDeoptimization && current.isValidForDeoptimization();
        } while ((current = current.outerFrameState()) != null);
        assert (this.verifyFrameState(node, topState));
        BytecodeFrame frame = this.computeFrameForState(node, topState);
        VirtualObject[] virtualObjectsArray = null;
        if (this.virtualObjects.size() != 0) {
            VirtualObjectNode vobjNode;
            while ((vobjNode = this.pendingVirtualObjects.poll()) != null) {
                JavaKind[] slotKinds;
                JavaValue[] values;
                VirtualObject vobjValue = (VirtualObject)this.virtualObjects.get((Object)vobjNode);
                assert (vobjValue.getValues() == null);
                int entryCount = vobjNode.entryCount();
                if (entryCount == 0) {
                    values = NO_JAVA_VALUES;
                    slotKinds = NO_JAVA_KINDS;
                } else {
                    values = new JavaValue[entryCount];
                    slotKinds = new JavaKind[entryCount];
                }
                if (values.length > 0) {
                    VirtualObjectState currentField = (VirtualObjectState)this.objectStates.get((Object)vobjNode);
                    assert (currentField != null);
                    int pos = 0;
                    for (int i = 0; i < entryCount; ++i) {
                        ValueNode value = (ValueNode)currentField.values().get(i);
                        if (value == null) {
                            JavaKind entryKind = vobjNode.entryKind(this.metaAccessExtensionProvider, i);
                            values[pos] = JavaConstant.defaultForKind((JavaKind)entryKind.getStackKind());
                            slotKinds[pos] = entryKind.getStackKind();
                            ++pos;
                            continue;
                        }
                        if (!value.isConstant() || value.asJavaConstant().getJavaKind() != JavaKind.Illegal) {
                            values[pos] = this.toJavaValue(value);
                            slotKinds[pos] = DebugInfoBuilder.toSlotKind(value);
                            ++pos;
                            continue;
                        }
                        assert (value.getStackKind() == JavaKind.Illegal);
                        ValueNode previousValue = (ValueNode)currentField.values().get(i - 1);
                        assert (previousValue != null && previousValue.getStackKind().needsTwoSlots() || vobjNode.isVirtualByteArray(this.metaAccessExtensionProvider)) : vobjNode + " " + i + " " + previousValue + " " + currentField.values().snapshot();
                        if (vobjNode.isVirtualByteArray(this.metaAccessExtensionProvider)) {
                            values[pos] = Value.ILLEGAL;
                            slotKinds[pos] = JavaKind.Illegal;
                            ++pos;
                            continue;
                        }
                        if (previousValue != null && previousValue.getStackKind().needsTwoSlots()) continue;
                        JavaKind entryKind = vobjNode.entryKind(this.metaAccessExtensionProvider, i);
                        values[pos] = JavaConstant.defaultForKind((JavaKind)entryKind.getStackKind());
                        slotKinds[pos] = entryKind.getStackKind();
                        ++pos;
                    }
                    if (pos != entryCount) {
                        values = Arrays.copyOf(values, pos);
                        slotKinds = Arrays.copyOf(slotKinds, pos);
                    }
                }
                assert (this.checkValues(vobjValue.getType(), values, slotKinds));
                vobjValue.setValues(values, slotKinds);
            }
            virtualObjectsArray = new VirtualObject[this.virtualObjects.size()];
            int index = 0;
            for (VirtualObject value : this.virtualObjects.getValues()) {
                virtualObjectsArray[index++] = value;
            }
            this.virtualObjects.clear();
        }
        this.objectStates.clear();
        if (deoptReasonAndAction == null && deoptSpeculation == null) {
            return new LIRFrameState(frame, virtualObjectsArray, exceptionEdge, validForDeoptimization);
        }
        return new ImplicitLIRFrameState(frame, virtualObjectsArray, exceptionEdge, deoptReasonAndAction, deoptSpeculation, validForDeoptimization);
    }

    private boolean checkValues(ResolvedJavaType type, JavaValue[] values, JavaKind[] slotKinds) {
        block17: {
            assert (values == null == (slotKinds == null));
            if (values == null) break block17;
            assert (values.length == slotKinds.length);
            if (!type.isArray()) {
                Object[] fields = type.getInstanceFields(true);
                int fieldIndex = 0;
                int valueIndex = 0;
                while (valueIndex < values.length) {
                    ResolvedJavaField field = fields[fieldIndex];
                    JavaKind valKind = slotKinds[valueIndex].getStackKind();
                    JavaKind fieldKind = this.storageKind(field.getType());
                    if ((valKind == JavaKind.Double || valKind == JavaKind.Long) && fieldKind == JavaKind.Int) {
                        assert (fieldIndex + 1 < fields.length) : String.format("Not enough fields for fieldIndex = %d valueIndex = %d %s %s", fieldIndex, valueIndex, Arrays.toString(fields), Arrays.toString(values));
                        assert (this.storageKind(fields[fieldIndex + 1].getType()) == JavaKind.Int) : String.format("fieldIndex = %d valueIndex = %d %s %s %s", fieldIndex, valueIndex, this.storageKind(fields[fieldIndex + 1].getType()), Arrays.toString(fields), Arrays.toString(values));
                        ++fieldIndex;
                    } else assert (valKind == fieldKind.getStackKind()) : field + ": " + valKind + " != " + fieldKind;
                    ++valueIndex;
                    ++fieldIndex;
                }
                assert (fields.length == fieldIndex) : type + ": fields=" + Arrays.toString(fields) + ", field values=" + Arrays.toString(values);
            } else {
                JavaKind componentKind = this.storageKind((JavaType)type.getComponentType()).getStackKind();
                if (componentKind == JavaKind.Object) {
                    for (int i = 0; i < values.length; ++i) {
                        assert (slotKinds[i].isObject()) : slotKinds[i] + " != " + componentKind;
                    }
                } else {
                    for (int i = 0; i < values.length; ++i) {
                        assert (slotKinds[i] == componentKind || slotKinds[i] == JavaKind.Illegal && this.storageKind((JavaType)type.getComponentType()) == JavaKind.Byte || componentKind.getBitCount() >= slotKinds[i].getBitCount() || componentKind == JavaKind.Int && slotKinds[i].getBitCount() >= JavaKind.Int.getBitCount()) : slotKinds[i] + " != " + componentKind;
                    }
                }
            }
        }
        return true;
    }

    protected JavaKind storageKind(JavaType type) {
        return type.getJavaKind();
    }

    protected boolean verifyFrameState(NodeWithState node, FrameState topState) {
        return true;
    }

    protected BytecodeFrame computeFrameForState(NodeWithState node, FrameState state) {
        try {
            assert (state.bci != -6);
            assert (state.bci != -5);
            assert (state.bci != -2 || state.locksSize() == 0);
            assert (state.bci != -3 || state.locksSize() == 0);
            assert (state.bci != -4 || state.locksSize() == 0);
            assert (!state.getMethod().isSynchronized() || state.bci == -2 || state.bci == -3 || state.bci == -4 || state.locksSize() > 0);
            assert (state.verify());
            int numLocals = state.localsSize();
            int numStack = state.stackSize();
            int numLocks = state.locksSize();
            int numValues = numLocals + numStack + numLocks;
            int numKinds = numLocals + numStack;
            JavaValue[] values = numValues == 0 ? NO_JAVA_VALUES : new JavaValue[numValues];
            JavaKind[] slotKinds = numKinds == 0 ? NO_JAVA_KINDS : new JavaKind[numKinds];
            this.computeLocals(state, numLocals, values, slotKinds);
            this.computeStack(state, numLocals, numStack, values, slotKinds);
            this.computeLocks(state, values);
            BytecodeFrame caller = null;
            if (state.outerFrameState() != null) {
                caller = this.computeFrameForState(node, state.outerFrameState());
            }
            if (!state.canProduceBytecodeFrame()) {
                String ste = state.getCode() != null ? state.getCode().asStackTraceElement(state.bci).toString() : state.toString();
                throw new GraalError("Frame state for %s cannot be converted to a BytecodeFrame since the frame state's code is not the same as the frame state method's code", ste);
            }
            return new BytecodeFrame(caller, state.getMethod(), state.bci, state.rethrowException(), state.duringCall(), values, slotKinds, numLocals, numStack, numLocks);
        }
        catch (GraalError e) {
            throw e.addContext("FrameState: ", state);
        }
    }

    protected void computeLocals(FrameState state, int numLocals, JavaValue[] values, JavaKind[] slotKinds) {
        for (int i = 0; i < numLocals; ++i) {
            ValueNode local = state.localAt(i);
            values[i] = this.toJavaValue(local);
            slotKinds[i] = DebugInfoBuilder.toSlotKind(local);
        }
    }

    protected void computeStack(FrameState state, int numLocals, int numStack, JavaValue[] values, JavaKind[] slotKinds) {
        for (int i = 0; i < numStack; ++i) {
            ValueNode stack = state.stackAt(i);
            values[numLocals + i] = this.toJavaValue(stack);
            slotKinds[numLocals + i] = DebugInfoBuilder.toSlotKind(stack);
        }
    }

    protected void computeLocks(FrameState state, JavaValue[] values) {
        for (int i = 0; i < state.locksSize(); ++i) {
            values[state.localsSize() + state.stackSize() + i] = this.computeLockValue(state, i);
        }
    }

    protected JavaValue computeLockValue(FrameState state, int i) {
        return this.toJavaValue(state.lockAt(i));
    }

    private static JavaKind toSlotKind(ValueNode value) {
        if (value == null) {
            return JavaKind.Illegal;
        }
        return value.getStackKind();
    }

    protected JavaValue toJavaValue(ValueNode value) {
        try {
            if (value instanceof VirtualObjectNode) {
                VirtualObjectNode obj = (VirtualObjectNode)value;
                EscapeObjectState state = (EscapeObjectState)this.objectStates.get((Object)obj);
                if (state == null && obj.entryCount() > 0) {
                    throw new GraalError("no mapping found for virtual object %s", obj);
                }
                if (state instanceof MaterializedObjectState) {
                    return this.toJavaValue(((MaterializedObjectState)state).materializedValue());
                }
                assert (obj.entryCount() == 0 || state instanceof VirtualObjectState);
                VirtualObject vobject = (VirtualObject)this.virtualObjects.get((Object)obj);
                if (vobject == null) {
                    boolean isAutoBox = obj instanceof VirtualBoxingNode;
                    vobject = GraalServices.createVirtualObject(obj.type(), this.virtualObjects.size(), isAutoBox);
                    this.virtualObjects.put((Object)obj, (Object)vobject);
                    this.pendingVirtualObjects.add(obj);
                }
                STATE_VIRTUAL_OBJECTS.increment(this.debug);
                return vobject;
            }
            ValueNode unproxied = GraphUtil.unproxify(value);
            if (unproxied instanceof ConstantNode) {
                STATE_CONSTANTS.increment(this.debug);
                return unproxied.asJavaConstant();
            }
            if (value != null) {
                STATE_VARIABLES.increment(this.debug);
                Value operand = this.nodeValueMap.operand(value);
                if (operand instanceof ConstantValue && ((ConstantValue)operand).isJavaConstant()) {
                    return ((ConstantValue)operand).getJavaConstant();
                }
                if (LIRValueUtil.isVariable(operand)) {
                    return LIRValueUtil.asVariable(operand);
                }
                assert (operand instanceof RegisterValue) : operand + " for " + value;
                return (JavaValue)operand;
            }
            STATE_ILLEGALS.increment(this.debug);
            return Value.ILLEGAL;
        }
        catch (GraalError e) {
            throw e.addContext("toValue: ", value);
        }
    }
}

