/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.cfg;

import java.util.Collection;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.cfg.Loop;

public interface AbstractControlFlowGraph<T extends AbstractBlockBase<T>> {
    public static final int BLOCK_ID_INITIAL = -1;
    public static final int BLOCK_ID_VISITED = -2;

    public T[] getBlocks();

    public Collection<Loop<T>> getLoops();

    public T getStartBlock();

    public static boolean dominates(AbstractBlockBase<?> a, AbstractBlockBase<?> b) {
        if (!1.$assertionsDisabled && a == null) {
            throw new AssertionError();
        }
        if (!1.$assertionsDisabled && b == null) {
            throw new AssertionError();
        }
        int domNumberA = a.getDominatorNumber();
        int domNumberB = b.getDominatorNumber();
        return domNumberB >= domNumberA && domNumberB <= a.getMaxChildDominatorNumber();
    }

    public static boolean strictlyDominates(AbstractBlockBase<?> a, AbstractBlockBase<?> b) {
        return a != b && AbstractControlFlowGraph.dominates(a, b);
    }

    public static AbstractBlockBase<?> commonDominator(AbstractBlockBase<?> a, AbstractBlockBase<?> b) {
        AbstractBlockBase<?> bTemp;
        AbstractBlockBase<?> aTemp;
        int bDomDepth;
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a == b) {
            return a;
        }
        int aDomDepth = a.getDominatorDepth();
        if (aDomDepth > (bDomDepth = b.getDominatorDepth())) {
            aTemp = a;
            bTemp = b;
        } else {
            aTemp = b;
            bTemp = a;
        }
        return AbstractControlFlowGraph.commonDominatorHelper(aTemp, bTemp);
    }

    public static AbstractBlockBase<?> commonDominatorHelper(AbstractBlockBase<?> a, AbstractBlockBase<?> b) {
        int domNumberA = a.getDominatorNumber();
        AbstractBlockBase<?> result = b;
        while (domNumberA < result.getDominatorNumber()) {
            result = result.getDominator();
        }
        while (domNumberA > result.getMaxChildDominatorNumber()) {
            result = result.getDominator();
        }
        return result;
    }

    public static <T extends AbstractBlockBase<T>> T commonDominatorTyped(T a, T b) {
        return (T)AbstractControlFlowGraph.commonDominator(a, b);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

