/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.amd64;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.amd64.AMD64AddressLowering;
import org.graalvm.compiler.core.amd64.AMD64AddressNode;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.Stride;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.CompressionNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

public abstract class AMD64CompressAddressLowering
extends AMD64AddressLowering {
    private static final CounterKey counterFoldedUncompressDuringAddressLowering = DebugContext.counter("FoldedUncompressDuringAddressLowering");

    @Override
    protected final boolean improve(StructuredGraph graph, DebugContext debug, AMD64AddressNode addr, boolean isBaseNegated, boolean isIndexNegated) {
        if (super.improve(graph, debug, addr, isBaseNegated, isIndexNegated)) {
            return true;
        }
        if (!isBaseNegated && !isIndexNegated && addr.getScale() == Stride.S1) {
            ValueNode base = addr.getBase();
            ValueNode index = addr.getIndex();
            if (this.tryToImproveUncompression(addr, index, base) || this.tryToImproveUncompression(addr, base, index)) {
                counterFoldedUncompressDuringAddressLowering.increment(debug);
                return true;
            }
        }
        return false;
    }

    private boolean tryToImproveUncompression(AMD64AddressNode addr, ValueNode value, ValueNode other) {
        CompressionNode compression;
        return value instanceof CompressionNode && (compression = (CompressionNode)value).getOp() == CompressionNode.CompressionOp.Uncompress && this.improveUncompression(addr, compression, other);
    }

    protected abstract boolean improveUncompression(AMD64AddressNode var1, CompressionNode var2, ValueNode var3);

    @NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
    public static class HeapBaseNode
    extends FloatingNode
    implements LIRLowerable {
        public static final NodeClass<HeapBaseNode> TYPE = NodeClass.create(HeapBaseNode.class);
        private final Register heapBaseRegister;

        public HeapBaseNode(Register heapBaseRegister) {
            super((NodeClass<? extends FloatingNode>)TYPE, StampFactory.pointer());
            this.heapBaseRegister = heapBaseRegister;
        }

        @Override
        public void generate(NodeLIRBuilderTool generator) {
            LIRKind kind = generator.getLIRGeneratorTool().getLIRKind(this.stamp(NodeView.DEFAULT));
            generator.setResult(this, (Value)this.heapBaseRegister.asValue((ValueKind)kind));
        }
    }
}

