/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.storage;

import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.spark.status.api.v1.ExecutorSummary;
import org.apache.spark.status.api.v1.RDDPartitionInfo;
import org.apache.spark.ui.PagedTable;
import org.apache.spark.ui.storage.BlockDataSource;
import org.apache.spark.ui.storage.BlockTableRowData;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.xml.Elem;
import scala.xml.EntityRef;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Unparsed;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra!\u0002\n\u0014\u0001Ui\u0002\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\t\u0011e\u0002!\u0011!Q\u0001\niB\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t#\u0002\u0011\t\u0011)A\u0005]!A!\u000b\u0001B\u0001B\u0003%1\u000b\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003X\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0015!\u0007\u0001\"\u0011f\u0011\u00151\u0007\u0001\"\u0011f\u0011\u00159\u0007\u0001\"\u0011f\u0011\u0015A\u0007\u0001\"\u0011f\u0011\u001dI\u0007A1A\u0005B)DaA\u001c\u0001!\u0002\u0013Y\u0007\"B8\u0001\t\u0003\u0002\b\"B:\u0001\t\u0003*\u0007\"\u0002;\u0001\t\u0003*\b\"B?\u0001\t\u0003r(a\u0004\"m_\u000e\\\u0007+Y4fIR\u000b'\r\\3\u000b\u0005Q)\u0012aB:u_J\fw-\u001a\u0006\u0003-]\t!!^5\u000b\u0005aI\u0012!B:qCJ\\'B\u0001\u000e\u001c\u0003\u0019\t\u0007/Y2iK*\tA$A\u0002pe\u001e\u001c2\u0001\u0001\u0010%!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fMB\u0019QE\n\u0015\u000e\u0003UI!aJ\u000b\u0003\u0015A\u000bw-\u001a3UC\ndW\r\u0005\u0002*U5\t1#\u0003\u0002,'\t\t\"\t\\8dWR\u000b'\r\\3S_^$\u0015\r^1\u0002\u0011\t\f7/\u001a)bi\"\u001c\u0001\u0001\u0005\u00020m9\u0011\u0001\u0007\u000e\t\u0003c\u0001j\u0011A\r\u0006\u0003g5\na\u0001\u0010:p_Rt\u0014BA\u001b!\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0007\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005U\u0002\u0013!\u0004:eIB\u000b'\u000f^5uS>t7\u000fE\u0002<\u0001\u000es!\u0001\u0010 \u000f\u0005Ej\u0014\"A\u0011\n\u0005}\u0002\u0013a\u00029bG.\fw-Z\u0005\u0003\u0003\n\u00131aU3r\u0015\ty\u0004\u0005\u0005\u0002E\u00176\tQI\u0003\u0002G\u000f\u0006\u0011a/\r\u0006\u0003\u0011&\u000b1!\u00199j\u0015\tQu#\u0001\u0004ti\u0006$Xo]\u0005\u0003\u0019\u0016\u0013\u0001C\u0015#E!\u0006\u0014H/\u001b;j_:LeNZ8\u0002\u0011A\fw-Z*ju\u0016\u0004\"aH(\n\u0005A\u0003#aA%oi\u0006Q1o\u001c:u\u0007>dW/\u001c8\u0002\t\u0011,7o\u0019\t\u0003?QK!!\u0016\u0011\u0003\u000f\t{w\u000e\\3b]\u0006\tR\r_3dkR|'oU;n[\u0006\u0014\u0018.Z:\u0011\u0007m\u0002\u0005\f\u0005\u0002E3&\u0011!,\u0012\u0002\u0010\u000bb,7-\u001e;peN+X.\\1ss\u00061A(\u001b8jiz\"r!\u00180`A\u0006\u00147\r\u0005\u0002*\u0001!)Af\u0002a\u0001]!)\u0011h\u0002a\u0001u!)Qj\u0002a\u0001\u001d\")\u0011k\u0002a\u0001]!)!k\u0002a\u0001'\")ak\u0002a\u0001/\u00069A/\u00192mK&#W#\u0001\u0018\u0002\u001bQ\f'\r\\3DgN\u001cE.Y:t\u0003E\u0001\u0018mZ3TSj,gi\u001c:n\r&,G\u000eZ\u0001\u0014a\u0006<WMT;nE\u0016\u0014hi\u001c:n\r&,G\u000eZ\u0001\u000bI\u0006$\u0018mU8ve\u000e,W#A6\u0011\u0005%b\u0017BA7\u0014\u0005=\u0011En\\2l\t\u0006$\u0018mU8ve\u000e,\u0017a\u00033bi\u0006\u001cv.\u001e:dK\u0002\n\u0001\u0002]1hK2Kgn\u001b\u000b\u0003]EDQA\u001d\bA\u00029\u000bA\u0001]1hK\u0006\u0001rm\u001c\"viR|gNR8s[B\u000bG\u000f[\u0001\bQ\u0016\fG-\u001a:t+\u00051\bcA\u001eAoB\u0011\u0001p_\u0007\u0002s*\u0011!\u0010I\u0001\u0004q6d\u0017B\u0001?z\u0005\u0011qu\u000eZ3\u0002\u0007I|w\u000f\u0006\u0002w\u007f\"1\u0011\u0011A\tA\u0002!\nQA\u00197pG.\u0004")
public class BlockPagedTable
implements PagedTable<BlockTableRowData> {
    private final String basePath;
    private final int pageSize;
    private final String sortColumn;
    private final boolean desc;
    private final BlockDataSource dataSource;

    @Override
    public Seq<Node> table(int page) {
        return PagedTable.table$(this, page);
    }

    @Override
    public Seq<Node> pageNavigation(int page, int pageSize, int totalPages, String navigationId) {
        return PagedTable.pageNavigation$(this, page, pageSize, totalPages, navigationId);
    }

    @Override
    public String pageNavigation$default$4() {
        return PagedTable.pageNavigation$default$4$(this);
    }

    @Override
    public String tableId() {
        return "rdd-storage-by-block-table";
    }

    @Override
    public String tableCssClass() {
        return "table table-bordered table-condensed table-striped table-head-clickable";
    }

    @Override
    public String pageSizeFormField() {
        return "block.pageSize";
    }

    @Override
    public String pageNumberFormField() {
        return "block.page";
    }

    public BlockDataSource dataSource() {
        return this.dataSource;
    }

    @Override
    public String pageLink(int page) {
        String encodedSortColumn = URLEncoder.encode(this.sortColumn, StandardCharsets.UTF_8.name());
        return new StringBuilder(28).append(this.basePath).append("&").append(this.pageNumberFormField()).append("=").append(page).append("&block.sort=").append(encodedSortColumn).append("&block.desc=").append(this.desc).append("&").append(this.pageSizeFormField()).append("=").append(this.pageSize).toString();
    }

    @Override
    public String goButtonFormPath() {
        String encodedSortColumn = URLEncoder.encode(this.sortColumn, StandardCharsets.UTF_8.name());
        return new StringBuilder(24).append(this.basePath).append("&block.sort=").append(encodedSortColumn).append("&block.desc=").append(this.desc).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<Node> headers() {
        void var3_3;
        Seq blockHeaders = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Block Name", "Storage Level", "Size in Memory", "Size on Disk", "Executors"}));
        if (!blockHeaders.contains((Object)this.sortColumn)) {
            throw new IllegalArgumentException(new StringBuilder(16).append("Unknown column: ").append(this.sortColumn).toString());
        }
        Seq headerRow = (Seq)blockHeaders.map((Function1 & Serializable & scala.Serializable)header -> {
            Elem elem;
            String string = header;
            String string2 = $this.sortColumn;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Unparsed headerLink = Unparsed$.MODULE$.apply(new StringBuilder(40).append($this.basePath).append("&block.sort=").append(URLEncoder.encode(header, StandardCharsets.UTF_8.name())).append("&block.desc=").append(!$this.desc).append("&block.pageSize=").append($this.pageSize).toString());
                String arrow = $this.desc ? "&#x25BE;" : "&#x25B4;";
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n            "));
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("href", (Seq)headerLink, (MetaData)$md);
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)new Text("\n              "));
                $buf2.$amp$plus(header);
                $buf2.$amp$plus((Object)new Text("\n              "));
                NodeBuffer $buf3 = new NodeBuffer();
                $buf3.$amp$plus((Object)new EntityRef("nbsp"));
                $buf3.$amp$plus((Object)Unparsed$.MODULE$.apply(arrow));
                $buf2.$amp$plus((Object)new Elem(null, "span", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
                $buf2.$amp$plus((Object)new Text("\n            "));
                $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
                $buf.$amp$plus((Object)new Text("\n          "));
                Elem elem2 = new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                elem = elem2;
            } else {
                Unparsed headerLink = Unparsed$.MODULE$.apply(new StringBuilder(28).append($this.basePath).append("&block.sort=").append(URLEncoder.encode(header, StandardCharsets.UTF_8.name())).append("&block.pageSize=").append($this.pageSize).toString());
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n            "));
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("href", (Seq)headerLink, (MetaData)$md);
                NodeBuffer $buf4 = new NodeBuffer();
                $buf4.$amp$plus((Object)new Text("\n              "));
                $buf4.$amp$plus(header);
                $buf4.$amp$plus((Object)new Text("\n            "));
                $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
                $buf.$amp$plus((Object)new Text("\n          "));
                Elem elem3 = new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                elem = elem3;
            }
            return elem;
        }, Seq$.MODULE$.canBuildFrom());
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)headerRow);
        return new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<Node> row(BlockTableRowData block) {
        void var2_2;
        void var3_3;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)block.blockName());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)block.storageLevel());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)Utils$.MODULE$.bytesToString(block.memoryUsed()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)Utils$.MODULE$.bytesToString(block.diskUsed()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)block.executors());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2);
    }

    public BlockPagedTable(String basePath, Seq<RDDPartitionInfo> rddPartitions, int pageSize, String sortColumn, boolean desc, Seq<ExecutorSummary> executorSummaries) {
        this.basePath = basePath;
        this.pageSize = pageSize;
        this.sortColumn = sortColumn;
        this.desc = desc;
        PagedTable.$init$(this);
        this.dataSource = new BlockDataSource(rddPartitions, pageSize, sortColumn, desc, (Map<String, String>)((TraversableOnce)executorSummaries.map((Function1 & Serializable & scala.Serializable)ex -> new Tuple2((Object)ex.id(), (Object)ex.hostPort()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }
}

