/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.ExecutorAllocationClient;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.BlacklistTracker$;
import org.apache.spark.scheduler.BlacklistTracker$ExecutorFailureList$TaskId$;
import org.apache.spark.scheduler.BlacklistedExecutor;
import org.apache.spark.scheduler.ExecutorFailuresInTaskSet;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.SparkListenerExecutorBlacklisted;
import org.apache.spark.scheduler.SparkListenerExecutorUnblacklisted;
import org.apache.spark.scheduler.SparkListenerNodeBlacklisted;
import org.apache.spark.scheduler.SparkListenerNodeUnblacklisted;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Iterable$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r}c!B-[\u0001i\u0013\u0007\u0002C8\u0001\u0005\u000b\u0007I\u0011B9\t\u0011Y\u0004!\u0011!Q\u0001\nID\u0001b\u001e\u0001\u0003\u0002\u0003\u0006I\u0001\u001f\u0005\ty\u0002\u0011\t\u0011)A\u0005{\"Q\u0011q\u0001\u0001\u0003\u0002\u0003\u0006I!!\u0003\t\u000f\u0005U\u0001\u0001\"\u0001\u0002\u0018!9\u0011Q\u0003\u0001\u0005\u0002\u0005\r\u0002\"CA\u0019\u0001\t\u0007I\u0011BA\u001a\u0011!\tY\u0004\u0001Q\u0001\n\u0005U\u0002\"CA\u001f\u0001\t\u0007I\u0011BA\u001a\u0011!\ty\u0004\u0001Q\u0001\n\u0005U\u0002\"CA!\u0001\t\u0007I\u0011AA\"\u0011!\tY\u0005\u0001Q\u0001\n\u0005\u0015\u0003\"CA'\u0001\t\u0007I\u0011BA(\u0011!\t9\u0006\u0001Q\u0001\n\u0005E\u0003\"CA-\u0001\t\u0007I\u0011BA.\u0011!\u0011\u0019\n\u0001Q\u0001\n\u0005u\u0003\"\u0003BK\u0001\t\u0007I\u0011\u0001BL\u0011!\u0011\t\u000b\u0001Q\u0001\n\te\u0005\"\u0003BR\u0001\t\u0007I\u0011\u0001BS\u0011!\u0011I\u000b\u0001Q\u0001\n\t\u001d\u0006\"\u0003BV\u0001\t\u0007I\u0011\u0002BW\u0011!\u00119\r\u0001Q\u0001\n\t=\u0006\"\u0003Be\u0001\u0001\u0007I\u0011AA\"\u0011%\u0011Y\r\u0001a\u0001\n\u0003\u0011i\r\u0003\u0005\u0003R\u0002\u0001\u000b\u0015BA#\u0011%\u0011\u0019\u000e\u0001b\u0001\n\u0003\u0011)\u000e\u0003\u0005\u0003`\u0002\u0001\u000b\u0011\u0002Bl\u0011\u001d\u0011\t\u000f\u0001C\u0001\u0005GDqA!:\u0001\t\u0013\u0011\u0019\u000fC\u0004\u0003h\u0002!IA!;\t\u000f\tM\b\u0001\"\u0003\u0003v\"A!\u0011 \u0001\u0005\u0002i\u0013Y\u0010C\u0004\u0003\u0000\u0002!Ia!\u0001\t\u000f\r\u001d\u0001\u0001\"\u0001\u0004\n!91\u0011\u0003\u0001\u0005\u0002\rM\u0001bBB\u0012\u0001\u0011\u00051Q\u0005\u0005\b\u0007W\u0001A\u0011AB\u0017\u0011\u001d\u0019y\u0003\u0001C\u0001\u0007cAqa!\u000e\u0001\t\u0003\u00199DB\u0004\u0002\b\u0002\u0011!,!#\t\u000f\u0005U\u0011\u0006\"\u0001\u0002\f\u001a1\u0011QR\u0015E\u0003\u001fC!\"!(,\u0005+\u0007I\u0011AA\u001a\u0011)\tyj\u000bB\tB\u0003%\u0011Q\u0007\u0005\u000b\u0003C[#Q3A\u0005\u0002\u0005M\u0002BCARW\tE\t\u0015!\u0003\u00026!Q\u0011QU\u0016\u0003\u0016\u0004%\t!a\r\t\u0015\u0005\u001d6F!E!\u0002\u0013\t)\u0004C\u0004\u0002\u0016-\"\t!!+\t\u0013\u0005U6&!A\u0005\u0002\u0005]\u0006\"CA`WE\u0005I\u0011AAa\u0011%\t9nKI\u0001\n\u0003\t\t\rC\u0005\u0002Z.\n\n\u0011\"\u0001\u0002B\"I\u00111\\\u0016\u0002\u0002\u0013\u0005\u0013Q\u001c\u0005\n\u0003[\\\u0013\u0011!C\u0001\u0003gA\u0011\"a<,\u0003\u0003%\t!!=\t\u0013\u0005u8&!A\u0005B\u0005}\b\"\u0003B\u0005W\u0005\u0005I\u0011\u0001B\u0006\u0011%\u0011yaKA\u0001\n\u0003\u0012\t\u0002C\u0005\u0003\u0014-\n\t\u0011\"\u0011\u0003\u0016!I!qC\u0016\u0002\u0002\u0013\u0005#\u0011D\u0004\n\u0005;I\u0013\u0011!E\u0005\u0005?1\u0011\"!$*\u0003\u0003EIA!\t\t\u000f\u0005U\u0001\t\"\u0001\u00030!I!1\u0003!\u0002\u0002\u0013\u0015#Q\u0003\u0005\n\u0005c\u0001\u0015\u0011!CA\u0005gA\u0011Ba\u000fA\u0003\u0003%\tI!\u0010\t\u0013\t-\u0013\u00061A\u0005\n\t5\u0003\"\u0003B.S\u0001\u0007I\u0011\u0002B/\u0011!\u00119'\u000bQ!\n\t=\u0003\"\u0003B5S\u0001\u0007I\u0011BA\"\u0011%\u0011Y'\u000ba\u0001\n\u0013\u0011i\u0007\u0003\u0005\u0003r%\u0002\u000b\u0015BA#\u0011\u001d\u0011\u0019(\u000bC\u0001\u0005kBqA!\"*\t\u0003\t\u0019\u0004C\u0004\u0003\b&\"\t!a\u0014\t\u000f\t%\u0015\u0006\"\u0001\u0003\f\"9!1C\u0015\u0005B\tEu\u0001CB\u001e5\"\u0005Al!\u0010\u0007\u000feS\u0006\u0012\u0001/\u0004@!9\u0011QC)\u0005\u0002\r\u0005\u0003\"CB\"#\n\u0007I\u0011BAo\u0011!\u0019)%\u0015Q\u0001\n\u0005}\u0007bBB$#\u0012\u00051\u0011\n\u0005\b\u0007\u001b\nF\u0011AB(\u0011\u001d\u0019\u0019&\u0015C\u0001\u0007+B\u0011b!\u0017R#\u0003%\taa\u0017\u0003!\tc\u0017mY6mSN$HK]1dW\u0016\u0014(BA.]\u0003%\u00198\r[3ek2,'O\u0003\u0002^=\u0006)1\u000f]1sW*\u0011q\fY\u0001\u0007CB\f7\r[3\u000b\u0003\u0005\f1a\u001c:h'\r\u00011-\u001b\t\u0003I\u001el\u0011!\u001a\u0006\u0002M\u0006)1oY1mC&\u0011\u0001.\u001a\u0002\u0007\u0003:L(+\u001a4\u0011\u0005)lW\"A6\u000b\u00051d\u0016\u0001C5oi\u0016\u0014h.\u00197\n\u00059\\'a\u0002'pO\u001eLgnZ\u0001\fY&\u001cH/\u001a8fe\n+8o\u0001\u0001\u0016\u0003I\u0004\"a\u001d;\u000e\u0003iK!!\u001e.\u0003\u001f1Kg/\u001a'jgR,g.\u001a:CkN\fA\u0002\\5ti\u0016tWM\u001d\"vg\u0002\nAaY8oMB\u0011\u0011P_\u0007\u00029&\u00111\u0010\u0018\u0002\n'B\f'o[\"p]\u001a\f\u0001#\u00197m_\u000e\fG/[8o\u00072LWM\u001c;\u0011\t\u0011t\u0018\u0011A\u0005\u0003\u007f\u0016\u0014aa\u00149uS>t\u0007cA=\u0002\u0004%\u0019\u0011Q\u0001/\u00031\u0015CXmY;u_J\fE\u000e\\8dCRLwN\\\"mS\u0016tG/A\u0003dY>\u001c7\u000e\u0005\u0003\u0002\f\u0005EQBAA\u0007\u0015\r\ty\u0001X\u0001\u0005kRLG.\u0003\u0003\u0002\u0014\u00055!!B\"m_\u000e\\\u0017A\u0002\u001fj]&$h\b\u0006\u0006\u0002\u001a\u0005m\u0011QDA\u0010\u0003C\u0001\"a\u001d\u0001\t\u000b=4\u0001\u0019\u0001:\t\u000b]4\u0001\u0019\u0001=\t\u000bq4\u0001\u0019A?\t\u0013\u0005\u001da\u0001%AA\u0002\u0005%ACBA\r\u0003K\ty\u0003C\u0004\u0002(\u001d\u0001\r!!\u000b\u0002\u0005M\u001c\u0007cA=\u0002,%\u0019\u0011Q\u0006/\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\t\u000bq<\u0001\u0019A?\u0002+5\u000b\u0005l\u0018$B\u00132+&+R*`!\u0016\u0013v,\u0012-F\u0007V\u0011\u0011Q\u0007\t\u0004I\u0006]\u0012bAA\u001dK\n\u0019\u0011J\u001c;\u0002-5\u000b\u0005l\u0018$B\u00132+&+R*`!\u0016\u0013v,\u0012-F\u0007\u0002\n\u0001$T!Y?\u001a\u000b\u0015\nT#E?\u0016CViQ0Q\u000bJ{fj\u0014#F\u0003ei\u0015\tW0G\u0003&cU\tR0F1\u0016\u001bu\fU#S?:{E)\u0012\u0011\u00021\tc\u0015iQ&M\u0013N#v\fV%N\u000b>+FkX'J\u00192K5+\u0006\u0002\u0002FA\u0019A-a\u0012\n\u0007\u0005%SM\u0001\u0003M_:<\u0017!\u0007\"M\u0003\u000e[E*S*U?RKU*R(V)~k\u0015\n\u0014'J'\u0002\nqD\u0011'B\u0007.c\u0015j\u0015+`\r\u0016#6\tS0G\u0003&cUKU#`\u000b:\u000b%\tT#E+\t\t\t\u0006E\u0002e\u0003'J1!!\u0016f\u0005\u001d\u0011un\u001c7fC:\f\u0001E\u0011'B\u0007.c\u0015j\u0015+`\r\u0016#6\tS0G\u0003&cUKU#`\u000b:\u000b%\tT#EA\u00059R\r_3dkR|'/\u00133U_\u001a\u000b\u0017\u000e\\;sK2K7\u000f^\u000b\u0003\u0003;\u0002\u0002\"a\u0018\u0002j\u00055\u00141Q\u0007\u0003\u0003CRA!a\u0019\u0002f\u00059Q.\u001e;bE2,'bAA4K\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005-\u0014\u0011\r\u0002\b\u0011\u0006\u001c\b.T1q!\u0011\ty'! \u000f\t\u0005E\u0014\u0011\u0010\t\u0004\u0003g*WBAA;\u0015\r\t9\b]\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005mT-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u007f\n\tI\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003w*\u0007cAACS5\t\u0001AA\nFq\u0016\u001cW\u000f^8s\r\u0006LG.\u001e:f\u0019&\u001cHoE\u0002*G&$\"!a!\u0003\rQ\u000b7o[%e'\u0019Y3-!%\u0002\u0018B\u0019A-a%\n\u0007\u0005UUMA\u0004Qe>$Wo\u0019;\u0011\u0007\u0011\fI*C\u0002\u0002\u001c\u0016\u0014AbU3sS\u0006d\u0017N_1cY\u0016\fQa\u001d;bO\u0016\faa\u001d;bO\u0016\u0004\u0013\u0001D:uC\u001e,\u0017\t\u001e;f[B$\u0018!D:uC\u001e,\u0017\t\u001e;f[B$\b%A\u0005uCN\\\u0017J\u001c3fq\u0006QA/Y:l\u0013:$W\r\u001f\u0011\u0015\u0011\u0005-\u0016qVAY\u0003g\u00032!!,,\u001b\u0005I\u0003bBAOe\u0001\u0007\u0011Q\u0007\u0005\b\u0003C\u0013\u0004\u0019AA\u001b\u0011\u001d\t)K\ra\u0001\u0003k\tAaY8qsRA\u00111VA]\u0003w\u000bi\fC\u0005\u0002\u001eN\u0002\n\u00111\u0001\u00026!I\u0011\u0011U\u001a\u0011\u0002\u0003\u0007\u0011Q\u0007\u0005\n\u0003K\u001b\u0004\u0013!a\u0001\u0003k\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002D*\"\u0011QGAcW\t\t9\r\u0005\u0003\u0002J\u0006MWBAAf\u0015\u0011\ti-a4\u0002\u0013Ut7\r[3dW\u0016$'bAAiK\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u00171\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u001c\t\u0005\u0003C\fY/\u0004\u0002\u0002d*!\u0011Q]At\u0003\u0011a\u0017M\\4\u000b\u0005\u0005%\u0018\u0001\u00026bm\u0006LA!a \u0002d\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAz\u0003s\u00042\u0001ZA{\u0013\r\t90\u001a\u0002\u0004\u0003:L\b\"CA~s\u0005\u0005\t\u0019AA\u001b\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!\u0011\u0001\t\u0007\u0005\u0007\u0011)!a=\u000e\u0005\u0005\u0015\u0014\u0002\u0002B\u0004\u0003K\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011\u000bB\u0007\u0011%\tYpOA\u0001\u0002\u0004\t\u00190\u0001\u0005iCND7i\u001c3f)\t\t)$\u0001\u0005u_N#(/\u001b8h)\t\ty.\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003#\u0012Y\u0002C\u0005\u0002|z\n\t\u00111\u0001\u0002t\u00061A+Y:l\u0013\u0012\u00042!!,A'\u0015\u0001%1EAL!1\u0011)Ca\u000b\u00026\u0005U\u0012QGAV\u001b\t\u00119CC\u0002\u0003*\u0015\fqA];oi&lW-\u0003\u0003\u0003.\t\u001d\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogQ\u0011!qD\u0001\u0006CB\u0004H.\u001f\u000b\t\u0003W\u0013)Da\u000e\u0003:!9\u0011QT\"A\u0002\u0005U\u0002bBAQ\u0007\u0002\u0007\u0011Q\u0007\u0005\b\u0003K\u001b\u0005\u0019AA\u001b\u0003\u001d)h.\u00199qYf$BAa\u0010\u0003HA!AM B!!%!'1IA\u001b\u0003k\t)$C\u0002\u0003F\u0015\u0014a\u0001V;qY\u0016\u001c\u0004\"\u0003B%\t\u0006\u0005\t\u0019AAV\u0003\rAH\u0005M\u0001\u0017M\u0006LG.\u001e:fg\u0006sG-\u0012=qSJLH+[7fgV\u0011!q\n\t\u0007\u0003?\u0012\tF!\u0016\n\t\tM\u0013\u0011\r\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000fE\u0004e\u0005/\nY+!\u0012\n\u0007\teSM\u0001\u0004UkBdWMM\u0001\u001bM\u0006LG.\u001e:fg\u0006sG-\u0012=qSJLH+[7fg~#S-\u001d\u000b\u0005\u0005?\u0012)\u0007E\u0002e\u0005CJ1Aa\u0019f\u0005\u0011)f.\u001b;\t\u0013\u0005mh)!AA\u0002\t=\u0013a\u00064bS2,(/Z:B]\u0012,\u0005\u0010]5ssRKW.Z:!\u00035i\u0017N\\#ya&\u0014\u0018\u0010V5nK\u0006\tR.\u001b8FqBL'/\u001f+j[\u0016|F%Z9\u0015\t\t}#q\u000e\u0005\n\u0003wL\u0015\u0011!a\u0001\u0003\u000b\na\"\\5o\u000bb\u0004\u0018N]=US6,\u0007%A\u0006bI\u00124\u0015-\u001b7ve\u0016\u001cH\u0003\u0003B0\u0005o\u0012IHa\u001f\t\u000f\u0005u5\n1\u0001\u00026!9\u0011\u0011U&A\u0002\u0005U\u0002b\u0002B?\u0017\u0002\u0007!qP\u0001\u0012M\u0006LG.\u001e:fg&sG+Y:l'\u0016$\bcA:\u0003\u0002&\u0019!1\u0011.\u00033\u0015CXmY;u_J4\u0015-\u001b7ve\u0016\u001c\u0018J\u001c+bg.\u001cV\r^\u0001\u0016]VlWK\\5rk\u0016$\u0016m]6GC&dWO]3t\u0003\u001dI7/R7qif\fQ\u0004\u001a:pa\u001a\u000b\u0017\u000e\\;sKN<\u0016\u000e\u001e5US6,w.\u001e;CK\u001a|'/\u001a\u000b\u0005\u0005?\u0012i\tC\u0004\u0003\u0010:\u0003\r!!\u0012\u0002\u0015\u0011\u0014x\u000e\u001d\"fM>\u0014X\r\u0006\u0002\u0002n\u0005AR\r_3dkR|'/\u00133U_\u001a\u000b\u0017\u000e\\;sK2K7\u000f\u001e\u0011\u00027\u0015DXmY;u_JLE\rV8CY\u0006\u001c7\u000e\\5tiN#\u0018\r^;t+\t\u0011I\n\u0005\u0005\u0002`\u0005%\u0014Q\u000eBN!\r\u0019(QT\u0005\u0004\u0005?S&a\u0005\"mC\u000e\\G.[:uK\u0012,\u00050Z2vi>\u0014\u0018\u0001H3yK\u000e,Ho\u001c:JIR{'\t\\1dW2L7\u000f^*uCR,8\u000fI\u0001\u001c]>$W-\u00133U_\nc\u0017mY6mSN$X\t\u001f9jef$\u0016.\\3\u0016\u0005\t\u001d\u0006\u0003CA0\u0003S\ni'!\u0012\u000299|G-Z%e)>\u0014E.Y2lY&\u001cH/\u0012=qSJLH+[7fA\u0005qqL\\8eK\nc\u0017mY6mSN$XC\u0001BX!\u0019\u0011\tL!0\u0003B6\u0011!1\u0017\u0006\u0005\u0005k\u00139,\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0005s\u0013Y,\u0001\u0006d_:\u001cWO\u001d:f]RTA!a\u0004\u0002h&!!q\u0018BZ\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007CBA8\u0005\u0007\fi'\u0003\u0003\u0003F\u0006\u0005%aA*fi\u0006yqL\\8eK\nc\u0017mY6mSN$\b%\u0001\boKb$X\t\u001f9jef$\u0016.\\3\u0002%9,\u0007\u0010^#ya&\u0014\u0018\u0010V5nK~#S-\u001d\u000b\u0005\u0005?\u0012y\rC\u0005\u0002|f\t\t\u00111\u0001\u0002F\u0005ya.\u001a=u\u000bb\u0004\u0018N]=US6,\u0007%\u0001\fo_\u0012,Gk\u001c\"mC\u000e\\G.[:uK\u0012,\u00050Z2t+\t\u00119\u000e\u0005\u0005\u0002`\u0005%\u0014Q\u000eBm!\u0019\tyFa7\u0002n%!!Q\\A1\u0005\u001dA\u0015m\u001d5TKR\fqC\\8eKR{'\t\\1dW2L7\u000f^3e\u000bb,7m\u001d\u0011\u0002+\u0005\u0004\b\u000f\\=CY\u0006\u001c7\u000e\\5tiRKW.Z8viR\u0011!qL\u0001\u0015kB$\u0017\r^3OKb$X\t\u001f9jef$\u0016.\\3\u0002\u0019-LG\u000e\\#yK\u000e,Ho\u001c:\u0015\r\t}#1\u001eBx\u0011\u001d\u0011io\ba\u0001\u0003[\nA!\u001a=fG\"9!\u0011_\u0010A\u0002\u00055\u0014aA7tO\u000692.\u001b7m\u00052\f7m\u001b7jgR,G-\u0012=fGV$xN\u001d\u000b\u0005\u0005?\u00129\u0010C\u0004\u0003n\u0002\u0002\r!!\u001c\u00027-LG\u000e\u001c\"mC\u000e\\G.[:uK\u0012LE\r\\3Fq\u0016\u001cW\u000f^8s)\u0011\u0011yF!@\t\u000f\t5\u0018\u00051\u0001\u0002n\u0005q2.\u001b7m\u000bb,7-\u001e;peN|eN\u00117bG.d\u0017n\u001d;fI:{G-\u001a\u000b\u0005\u0005?\u001a\u0019\u0001C\u0004\u0004\u0006\t\u0002\r!!\u001c\u0002\t9|G-Z\u0001\u001fkB$\u0017\r^3CY\u0006\u001c7\u000e\\5ti\u001a{'OR3uG\"4\u0015-\u001b7ve\u0016$bAa\u0018\u0004\f\r=\u0001bBB\u0007G\u0001\u0007\u0011QN\u0001\u0005Q>\u001cH\u000fC\u0004\u0003n\u000e\u0002\r!!\u001c\u0002GU\u0004H-\u0019;f\u00052\f7m\u001b7jgR4uN]*vG\u000e,7o\u001d4vYR\u000b7o[*fiRA!qLB\u000b\u00073\u0019i\u0002C\u0004\u0004\u0018\u0011\u0002\r!!\u000e\u0002\u000fM$\u0018mZ3JI\"911\u0004\u0013A\u0002\u0005U\u0012AD:uC\u001e,\u0017\t\u001e;f[B$\u0018\n\u001a\u0005\b\u0007?!\u0003\u0019AB\u0011\u000391\u0017-\u001b7ve\u0016\u001c()_#yK\u000e\u0004\u0002\"a\u0018\u0002j\u00055$qP\u0001\u0016SN,\u00050Z2vi>\u0014(\t\\1dW2L7\u000f^3e)\u0011\t\tfa\n\t\u000f\r%R\u00051\u0001\u0002n\u0005QQ\r_3dkR|'/\u00133\u0002\u001b9|G-\u001a\"mC\u000e\\G.[:u)\t\u0011\t-A\tjg:{G-\u001a\"mC\u000e\\G.[:uK\u0012$B!!\u0015\u00044!91QA\u0014A\u0002\u00055\u0014!\u00065b]\u0012dWMU3n_Z,G-\u0012=fGV$xN\u001d\u000b\u0005\u0005?\u001aI\u0004C\u0004\u0004*!\u0002\r!!\u001c\u0002!\tc\u0017mY6mSN$HK]1dW\u0016\u0014\bCA:R'\r\t6-\u001b\u000b\u0003\u0007{\tq\u0002R#G\u0003VcEk\u0018+J\u001b\u0016{U\u000bV\u0001\u0011\t\u00163\u0015)\u0016'U?RKU*R(V)\u0002\n!#[:CY\u0006\u001c7\u000e\\5ti\u0016s\u0017M\u00197fIR!\u0011\u0011KB&\u0011\u00159X\u000b1\u0001y\u0003M9W\r\u001e\"mC\u000e\\G.[:u)&lWm\\;u)\u0011\t)e!\u0015\t\u000b]4\u0006\u0019\u0001=\u0002-Y\fG.\u001b3bi\u0016\u0014E.Y2lY&\u001cHoQ8oMN$BAa\u0018\u0004X!)qo\u0016a\u0001q\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*\"a!\u0018+\t\u0005%\u0011Q\u0019")
public class BlacklistTracker
implements Logging {
    private final LiveListenerBus listenerBus;
    private final SparkConf conf;
    private final Option<ExecutorAllocationClient> allocationClient;
    private final Clock clock;
    private final int MAX_FAILURES_PER_EXEC;
    private final int MAX_FAILED_EXEC_PER_NODE;
    private final long BLACKLIST_TIMEOUT_MILLIS;
    private final boolean BLACKLIST_FETCH_FAILURE_ENABLED;
    private final HashMap<String, ExecutorFailureList> executorIdToFailureList;
    private final HashMap<String, BlacklistedExecutor> executorIdToBlacklistStatus;
    private final HashMap<String, Object> nodeIdToBlacklistExpiryTime;
    private final AtomicReference<Set<String>> _nodeBlacklist;
    private long nextExpiryTime;
    private final HashMap<String, HashSet<String>> nodeToBlacklistedExecs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Clock $lessinit$greater$default$4() {
        return BlacklistTracker$.MODULE$.$lessinit$greater$default$4();
    }

    public static void validateBlacklistConfs(SparkConf sparkConf) {
        BlacklistTracker$.MODULE$.validateBlacklistConfs(sparkConf);
    }

    public static long getBlacklistTimeout(SparkConf sparkConf) {
        return BlacklistTracker$.MODULE$.getBlacklistTimeout(sparkConf);
    }

    public static boolean isBlacklistEnabled(SparkConf sparkConf) {
        return BlacklistTracker$.MODULE$.isBlacklistEnabled(sparkConf);
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private LiveListenerBus listenerBus() {
        return this.listenerBus;
    }

    private int MAX_FAILURES_PER_EXEC() {
        return this.MAX_FAILURES_PER_EXEC;
    }

    private int MAX_FAILED_EXEC_PER_NODE() {
        return this.MAX_FAILED_EXEC_PER_NODE;
    }

    public long BLACKLIST_TIMEOUT_MILLIS() {
        return this.BLACKLIST_TIMEOUT_MILLIS;
    }

    private boolean BLACKLIST_FETCH_FAILURE_ENABLED() {
        return this.BLACKLIST_FETCH_FAILURE_ENABLED;
    }

    private HashMap<String, ExecutorFailureList> executorIdToFailureList() {
        return this.executorIdToFailureList;
    }

    public HashMap<String, BlacklistedExecutor> executorIdToBlacklistStatus() {
        return this.executorIdToBlacklistStatus;
    }

    public HashMap<String, Object> nodeIdToBlacklistExpiryTime() {
        return this.nodeIdToBlacklistExpiryTime;
    }

    private AtomicReference<Set<String>> _nodeBlacklist() {
        return this._nodeBlacklist;
    }

    public long nextExpiryTime() {
        return this.nextExpiryTime;
    }

    public void nextExpiryTime_$eq(long x$1) {
        this.nextExpiryTime = x$1;
    }

    public HashMap<String, HashSet<String>> nodeToBlacklistedExecs() {
        return this.nodeToBlacklistedExecs;
    }

    public void applyBlacklistTimeout() {
        block2: {
            Iterable nodesToUnblacklist;
            long now = this.clock.getTimeMillis();
            if (now <= this.nextExpiryTime()) break block2;
            Iterable execsToUnblacklist = ((MapLike)this.executorIdToBlacklistStatus().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BlacklistTracker.$anonfun$applyBlacklistTimeout$1(now, x$1)))).keys();
            if (execsToUnblacklist.nonEmpty()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(90).append("Removing executors ").append(execsToUnblacklist).append(" from blacklist because the blacklist ").append("for those executors has timed out").toString());
                execsToUnblacklist.foreach((Function1 & Serializable & scala.Serializable)exec -> {
                    BlacklistedExecutor status = (BlacklistedExecutor)this.executorIdToBlacklistStatus().remove(exec).get();
                    HashSet failedExecsOnNode = (HashSet)this.nodeToBlacklistedExecs().apply((Object)status.node());
                    this.listenerBus().post(new SparkListenerExecutorUnblacklisted(now, (String)exec));
                    failedExecsOnNode.remove(exec);
                    return failedExecsOnNode.isEmpty() ? this.nodeToBlacklistedExecs().remove((Object)status.node()) : BoxedUnit.UNIT;
                });
            }
            if ((nodesToUnblacklist = ((MapLike)this.nodeIdToBlacklistExpiryTime().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BlacklistTracker.$anonfun$applyBlacklistTimeout$4(now, x$2)))).keys()).nonEmpty()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Removing nodes ").append(nodesToUnblacklist).append(" from blacklist because the blacklist ").append("has timed out").toString());
                nodesToUnblacklist.foreach((Function1 & Serializable & scala.Serializable)node -> {
                    BlacklistTracker.$anonfun$applyBlacklistTimeout$6(this, now, node);
                    return BoxedUnit.UNIT;
                });
                this._nodeBlacklist().set((Set<String>)this.nodeIdToBlacklistExpiryTime().keySet().toSet());
            }
            this.updateNextExpiryTime();
        }
    }

    private void updateNextExpiryTime() {
        long execMinExpiry = this.executorIdToBlacklistStatus().nonEmpty() ? BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.executorIdToBlacklistStatus().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)BlacklistTracker.$anonfun$updateNextExpiryTime$1(x$3)), Iterable$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Long$.MODULE$)) : Long.MAX_VALUE;
        long nodeMinExpiry = this.nodeIdToBlacklistExpiryTime().nonEmpty() ? BoxesRunTime.unboxToLong((Object)this.nodeIdToBlacklistExpiryTime().values().min((Ordering)Ordering.Long$.MODULE$)) : Long.MAX_VALUE;
        this.nextExpiryTime_$eq(package$.MODULE$.min(execMinExpiry, nodeMinExpiry));
    }

    private void killExecutor(String exec, String msg) {
        Option<ExecutorAllocationClient> option = this.allocationClient;
        if (option instanceof Some) {
            Some some = (Some)option;
            ExecutorAllocationClient a = (ExecutorAllocationClient)some.value();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg);
            a.killExecutors((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{exec}))), false, false, true);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Not attempting to kill blacklisted executor id ").append(exec).append(" ").append("since allocation client is not defined.").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    private void killBlacklistedExecutor(String exec) {
        block0: {
            if (!BoxesRunTime.unboxToBoolean((Object)this.conf.get(org.apache.spark.internal.config.package$.MODULE$.BLACKLIST_KILL_ENABLED()))) break block0;
            this.killExecutor(exec, new StringBuilder(47).append("Killing blacklisted executor id ").append(exec).append(" since ").append(org.apache.spark.internal.config.package$.MODULE$.BLACKLIST_KILL_ENABLED().key()).append(" is set.").toString());
        }
    }

    public void killBlacklistedIdleExecutor(String exec) {
        this.killExecutor(exec, new StringBuilder(108).append("Killing blacklisted idle executor id ").append(exec).append(" because of task unschedulability and trying ").append("to acquire a new executor.").toString());
    }

    private void killExecutorsOnBlacklistedNode(String node) {
        if (BoxesRunTime.unboxToBoolean((Object)this.conf.get(org.apache.spark.internal.config.package$.MODULE$.BLACKLIST_KILL_ENABLED()))) {
            Option<ExecutorAllocationClient> option = this.allocationClient;
            if (option instanceof Some) {
                BoxedUnit boxedUnit;
                Some some = (Some)option;
                ExecutorAllocationClient a = (ExecutorAllocationClient)some.value();
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Killing all executors on blacklisted host ").append(node).append(" ").append("since ").append(org.apache.spark.internal.config.package$.MODULE$.BLACKLIST_KILL_ENABLED().key()).append(" is set.").toString());
                if (!a.killExecutorsOnHost(node)) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Killing executors on node ").append(node).append(" failed.").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (None$.MODULE$.equals(option)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(93).append("Not attempting to kill executors on blacklisted host ").append(node).append(" ").append("since allocation client is not defined.").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
        }
    }

    public void updateBlacklistForFetchFailure(String host, String exec) {
        block0: {
            long expiryTimeForNewBlacklists;
            long now;
            block1: {
                if (!this.BLACKLIST_FETCH_FAILURE_ENABLED()) break block0;
                now = this.clock.getTimeMillis();
                expiryTimeForNewBlacklists = now + this.BLACKLIST_TIMEOUT_MILLIS();
                if (!BoxesRunTime.unboxToBoolean((Object)this.conf.get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_SERVICE_ENABLED()))) break block1;
                if (this.nodeIdToBlacklistExpiryTime().contains((Object)host)) break block0;
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("blacklisting node ").append(host).append(" due to fetch failure of external shuffle service").toString());
                this.nodeIdToBlacklistExpiryTime().put((Object)host, (Object)BoxesRunTime.boxToLong((long)expiryTimeForNewBlacklists));
                this.listenerBus().post(new SparkListenerNodeBlacklisted(now, host, 1));
                this._nodeBlacklist().set((Set<String>)this.nodeIdToBlacklistExpiryTime().keySet().toSet());
                this.killExecutorsOnBlacklistedNode(host);
                this.updateNextExpiryTime();
                break block0;
            }
            if (this.executorIdToBlacklistStatus().contains((Object)exec)) break block0;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Blacklisting executor ").append(exec).append(" due to fetch failure").toString());
            this.executorIdToBlacklistStatus().put((Object)exec, (Object)new BlacklistedExecutor(host, expiryTimeForNewBlacklists));
            this.listenerBus().post(new SparkListenerExecutorBlacklisted(now, exec, 1));
            this.updateNextExpiryTime();
            this.killBlacklistedExecutor(exec);
            HashSet blacklistedExecsOnNode = (HashSet)this.nodeToBlacklistedExecs().getOrElseUpdate((Object)host, (Function0 & Serializable & scala.Serializable)() -> (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$));
            blacklistedExecsOnNode.$plus$eq((Object)exec);
        }
    }

    public void updateBlacklistForSuccessfulTaskSet(int stageId, int stageAttemptId, HashMap<String, ExecutorFailuresInTaskSet> failuresByExec) {
        long now = this.clock.getTimeMillis();
        failuresByExec.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BlacklistTracker.$anonfun$updateBlacklistForSuccessfulTaskSet$1(this, stageId, stageAttemptId, now, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public boolean isExecutorBlacklisted(String executorId) {
        return this.executorIdToBlacklistStatus().contains((Object)executorId);
    }

    public Set<String> nodeBlacklist() {
        return this._nodeBlacklist().get();
    }

    public boolean isNodeBlacklisted(String node) {
        return this.nodeIdToBlacklistExpiryTime().contains((Object)node);
    }

    public void handleRemovedExecutor(String executorId) {
        this.executorIdToFailureList().$minus$eq((Object)executorId);
    }

    public static final /* synthetic */ boolean $anonfun$applyBlacklistTimeout$1(long now$1, Tuple2 x$1) {
        return ((BlacklistedExecutor)x$1._2()).expiryTime() < now$1;
    }

    public static final /* synthetic */ boolean $anonfun$applyBlacklistTimeout$4(long now$1, Tuple2 x$2) {
        return x$2._2$mcJ$sp() < now$1;
    }

    public static final /* synthetic */ void $anonfun$applyBlacklistTimeout$6(BlacklistTracker $this, long now$1, String node) {
        $this.nodeIdToBlacklistExpiryTime().remove((Object)node);
        $this.listenerBus().post(new SparkListenerNodeUnblacklisted(now$1, node));
    }

    public static final /* synthetic */ long $anonfun$updateNextExpiryTime$1(Tuple2 x$3) {
        return ((BlacklistedExecutor)x$3._2()).expiryTime();
    }

    public static final /* synthetic */ void $anonfun$updateBlacklistForSuccessfulTaskSet$1(BlacklistTracker $this, int stageId$1, int stageAttemptId$1, long now$2, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String exec = (String)tuple2._1();
            ExecutorFailuresInTaskSet failuresInTaskSet = (ExecutorFailuresInTaskSet)tuple2._2();
            ExecutorFailureList appFailuresOnExecutor = (ExecutorFailureList)$this.executorIdToFailureList().getOrElseUpdate((Object)exec, (Function0 & Serializable & scala.Serializable)() -> $this.new ExecutorFailureList());
            appFailuresOnExecutor.addFailures(stageId$1, stageAttemptId$1, failuresInTaskSet);
            appFailuresOnExecutor.dropFailuresWithTimeoutBefore(now$2);
            int newTotal = appFailuresOnExecutor.numUniqueTaskFailures();
            long expiryTimeForNewBlacklists = now$2 + $this.BLACKLIST_TIMEOUT_MILLIS();
            if (newTotal >= $this.MAX_FAILURES_PER_EXEC() && !$this.executorIdToBlacklistStatus().contains((Object)exec)) {
                $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(80).append("Blacklisting executor id: ").append(exec).append(" because it has ").append(newTotal).append(" task failures in successful task sets").toString());
                String node = failuresInTaskSet.node();
                $this.executorIdToBlacklistStatus().put((Object)exec, (Object)new BlacklistedExecutor(node, expiryTimeForNewBlacklists));
                $this.listenerBus().post(new SparkListenerExecutorBlacklisted(now$2, exec, newTotal));
                $this.executorIdToFailureList().remove((Object)exec);
                $this.updateNextExpiryTime();
                $this.killBlacklistedExecutor(exec);
                HashSet blacklistedExecsOnNode = (HashSet)$this.nodeToBlacklistedExecs().getOrElseUpdate((Object)node, (Function0 & Serializable & scala.Serializable)() -> (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$));
                blacklistedExecsOnNode.$plus$eq((Object)exec);
                if (blacklistedExecsOnNode.size() >= $this.MAX_FAILED_EXEC_PER_NODE() && !$this.nodeIdToBlacklistExpiryTime().contains((Object)node)) {
                    $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Blacklisting node ").append(node).append(" because it has ").append(blacklistedExecsOnNode.size()).append(" ").append("executors blacklisted: ").append(blacklistedExecsOnNode).toString());
                    $this.nodeIdToBlacklistExpiryTime().put((Object)node, (Object)BoxesRunTime.boxToLong((long)expiryTimeForNewBlacklists));
                    $this.listenerBus().post(new SparkListenerNodeBlacklisted(now$2, node, blacklistedExecsOnNode.size()));
                    $this._nodeBlacklist().set((Set<String>)$this.nodeIdToBlacklistExpiryTime().keySet().toSet());
                    $this.killExecutorsOnBlacklistedNode(node);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public BlacklistTracker(LiveListenerBus listenerBus, SparkConf conf, Option<ExecutorAllocationClient> allocationClient, Clock clock) {
        this.listenerBus = listenerBus;
        this.conf = conf;
        this.allocationClient = allocationClient;
        this.clock = clock;
        Logging.$init$(this);
        BlacklistTracker$.MODULE$.validateBlacklistConfs(conf);
        this.MAX_FAILURES_PER_EXEC = BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.MAX_FAILURES_PER_EXEC()));
        this.MAX_FAILED_EXEC_PER_NODE = BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.MAX_FAILED_EXEC_PER_NODE()));
        this.BLACKLIST_TIMEOUT_MILLIS = BlacklistTracker$.MODULE$.getBlacklistTimeout(conf);
        this.BLACKLIST_FETCH_FAILURE_ENABLED = BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.BLACKLIST_FETCH_FAILURE_ENABLED()));
        this.executorIdToFailureList = new HashMap();
        this.executorIdToBlacklistStatus = new HashMap();
        this.nodeIdToBlacklistExpiryTime = new HashMap();
        this._nodeBlacklist = new AtomicReference<GenTraversable>(Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
        this.nextExpiryTime = Long.MAX_VALUE;
        this.nodeToBlacklistedExecs = new HashMap();
    }

    public BlacklistTracker(SparkContext sc, Option<ExecutorAllocationClient> allocationClient) {
        this(sc.listenerBus(), sc.conf(), allocationClient, BlacklistTracker$.MODULE$.$lessinit$greater$default$4());
    }

    public final class ExecutorFailureList
    implements Logging {
        private volatile BlacklistTracker$ExecutorFailureList$TaskId$ TaskId$module;
        private ArrayBuffer<Tuple2<TaskId, Object>> failuresAndExpiryTimes;
        private long minExpiryTime;
        private transient Logger org$apache$spark$internal$Logging$$log_;

        @Override
        public String logName() {
            return Logging.logName$(this);
        }

        @Override
        public Logger log() {
            return Logging.log$(this);
        }

        @Override
        public void logInfo(Function0<String> msg) {
            Logging.logInfo$(this, msg);
        }

        @Override
        public void logDebug(Function0<String> msg) {
            Logging.logDebug$(this, msg);
        }

        @Override
        public void logTrace(Function0<String> msg) {
            Logging.logTrace$(this, msg);
        }

        @Override
        public void logWarning(Function0<String> msg) {
            Logging.logWarning$(this, msg);
        }

        @Override
        public void logError(Function0<String> msg) {
            Logging.logError$(this, msg);
        }

        @Override
        public void logInfo(Function0<String> msg, Throwable throwable) {
            Logging.logInfo$(this, msg, throwable);
        }

        @Override
        public void logDebug(Function0<String> msg, Throwable throwable) {
            Logging.logDebug$(this, msg, throwable);
        }

        @Override
        public void logTrace(Function0<String> msg, Throwable throwable) {
            Logging.logTrace$(this, msg, throwable);
        }

        @Override
        public void logWarning(Function0<String> msg, Throwable throwable) {
            Logging.logWarning$(this, msg, throwable);
        }

        @Override
        public void logError(Function0<String> msg, Throwable throwable) {
            Logging.logError$(this, msg, throwable);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void initializeLogIfNecessary(boolean isInterpreter) {
            Logging.initializeLogIfNecessary$(this, isInterpreter);
        }

        @Override
        public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
            return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
        }

        @Override
        public boolean initializeLogIfNecessary$default$2() {
            return Logging.initializeLogIfNecessary$default$2$(this);
        }

        @Override
        public void initializeForcefully(boolean isInterpreter, boolean silent) {
            Logging.initializeForcefully$(this, isInterpreter, silent);
        }

        private BlacklistTracker$ExecutorFailureList$TaskId$ TaskId() {
            if (this.TaskId$module == null) {
                this.TaskId$lzycompute$1();
            }
            return this.TaskId$module;
        }

        @Override
        public Logger org$apache$spark$internal$Logging$$log_() {
            return this.org$apache$spark$internal$Logging$$log_;
        }

        @Override
        public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
            this.org$apache$spark$internal$Logging$$log_ = x$1;
        }

        private ArrayBuffer<Tuple2<TaskId, Object>> failuresAndExpiryTimes() {
            return this.failuresAndExpiryTimes;
        }

        private void failuresAndExpiryTimes_$eq(ArrayBuffer<Tuple2<TaskId, Object>> x$1) {
            this.failuresAndExpiryTimes = x$1;
        }

        private long minExpiryTime() {
            return this.minExpiryTime;
        }

        private void minExpiryTime_$eq(long x$1) {
            this.minExpiryTime = x$1;
        }

        public void addFailures(int stage, int stageAttempt, ExecutorFailuresInTaskSet failuresInTaskSet) {
            failuresInTaskSet.taskToFailureCountAndFailureTime().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ExecutorFailureList.$anonfun$addFailures$1(this, stage, stageAttempt, x0$1);
                return BoxedUnit.UNIT;
            });
        }

        public int numUniqueTaskFailures() {
            return this.failuresAndExpiryTimes().size();
        }

        public boolean isEmpty() {
            return this.failuresAndExpiryTimes().isEmpty();
        }

        public void dropFailuresWithTimeoutBefore(long dropBefore) {
            block0: {
                if (this.minExpiryTime() >= dropBefore) break block0;
                LongRef newMinExpiry = LongRef.create((long)Long.MAX_VALUE);
                ArrayBuffer newFailures = new ArrayBuffer();
                this.failuresAndExpiryTimes().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    ExecutorFailureList.$anonfun$dropFailuresWithTimeoutBefore$1(dropBefore, newFailures, newMinExpiry, x0$1);
                    return BoxedUnit.UNIT;
                });
                this.failuresAndExpiryTimes_$eq((ArrayBuffer<Tuple2<TaskId, Object>>)newFailures);
                this.minExpiryTime_$eq(newMinExpiry.elem);
            }
        }

        public String toString() {
            return new StringBuilder(11).append("failures = ").append(this.failuresAndExpiryTimes()).toString();
        }

        private final void TaskId$lzycompute$1() {
            ExecutorFailureList executorFailureList = this;
            synchronized (executorFailureList) {
                if (this.TaskId$module == null) {
                    this.TaskId$module = new BlacklistTracker$ExecutorFailureList$TaskId$(this);
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static final /* synthetic */ void $anonfun$addFailures$1(ExecutorFailureList $this, int stage$1, int stageAttempt$1, Tuple2 x0$1) {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            int taskIdx = tuple2._1$mcI$sp();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 == null) throw new MatchError((Object)tuple2);
            long failureTime = tuple22._2$mcJ$sp();
            long expiryTime = failureTime + $this.BlacklistTracker.this.BLACKLIST_TIMEOUT_MILLIS();
            $this.failuresAndExpiryTimes().$plus$eq((Object)new Tuple2((Object)new TaskId($this, stage$1, stageAttempt$1, taskIdx), (Object)BoxesRunTime.boxToLong((long)expiryTime)));
            if (expiryTime < $this.minExpiryTime()) {
                $this.minExpiryTime_$eq(expiryTime);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }

        public static final /* synthetic */ void $anonfun$dropFailuresWithTimeoutBefore$1(long dropBefore$1, ArrayBuffer newFailures$1, LongRef newMinExpiry$1, Tuple2 x0$1) {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TaskId task = (TaskId)tuple2._1();
                long expiryTime = tuple2._2$mcJ$sp();
                if (expiryTime >= dropBefore$1) {
                    newFailures$1.$plus$eq((Object)new Tuple2((Object)task, (Object)BoxesRunTime.boxToLong((long)expiryTime)));
                    if (expiryTime < newMinExpiry$1.elem) {
                        newMinExpiry$1.elem = expiryTime;
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }

        public ExecutorFailureList() {
            if (BlacklistTracker.this == null) {
                throw null;
            }
            Logging.$init$(this);
            this.failuresAndExpiryTimes = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            this.minExpiryTime = Long.MAX_VALUE;
        }

        public class TaskId
        implements Product,
        scala.Serializable {
            private final int stage;
            private final int stageAttempt;
            private final int taskIndex;
            public final /* synthetic */ ExecutorFailureList $outer;

            public int stage() {
                return this.stage;
            }

            public int stageAttempt() {
                return this.stageAttempt;
            }

            public int taskIndex() {
                return this.taskIndex;
            }

            public TaskId copy(int stage, int stageAttempt, int taskIndex) {
                return new TaskId(this.org$apache$spark$scheduler$BlacklistTracker$ExecutorFailureList$TaskId$$$outer(), stage, stageAttempt, taskIndex);
            }

            public int copy$default$1() {
                return this.stage();
            }

            public int copy$default$2() {
                return this.stageAttempt();
            }

            public int copy$default$3() {
                return this.taskIndex();
            }

            public String productPrefix() {
                return "TaskId";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Integer n;
                int n2 = x$1;
                switch (n2) {
                    case 0: {
                        n = BoxesRunTime.boxToInteger((int)this.stage());
                        break;
                    }
                    case 1: {
                        n = BoxesRunTime.boxToInteger((int)this.stageAttempt());
                        break;
                    }
                    case 2: {
                        n = BoxesRunTime.boxToInteger((int)this.taskIndex());
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                }
                return n;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof TaskId;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.stage());
                n = Statics.mix((int)n, (int)this.stageAttempt());
                n = Statics.mix((int)n, (int)this.taskIndex());
                return Statics.finalizeHash((int)n, (int)3);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof TaskId)) return false;
                if (((TaskId)object).org$apache$spark$scheduler$BlacklistTracker$ExecutorFailureList$TaskId$$$outer() != this.org$apache$spark$scheduler$BlacklistTracker$ExecutorFailureList$TaskId$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                TaskId taskId = (TaskId)x$1;
                if (this.stage() != taskId.stage()) return false;
                if (this.stageAttempt() != taskId.stageAttempt()) return false;
                if (this.taskIndex() != taskId.taskIndex()) return false;
                if (!taskId.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ ExecutorFailureList org$apache$spark$scheduler$BlacklistTracker$ExecutorFailureList$TaskId$$$outer() {
                return this.$outer;
            }

            public TaskId(ExecutorFailureList $outer, int stage, int stageAttempt, int taskIndex) {
                this.stage = stage;
                this.stageAttempt = stageAttempt;
                this.taskIndex = taskIndex;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

