/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network;

import java.nio.ByteBuffer;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.BlockDataManager;
import org.apache.spark.network.buffer.FileSegmentManagedBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NioManagedBuffer;
import org.apache.spark.network.shuffle.BlockFetchingListener;
import org.apache.spark.network.shuffle.BlockStoreClient;
import org.apache.spark.network.shuffle.DownloadFileManager;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.EncryptedManagedBuffer;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015bA\u0002\u0005\n\u0003\u0003Y\u0011\u0003C\u0003\u001f\u0001\u0011\u0005\u0001\u0005C\u0003$\u0001\u0019\u0005A\u0005C\u00031\u0001\u0019\u0005\u0011\u0007C\u00036\u0001\u0019\u0005a\u0007C\u0003C\u0001\u0019\u00051\tC\u0003y\u0001\u0011\u0005\u0011\u0010C\u0004\u0002\n\u0001!\t!a\u0003\u0003)\tcwnY6Ue\u0006t7OZ3s'\u0016\u0014h/[2f\u0015\tQ1\"A\u0004oKR<xN]6\u000b\u00051i\u0011!B:qCJ\\'B\u0001\b\u0010\u0003\u0019\t\u0007/Y2iK*\t\u0001#A\u0002pe\u001e\u001c2\u0001\u0001\n\u0019!\t\u0019b#D\u0001\u0015\u0015\t)\u0012\"A\u0004tQV4g\r\\3\n\u0005]!\"\u0001\u0005\"m_\u000e\\7\u000b^8sK\u000ec\u0017.\u001a8u!\tIB$D\u0001\u001b\u0015\tY2\"\u0001\u0005j]R,'O\\1m\u0013\ti\"DA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012!\t\t\u0003E\u0001i\u0011!C\u0001\u0005S:LG\u000f\u0006\u0002&WA\u0011a%K\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\t!QK\\5u\u0011\u0015a#\u00011\u0001.\u0003A\u0011Gn\\2l\t\u0006$\u0018-T1oC\u001e,'\u000f\u0005\u0002#]%\u0011q&\u0003\u0002\u0011\u00052|7m\u001b#bi\u0006l\u0015M\\1hKJ\fA\u0001]8siV\t!\u0007\u0005\u0002'g%\u0011Ag\n\u0002\u0004\u0013:$\u0018\u0001\u00035pgRt\u0015-\\3\u0016\u0003]\u0002\"\u0001O \u000f\u0005ej\u0004C\u0001\u001e(\u001b\u0005Y$B\u0001\u001f \u0003\u0019a$o\\8u}%\u0011ahJ\u0001\u0007!J,G-\u001a4\n\u0005\u0001\u000b%AB*ue&twM\u0003\u0002?O\u0005YQ\u000f\u001d7pC\u0012\u0014En\\2l)!!%\nT'P/~#\u0007cA#IK5\taI\u0003\u0002HO\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005%3%A\u0002$viV\u0014X\rC\u0003L\u000b\u0001\u0007q'\u0001\u0005i_N$h.Y7f\u0011\u0015\u0001T\u00011\u00013\u0011\u0015qU\u00011\u00018\u0003\u0019)\u00070Z2JI\")\u0001+\u0002a\u0001#\u00069!\r\\8dW&#\u0007C\u0001*V\u001b\u0005\u0019&B\u0001+\f\u0003\u001d\u0019Ho\u001c:bO\u0016L!AV*\u0003\u000f\tcwnY6JI\")\u0001,\u0002a\u00013\u0006I!\r\\8dW\u0012\u000bG/\u0019\t\u00035vk\u0011a\u0017\u0006\u00039&\taAY;gM\u0016\u0014\u0018B\u00010\\\u00055i\u0015M\\1hK\u0012\u0014UO\u001a4fe\")\u0001-\u0002a\u0001C\u0006)A.\u001a<fYB\u0011!KY\u0005\u0003GN\u0013Ab\u0015;pe\u0006<W\rT3wK2DQ!Z\u0003A\u0002\u0019\f\u0001b\u00197bgN$\u0016m\u001a\u0019\u0003O>\u00042\u0001[6n\u001b\u0005I'B\u00016(\u0003\u001d\u0011XM\u001a7fGRL!\u0001\\5\u0003\u0011\rc\u0017m]:UC\u001e\u0004\"A\\8\r\u0001\u0011I\u0001\u000fZA\u0001\u0002\u0003\u0015\t!\u001d\u0002\u0004?\u0012\n\u0014C\u0001:v!\t13/\u0003\u0002uO\t9aj\u001c;iS:<\u0007C\u0001\u0014w\u0013\t9xEA\u0002B]f\faBZ3uG\"\u0014En\\2l'ft7\r\u0006\u0004Zurlhp \u0005\u0006w\u001a\u0001\raN\u0001\u0005Q>\u001cH\u000fC\u00031\r\u0001\u0007!\u0007C\u0003O\r\u0001\u0007q\u0007C\u0003Q\r\u0001\u0007q\u0007C\u0004\u0002\u0002\u0019\u0001\r!a\u0001\u0002\u001fQ,W\u000e\u001d$jY\u0016l\u0015M\\1hKJ\u00042aEA\u0003\u0013\r\t9\u0001\u0006\u0002\u0014\t><h\u000e\\8bI\u001aKG.Z'b]\u0006<WM]\u0001\u0010kBdw.\u00193CY>\u001c7nU=oGRyQ%!\u0004\u0002\u0010\u0005E\u00111CA\u000b\u0003/\tI\u0002C\u0003L\u000f\u0001\u0007q\u0007C\u00031\u000f\u0001\u0007!\u0007C\u0003O\u000f\u0001\u0007q\u0007C\u0003Q\u000f\u0001\u0007\u0011\u000bC\u0003Y\u000f\u0001\u0007\u0011\fC\u0003a\u000f\u0001\u0007\u0011\r\u0003\u0004f\u000f\u0001\u0007\u00111\u0004\u0019\u0005\u0003;\t\t\u0003\u0005\u0003iW\u0006}\u0001c\u00018\u0002\"\u0011Y\u00111EA\r\u0003\u0003\u0005\tQ!\u0001r\u0005\ryFE\r")
public abstract class BlockTransferService
extends BlockStoreClient
implements Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public abstract void init(BlockDataManager var1);

    public abstract int port();

    public abstract String hostName();

    public abstract Future<BoxedUnit> uploadBlock(String var1, int var2, String var3, BlockId var4, ManagedBuffer var5, StorageLevel var6, ClassTag<?> var7);

    public ManagedBuffer fetchBlockSync(String host, int port, String execId, String blockId, DownloadFileManager tempFileManager) {
        Promise result = Promise$.MODULE$.apply();
        this.fetchBlocks(host, port, execId, (String[])((Object[])new String[]{blockId}), new BlockFetchingListener(null, result){
            private final Promise result$1;

            public void onBlockFetchFailure(String blockId, Throwable exception) {
                this.result$1.failure(exception);
            }

            public void onBlockFetchSuccess(String blockId, ManagedBuffer data) {
                ManagedBuffer managedBuffer = data;
                if (managedBuffer instanceof FileSegmentManagedBuffer) {
                    FileSegmentManagedBuffer fileSegmentManagedBuffer = (FileSegmentManagedBuffer)managedBuffer;
                    this.result$1.success((Object)fileSegmentManagedBuffer);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (managedBuffer instanceof EncryptedManagedBuffer) {
                    EncryptedManagedBuffer encryptedManagedBuffer = (EncryptedManagedBuffer)managedBuffer;
                    this.result$1.success((Object)((Object)encryptedManagedBuffer));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit;
                    try {
                        ByteBuffer ret = ByteBuffer.allocate((int)data.size());
                        ret.put(data.nioByteBuffer());
                        ret.flip();
                        this.result$1.success((Object)new NioManagedBuffer(ret));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (Throwable e) {
                        this.result$1.failure(e);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                }
            }
            {
                this.result$1 = result$1;
            }
        }, tempFileManager);
        return (ManagedBuffer)ThreadUtils$.MODULE$.awaitResult(result.future(), (Duration)Duration$.MODULE$.Inf());
    }

    public void uploadBlockSync(String hostname, int port, String execId, BlockId blockId, ManagedBuffer blockData, StorageLevel level, ClassTag<?> classTag) {
        Future<BoxedUnit> future = this.uploadBlock(hostname, port, execId, blockId, blockData, level, classTag);
        ThreadUtils$.MODULE$.awaitResult(future, (Duration)Duration$.MODULE$.Inf());
    }

    public BlockTransferService() {
        Logging.$init$(this);
    }
}

