/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.AutoCloseBase;
import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictDecompress;
import com.github.luben.zstd.ZstdException;
import com.github.luben.zstd.util.Native;
import java.nio.ByteBuffer;

public class ZstdDecompressCtx
extends AutoCloseBase {
    private long nativePtr = 0L;
    private ZstdDictDecompress decompression_dict = null;

    private native void init();

    private native void free();

    public ZstdDecompressCtx() {
        this.init();
        if (0L == this.nativePtr) {
            throw new IllegalStateException("ZSTD_createDeCompressCtx failed");
        }
        this.storeFence();
    }

    @Override
    void doClose() {
        if (this.nativePtr != 0L) {
            this.free();
            this.nativePtr = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDict(ZstdDictDecompress zstdDictDecompress) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Decompression context is closed");
        }
        this.acquireSharedLock();
        zstdDictDecompress.acquireSharedLock();
        try {
            long l = this.loadDDictFast0(zstdDictDecompress);
            if (Zstd.isError(l)) {
                throw new ZstdException(l);
            }
            this.decompression_dict = zstdDictDecompress;
        }
        finally {
            zstdDictDecompress.releaseSharedLock();
            this.releaseSharedLock();
        }
    }

    private native long loadDDictFast0(ZstdDictDecompress var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDict(byte[] byArray) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        try {
            long l = this.loadDDict0(byArray);
            if (Zstd.isError(l)) {
                throw new ZstdException(l);
            }
            this.decompression_dict = null;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private native long loadDDict0(byte[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decompressDirectByteBuffer(ByteBuffer byteBuffer, int n, int n2, ByteBuffer byteBuffer2, int n3, int n4) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Decompression context is closed");
        }
        if (!byteBuffer2.isDirect()) {
            throw new IllegalArgumentException("srcBuff must be a direct buffer");
        }
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("dstBuff must be a direct buffer");
        }
        this.acquireSharedLock();
        try {
            long l = this.decompressDirectByteBuffer0(byteBuffer, n, n2, byteBuffer2, n3, n4);
            if (Zstd.isError(l)) {
                throw new ZstdException(l);
            }
            int n5 = (int)l;
            return n5;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private native long decompressDirectByteBuffer0(ByteBuffer var1, int var2, int var3, ByteBuffer var4, int var5, int var6);

    static {
        Native.load();
    }
}

