/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.latch;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.LatchContext;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.latch.OwnerInfo;
import com.sleepycat.je.latch.SharedLatch;
import com.sleepycat.je.utilint.StatGroup;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SharedLatchImpl
extends ReentrantReadWriteLock
implements SharedLatch {
    private final LatchContext context;
    private OwnerInfo lastOwnerInfo;

    SharedLatchImpl(boolean fair, LatchContext context) {
        super(fair);
        this.context = context;
    }

    @Override
    public boolean isExclusiveOnly() {
        return false;
    }

    @Override
    public void acquireExclusive() {
        this.doAcquireExclusive(false);
    }

    @Override
    public boolean acquireExclusiveNoWait() {
        return this.doAcquireExclusive(true);
    }

    private boolean doAcquireExclusive(boolean noWait) {
        if (this.isWriteLockedByCurrentThread() || this.getReadHoldCount() > 0) {
            throw EnvironmentFailureException.unexpectedState(this.context.getEnvImplForFatalException(), "Latch already held: " + this.debugString());
        }
        if (noWait) {
            if (!this.writeLock().tryLock()) {
                return false;
            }
        } else {
            try {
                if (!this.writeLock().tryLock(this.context.getLatchTimeoutMs(), TimeUnit.MILLISECONDS)) {
                    throw LatchSupport.handleTimeout(this, this.context);
                }
            }
            catch (InterruptedException e) {
                throw new ThreadInterruptedException(this.context.getEnvImplForFatalException(), (Throwable)e);
            }
        }
        if (LatchSupport.TRACK_LATCHES) {
            LatchSupport.trackAcquire(this, this.context);
        }
        if (LatchSupport.CAPTURE_OWNER) {
            this.lastOwnerInfo = new OwnerInfo(this.context);
        }
        assert (EnvironmentImpl.maybeForceYield());
        return true;
    }

    @Override
    public void acquireShared() {
        if (this.isWriteLockedByCurrentThread()) {
            throw EnvironmentFailureException.unexpectedState(this.context.getEnvImplForFatalException(), "Latch already held exclusively: " + this.debugString());
        }
        if (this.getReadHoldCount() > 0) {
            throw EnvironmentFailureException.unexpectedState(this.context.getEnvImplForFatalException(), "Latch already held non-exclusively: " + this.debugString());
        }
        try {
            if (!this.readLock().tryLock(this.context.getLatchTimeoutMs(), TimeUnit.MILLISECONDS)) {
                throw LatchSupport.handleTimeout(this, this.context);
            }
        }
        catch (InterruptedException e) {
            throw new ThreadInterruptedException(this.context.getEnvImplForFatalException(), (Throwable)e);
        }
        if (LatchSupport.TRACK_LATCHES) {
            LatchSupport.trackAcquire(this, this.context);
        }
        assert (EnvironmentImpl.maybeForceYield());
    }

    @Override
    public void release() {
        this.doRelease(false);
    }

    @Override
    public void releaseIfOwner() {
        this.doRelease(true);
    }

    private void doRelease(boolean ifOwner) {
        if (this.getReadHoldCount() > 0) {
            if (LatchSupport.TRACK_LATCHES) {
                LatchSupport.trackRelease(this, this.context);
            }
            this.readLock().unlock();
            return;
        }
        if (this.isWriteLockedByCurrentThread()) {
            if (LatchSupport.CAPTURE_OWNER) {
                this.lastOwnerInfo = null;
            }
            if (LatchSupport.TRACK_LATCHES) {
                LatchSupport.trackRelease(this, this.context);
            }
            this.writeLock().unlock();
            return;
        }
        if (!ifOwner) {
            throw EnvironmentFailureException.unexpectedState(this.context.getEnvImplForFatalException(), "Latch not held: " + this.debugString());
        }
    }

    @Override
    public Thread getExclusiveOwner() {
        return this.getOwner();
    }

    @Override
    public boolean isExclusiveOwner() {
        return this.isWriteLockedByCurrentThread();
    }

    @Override
    public boolean isOwner() {
        return this.isWriteLockedByCurrentThread() || this.getReadHoldCount() > 0;
    }

    @Override
    public int getNWaiters() {
        return this.getQueueLength();
    }

    @Override
    public StatGroup getStats() {
        throw EnvironmentFailureException.unexpectedState();
    }

    @Override
    public void clearStats() {
        throw EnvironmentFailureException.unexpectedState();
    }

    @Override
    public String toString() {
        return LatchSupport.toString(this, this.context, this.lastOwnerInfo);
    }

    @Override
    public String debugString() {
        return LatchSupport.debugString(this, this.context, this.lastOwnerInfo);
    }
}

