/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.utilint.TestHook;

public class DbCleanup {
    private final DatabaseImpl dbImpl;
    private final Action action;
    private final boolean atCommit;
    private final String newName;
    public static TestHook modifyDbRootHook;

    DbCleanup(DatabaseImpl dbImpl, Action action, boolean atCommit) {
        this(dbImpl, action, atCommit, null);
    }

    DbCleanup(DatabaseImpl dbImpl, Action action, boolean atCommit, String newName) {
        assert (action == Action.RENAME == (newName != null));
        this.dbImpl = dbImpl;
        this.action = action;
        this.atCommit = atCommit;
        this.newName = newName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DbCleanup)) {
            return false;
        }
        DbCleanup other = (DbCleanup)obj;
        return this.dbImpl.equals(other.dbImpl) && this.action == other.action && this.atCommit == other.atCommit;
    }

    public int hashCode() {
        return this.dbImpl.hashCode();
    }

    public static void setState(DbCleanup cleanup, boolean isCommit) {
        DatabaseImpl dbImpl = cleanup.dbImpl;
        switch (cleanup.action) {
            case RENAME: {
                if (cleanup.atCommit != isCommit) break;
                dbImpl.setNameAndType(cleanup.newName);
                break;
            }
            case DELETE: {
                if (cleanup.atCommit != isCommit) break;
                dbImpl.setDeleteStarted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(EnvironmentImpl envImpl, DbCleanup[] cleanupArray, boolean isCommit) {
        DbTree dbTree = envImpl.getDbTree();
        block7: for (DbCleanup cleanup : cleanupArray) {
            DatabaseImpl dbImpl = cleanup.dbImpl;
            switch (cleanup.action) {
                case RENAME: {
                    try {
                        if (cleanup.atCommit != isCommit) continue block7;
                        if (modifyDbRootHook != null) {
                            modifyDbRootHook.doHook();
                        }
                        dbTree.modifyDbRoot(dbImpl);
                        continue block7;
                    }
                    finally {
                        dbTree.releaseDb(dbImpl);
                    }
                }
                case DELETE: {
                    if (cleanup.atCommit == isCommit) {
                        if (DbCleanup.checkRepeatedDeletedDB(cleanupArray, cleanup)) {
                            dbTree.releaseDb(dbImpl);
                        }
                        envImpl.getExtinctionScanner().startDbExtinction(dbImpl);
                        continue block7;
                    }
                    if (DbCleanup.checkRepeatedDeletedDB(cleanupArray, cleanup)) continue block7;
                    dbTree.releaseDb(dbImpl);
                }
            }
        }
    }

    private static boolean checkRepeatedDeletedDB(DbCleanup[] array, DbCleanup cleanup) {
        for (DbCleanup element : array) {
            if (element.action != Action.DELETE || !element.dbImpl.getId().equals(cleanup.dbImpl.getId()) || element.atCommit == cleanup.atCommit) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setStateAndExecute(EnvironmentImpl envImpl, DbCleanup cleanup) {
        DbTree dbTree = envImpl.getDbTree();
        DatabaseImpl dbImpl = cleanup.dbImpl;
        switch (cleanup.action) {
            case RENAME: {
                try {
                    if (!cleanup.atCommit) break;
                    dbImpl.setNameAndType(cleanup.newName);
                    if (modifyDbRootHook != null) {
                        modifyDbRootHook.doHook();
                    }
                    dbTree.modifyDbRoot(cleanup.dbImpl);
                    break;
                }
                finally {
                    dbTree.releaseDb(dbImpl);
                }
            }
            case DELETE: {
                if (cleanup.atCommit) {
                    dbImpl.setDeleteStarted();
                    envImpl.getExtinctionScanner().startDbExtinction(dbImpl);
                    break;
                }
                dbTree.releaseDb(dbImpl);
            }
        }
    }

    public static enum Action {
        DELETE,
        RENAME;

    }
}

