/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.config;

import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.hosted.config.HybridLayoutSupport;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedType;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.NumUtil;

public class HybridLayout<T> {
    private final ObjectLayout layout;
    private final HostedType arrayComponentType;
    private final HostedField arrayField;
    private final HostedField typeIDSlotsField;
    private final int arrayBaseOffset;

    public static boolean isHybrid(ResolvedJavaType clazz) {
        return HybridLayoutSupport.singleton().isHybrid(clazz);
    }

    public static boolean isHybridField(HostedField field) {
        return HybridLayoutSupport.singleton().isHybridField(field);
    }

    public static boolean canHybridFieldsBeDuplicated(HostedType clazz) {
        return HybridLayoutSupport.singleton().canHybridFieldsBeDuplicated(clazz);
    }

    public static boolean canInstantiateAsInstance(HostedType clazz) {
        return HybridLayoutSupport.singleton().canInstantiateAsInstance(clazz);
    }

    public HybridLayout(Class<T> hybridClass, ObjectLayout layout, HostedMetaAccess metaAccess) {
        this((HostedInstanceClass)metaAccess.lookupJavaType((Class)hybridClass), layout, (MetaAccessProvider)metaAccess);
    }

    public HybridLayout(HostedInstanceClass hybridClass, ObjectLayout layout, MetaAccessProvider metaAccess) {
        this.layout = layout;
        HybridLayoutSupport.HybridInfo hybridInfo = HybridLayoutSupport.singleton().inspectHybrid(hybridClass, metaAccess);
        this.arrayComponentType = hybridInfo.arrayComponentType;
        this.arrayField = hybridInfo.arrayField;
        this.typeIDSlotsField = hybridInfo.typeIDSlotsField;
        this.arrayBaseOffset = NumUtil.roundUp((int)hybridClass.getAfterFieldsOffset(), (int)layout.sizeInBytes(this.getArrayElementStorageKind()));
    }

    public HostedType getArrayComponentType() {
        return this.arrayComponentType;
    }

    public JavaKind getArrayElementStorageKind() {
        return this.arrayComponentType.getStorageKind();
    }

    public int getArrayBaseOffset() {
        return this.arrayBaseOffset;
    }

    public long getArrayElementOffset(int index) {
        return (long)this.getArrayBaseOffset() + (long)index * (long)this.layout.sizeInBytes(this.getArrayElementStorageKind());
    }

    public long getTotalSize(int length) {
        return this.layout.alignUp(this.getArrayElementOffset(length));
    }

    public HostedField getArrayField() {
        return this.arrayField;
    }

    public HostedField getTypeIDSlotsField() {
        return this.typeIDSlotsField;
    }

    public static int getTypeIDSlotsFieldOffset(ObjectLayout layout) {
        return layout.getArrayLengthOffset() + layout.sizeInBytes(JavaKind.Int);
    }
}

