/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.svm.hosted.annotation.AnnotationMemberValue;
import com.oracle.svm.hosted.annotation.AnnotationMetadata;
import com.oracle.svm.hosted.annotation.AnnotationValue;
import com.oracle.svm.hosted.annotation.TypeAnnotationValue;
import com.oracle.svm.util.AnnotationExtracter;
import com.oracle.svm.util.AnnotationWrapper;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.internal.reflect.ConstantPool;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaField;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaType;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.debug.GraalError;

public class SubstrateAnnotationExtracter
implements AnnotationExtracter {
    private final Map<Class<?>, AnnotationValue[]> annotationCache = new ConcurrentHashMap();
    private final Map<AnnotatedElement, AnnotationValue[]> declaredAnnotationCache = new ConcurrentHashMap<AnnotatedElement, AnnotationValue[]>();
    private final Map<Executable, AnnotationValue[][]> parameterAnnotationCache = new ConcurrentHashMap<Executable, AnnotationValue[][]>();
    private final Map<AnnotatedElement, TypeAnnotationValue[]> typeAnnotationCache = new ConcurrentHashMap<AnnotatedElement, TypeAnnotationValue[]>();
    private final Map<Method, AnnotationMemberValue> annotationDefaultCache = new ConcurrentHashMap<Method, AnnotationMemberValue>();
    private final Map<AnnotationValue, Annotation> resolvedAnnotationsCache = new ConcurrentHashMap<AnnotationValue, Annotation>();
    private static final AnnotationValue[] NO_ANNOTATIONS = new AnnotationValue[0];
    private static final AnnotationValue[][] NO_PARAMETER_ANNOTATIONS = new AnnotationValue[0][0];
    private static final TypeAnnotationValue[] NO_TYPE_ANNOTATIONS = new TypeAnnotationValue[0];
    private static final Method classGetRawAnnotations = ReflectionUtil.lookupMethod(Class.class, (String)"getRawAnnotations", (Class[])new Class[0]);
    private static final Method classGetRawTypeAnnotations = ReflectionUtil.lookupMethod(Class.class, (String)"getRawTypeAnnotations", (Class[])new Class[0]);
    private static final Method classGetConstantPool = ReflectionUtil.lookupMethod(Class.class, (String)"getConstantPool", (Class[])new Class[0]);
    private static final Field fieldAnnotations = ReflectionUtil.lookupField(Field.class, (String)"annotations");
    private static final Method fieldGetTypeAnnotationBytes = ReflectionUtil.lookupMethod(Field.class, (String)"getTypeAnnotationBytes0", (Class[])new Class[0]);
    private static final Method executableGetAnnotationBytes = ReflectionUtil.lookupMethod(Executable.class, (String)"getAnnotationBytes", (Class[])new Class[0]);
    private static final Method executableGetTypeAnnotationBytes = ReflectionUtil.lookupMethod(Executable.class, (String)"getTypeAnnotationBytes", (Class[])new Class[0]);
    private static final Field methodParameterAnnotations = ReflectionUtil.lookupField(Method.class, (String)"parameterAnnotations");
    private static final Field methodAnnotationDefault = ReflectionUtil.lookupField(Method.class, (String)"annotationDefault");
    private static final Field constructorParameterAnnotations = ReflectionUtil.lookupField(Constructor.class, (String)"parameterAnnotations");
    private static final Class<?> recordComponentClass;
    private static final Field recordComponentAnnotations;
    private static final Field recordComponentTypeAnnotations;
    private static final Method recordComponentGetDeclaringRecord;
    private static final Method packageGetPackageInfo;
    private static final Object hotSpotJVMCIRuntimeReflection;
    private static final Method hotSpotJDKReflectionGetMirror;
    private static final Method hotSpotJDKReflectionGetMethod;
    private static final Method hotSpotJDKReflectionGetField;
    private static final boolean isHotSpotJDKReflectionAvailable;
    private static final Method hotSpotResolvedObjectTypeImplMirror;
    private static final Method hotSpotResolvedPrimitiveTypeMirror;
    private static final Method hotSpotResolvedJavaMethodImplToJava;
    private static final Method hotSpotResolvedJavaFieldImplToJava;

    public <T extends Annotation> T extractAnnotation(AnnotatedElement element, Class<T> annotationType, boolean declaredOnly) {
        for (AnnotationValue annotation : this.getAnnotationData(element, declaredOnly)) {
            if (annotation.type == null || !annotation.type.equals(annotationType)) continue;
            return (T)this.resolvedAnnotationsCache.computeIfAbsent(annotation, value -> (Annotation)value.get(annotationType));
        }
        return null;
    }

    public boolean hasAnnotation(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        for (AnnotationValue annotation : this.getAnnotationData(element, false)) {
            if (annotation.type == null || !annotation.type.equals(annotationType)) continue;
            return true;
        }
        return false;
    }

    public Class<? extends Annotation>[] getAnnotationTypes(AnnotatedElement element) {
        return (Class[])Arrays.stream(this.getAnnotationData(element, false)).map(AnnotationValue::getType).filter(t -> t != null).toArray(Class[]::new);
    }

    public AnnotationValue[] getDeclaredAnnotationData(AnnotatedElement element) {
        return this.getAnnotationData(element, true);
    }

    private AnnotationValue[] getAnnotationData(AnnotatedElement element, boolean declaredOnly) {
        AnnotatedElement root = SubstrateAnnotationExtracter.getRoot(element);
        AnnotatedElement secondaryRoot = SubstrateAnnotationExtracter.getSecondaryRoot(element);
        List<Annotation> injectedAnnotations = SubstrateAnnotationExtracter.getInjectedAnnotations(element);
        List<Class<? extends Annotation>> ignoredAnnotations = SubstrateAnnotationExtracter.getIgnoredAnnotations(element);
        ArrayList<AnnotationValue> data = new ArrayList<AnnotationValue>();
        for (Annotation annotation2 : injectedAnnotations) {
            data.add(new AnnotationValue(annotation2));
        }
        if (root != null) {
            data.addAll(Arrays.asList(declaredOnly ? this.getDeclaredAnnotationDataFromRoot(root) : this.getAnnotationDataFromRoot(root)));
        }
        if (secondaryRoot != null) {
            data.addAll(Arrays.asList(declaredOnly ? this.getDeclaredAnnotationDataFromRoot(secondaryRoot) : this.getAnnotationDataFromRoot(secondaryRoot)));
        }
        if (ignoredAnnotations.size() > 0) {
            data.removeIf(annotation -> ignoredAnnotations.contains(annotation.type));
        }
        return data.toArray(NO_ANNOTATIONS);
    }

    private AnnotationValue[] getAnnotationDataFromRoot(AnnotatedElement rootElement) {
        Class superClass;
        if (!(rootElement instanceof Class)) {
            return this.getDeclaredAnnotationDataFromRoot(rootElement);
        }
        Class clazz = (Class)rootElement;
        ArrayList<AnnotationValue> inheritedAnnotations = new ArrayList<AnnotationValue>();
        if (!this.annotationCache.containsKey(clazz) && (superClass = clazz.getSuperclass()) != null) {
            for (AnnotationValue superclassAnnotation : this.getAnnotationDataFromRoot(superClass)) {
                if (!this.hasAnnotation(superclassAnnotation.type, Inherited.class)) continue;
                inheritedAnnotations.add(superclassAnnotation);
            }
        }
        return this.annotationCache.computeIfAbsent(clazz, element -> {
            AnnotationValue[] declaredAnnotations = this.getDeclaredAnnotationDataFromRoot((AnnotatedElement)element);
            LinkedHashMap<Class<? extends Annotation>, AnnotationValue> annotations = new LinkedHashMap<Class<? extends Annotation>, AnnotationValue>();
            for (AnnotationValue declaredAnnotation : declaredAnnotations) {
                annotations.put(declaredAnnotation.type, declaredAnnotation);
            }
            boolean modified = false;
            for (AnnotationValue inheritedAnnotation : inheritedAnnotations) {
                if (annotations.containsKey(inheritedAnnotation.type)) continue;
                annotations.put(inheritedAnnotation.type, inheritedAnnotation);
                modified = true;
            }
            return modified ? annotations.values().toArray(NO_ANNOTATIONS) : declaredAnnotations;
        });
    }

    private AnnotationValue[] getDeclaredAnnotationDataFromRoot(AnnotatedElement rootElement) {
        return this.declaredAnnotationCache.computeIfAbsent(rootElement, element -> {
            byte[] rawAnnotations = SubstrateAnnotationExtracter.getRawAnnotations(element);
            if (rawAnnotations == null) {
                return NO_ANNOTATIONS;
            }
            ByteBuffer buf = ByteBuffer.wrap(rawAnnotations);
            try {
                ArrayList<AnnotationValue> annotations = new ArrayList<AnnotationValue>();
                int numAnnotations = buf.getShort() & 0xFFFF;
                for (int i = 0; i < numAnnotations; ++i) {
                    AnnotationValue annotation = AnnotationValue.extract(buf, SubstrateAnnotationExtracter.getConstantPool(element), SubstrateAnnotationExtracter.getContainer(element), false, false);
                    if (annotation == null) continue;
                    annotations.add(annotation);
                }
                return annotations.toArray(NO_ANNOTATIONS);
            }
            catch (IllegalArgumentException | BufferUnderflowException ex) {
                return new AnnotationValue[]{AnnotationValue.forAnnotationFormatException()};
            }
        });
    }

    public AnnotationValue[][] getParameterAnnotationData(AnnotatedElement element) {
        AnnotatedElement root = SubstrateAnnotationExtracter.getRoot(element);
        return root != null ? this.getParameterAnnotationDataFromRoot((Executable)root) : NO_PARAMETER_ANNOTATIONS;
    }

    private AnnotationValue[][] getParameterAnnotationDataFromRoot(Executable rootElement) {
        return this.parameterAnnotationCache.computeIfAbsent(rootElement, element -> {
            byte[] rawParameterAnnotations = SubstrateAnnotationExtracter.getRawParameterAnnotations(element);
            if (rawParameterAnnotations == null) {
                return NO_PARAMETER_ANNOTATIONS;
            }
            ByteBuffer buf = ByteBuffer.wrap(rawParameterAnnotations);
            try {
                int numParameters = buf.get() & 0xFF;
                AnnotationValue[][] parameterAnnotations = new AnnotationValue[numParameters][];
                for (int i = 0; i < numParameters; ++i) {
                    ArrayList<AnnotationValue> parameterAnnotationList = new ArrayList<AnnotationValue>();
                    int numAnnotations = buf.getShort() & 0xFFFF;
                    for (int j = 0; j < numAnnotations; ++j) {
                        AnnotationValue parameterAnnotation = AnnotationValue.extract(buf, SubstrateAnnotationExtracter.getConstantPool(element), SubstrateAnnotationExtracter.getContainer(element), false, false);
                        if (parameterAnnotation == null) continue;
                        parameterAnnotationList.add(parameterAnnotation);
                    }
                    parameterAnnotations[i] = parameterAnnotationList.toArray(NO_ANNOTATIONS);
                }
                return parameterAnnotations;
            }
            catch (IllegalArgumentException | BufferUnderflowException ex) {
                return new AnnotationValue[][]{{AnnotationValue.forAnnotationFormatException()}};
            }
        });
    }

    public TypeAnnotationValue[] getTypeAnnotationData(AnnotatedElement element) {
        AnnotatedElement root = SubstrateAnnotationExtracter.getRoot(element);
        return root != null ? this.getTypeAnnotationDataFromRoot(root) : NO_TYPE_ANNOTATIONS;
    }

    private TypeAnnotationValue[] getTypeAnnotationDataFromRoot(AnnotatedElement rootElement) {
        return this.typeAnnotationCache.computeIfAbsent(rootElement, element -> {
            byte[] rawTypeAnnotations = SubstrateAnnotationExtracter.getRawTypeAnnotations(element);
            if (rawTypeAnnotations == null) {
                return NO_TYPE_ANNOTATIONS;
            }
            ByteBuffer buf = ByteBuffer.wrap(rawTypeAnnotations);
            try {
                int annotationCount = buf.getShort() & 0xFFFF;
                TypeAnnotationValue[] typeAnnotationValues = new TypeAnnotationValue[annotationCount];
                for (int i = 0; i < annotationCount; ++i) {
                    typeAnnotationValues[i] = TypeAnnotationValue.extract(buf, SubstrateAnnotationExtracter.getConstantPool(element), SubstrateAnnotationExtracter.getContainer(element));
                }
                return typeAnnotationValues;
            }
            catch (IllegalArgumentException | BufferUnderflowException ex) {
                return new TypeAnnotationValue[]{new TypeAnnotationValue(new byte[]{119}, new byte[]{0}, AnnotationValue.forAnnotationFormatException())};
            }
        });
    }

    public AnnotationMemberValue getAnnotationDefaultData(AnnotatedElement element) {
        AnnotatedElement root = SubstrateAnnotationExtracter.getRoot(element);
        return root != null ? this.getAnnotationDefaultDataFromRoot((Method)root) : null;
    }

    private AnnotationMemberValue getAnnotationDefaultDataFromRoot(Method accessorMethod) {
        return this.annotationDefaultCache.computeIfAbsent(accessorMethod, method -> {
            byte[] rawAnnotationDefault = SubstrateAnnotationExtracter.getRawAnnotationDefault(method);
            if (rawAnnotationDefault == null) {
                return null;
            }
            ByteBuffer buf = ByteBuffer.wrap(rawAnnotationDefault);
            try {
                return AnnotationMemberValue.extract(buf, SubstrateAnnotationExtracter.getConstantPool(method), SubstrateAnnotationExtracter.getContainer(method), false);
            }
            catch (IllegalArgumentException | BufferUnderflowException ex) {
                return AnnotationValue.forAnnotationFormatException();
            }
        });
    }

    private static byte[] getRawAnnotations(AnnotatedElement rootElement) {
        try {
            if (rootElement instanceof Class) {
                return (byte[])classGetRawAnnotations.invoke((Object)rootElement, new Object[0]);
            }
            if (rootElement instanceof Field) {
                return (byte[])fieldAnnotations.get(rootElement);
            }
            if (rootElement instanceof Executable) {
                return (byte[])executableGetAnnotationBytes.invoke((Object)rootElement, new Object[0]);
            }
            if (recordComponentClass != null && recordComponentClass.isInstance(rootElement)) {
                return (byte[])recordComponentAnnotations.get(rootElement);
            }
            throw new AnnotationMetadata.AnnotationExtractionError("Unexpected annotated element type: " + rootElement.getClass());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AnnotationMetadata.AnnotationExtractionError(e);
        }
    }

    private static byte[] getRawParameterAnnotations(Executable rootElement) {
        try {
            if (rootElement instanceof Method) {
                return (byte[])methodParameterAnnotations.get(rootElement);
            }
            if (rootElement instanceof Constructor) {
                return (byte[])constructorParameterAnnotations.get(rootElement);
            }
            throw new AnnotationMetadata.AnnotationExtractionError("Unexpected annotated element type: " + rootElement.getClass());
        }
        catch (IllegalAccessException e) {
            throw new AnnotationMetadata.AnnotationExtractionError(e);
        }
    }

    private static byte[] getRawTypeAnnotations(AnnotatedElement rootElement) {
        try {
            if (rootElement instanceof Class) {
                return (byte[])classGetRawTypeAnnotations.invoke((Object)rootElement, new Object[0]);
            }
            if (rootElement instanceof Field) {
                return (byte[])fieldGetTypeAnnotationBytes.invoke((Object)rootElement, new Object[0]);
            }
            if (rootElement instanceof Executable) {
                return (byte[])executableGetTypeAnnotationBytes.invoke((Object)rootElement, new Object[0]);
            }
            if (recordComponentClass != null && recordComponentClass.isInstance(rootElement)) {
                return (byte[])recordComponentTypeAnnotations.get(rootElement);
            }
            throw new AnnotationMetadata.AnnotationExtractionError("Unexpected annotated element type: " + rootElement.getClass());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AnnotationMetadata.AnnotationExtractionError(e);
        }
    }

    private static byte[] getRawAnnotationDefault(Method method) {
        try {
            return (byte[])methodAnnotationDefault.get(method);
        }
        catch (IllegalAccessException e) {
            throw new AnnotationMetadata.AnnotationExtractionError(e);
        }
    }

    private static ConstantPool getConstantPool(AnnotatedElement rootElement) {
        Class<?> container = SubstrateAnnotationExtracter.getContainer(rootElement);
        try {
            return (ConstantPool)classGetConstantPool.invoke(container, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AnnotationMetadata.AnnotationExtractionError(e);
        }
    }

    private static Class<?> getContainer(AnnotatedElement rootElement) {
        if (rootElement instanceof Class) {
            return (Class)rootElement;
        }
        if (rootElement instanceof Field) {
            return ((Field)rootElement).getDeclaringClass();
        }
        if (rootElement instanceof Executable) {
            return ((Executable)rootElement).getDeclaringClass();
        }
        if (recordComponentClass != null && recordComponentClass.isInstance(rootElement)) {
            try {
                return (Class)recordComponentGetDeclaringRecord.invoke((Object)rootElement, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new AnnotationMetadata.AnnotationExtractionError(e);
            }
        }
        throw new AnnotationMetadata.AnnotationExtractionError("Unexpected annotated element type: " + rootElement.getClass());
    }

    private static AnnotatedElement getRoot(AnnotatedElement element) {
        try {
            if (element instanceof Package) {
                return (Class)packageGetPackageInfo.invoke((Object)element, new Object[0]);
            }
            if (element instanceof HotSpotResolvedObjectType || element instanceof HotSpotResolvedJavaType) {
                if (isHotSpotJDKReflectionAvailable) {
                    return (AnnotatedElement)hotSpotJDKReflectionGetMirror.invoke(hotSpotJVMCIRuntimeReflection, element);
                }
                if (element instanceof HotSpotResolvedObjectType) {
                    return (AnnotatedElement)hotSpotResolvedObjectTypeImplMirror.invoke((Object)element, new Object[0]);
                }
                return (AnnotatedElement)hotSpotResolvedPrimitiveTypeMirror.invoke((Object)element, new Object[0]);
            }
            if (element instanceof HotSpotResolvedJavaMethod) {
                if (((ResolvedJavaMethod)element).isClassInitializer()) {
                    return null;
                }
                if (isHotSpotJDKReflectionAvailable) {
                    return (AnnotatedElement)hotSpotJDKReflectionGetMethod.invoke(hotSpotJVMCIRuntimeReflection, element);
                }
                return (AnnotatedElement)hotSpotResolvedJavaMethodImplToJava.invoke((Object)element, new Object[0]);
            }
            if (element instanceof HotSpotResolvedJavaField) {
                if (isHotSpotJDKReflectionAvailable) {
                    return (AnnotatedElement)hotSpotJDKReflectionGetField.invoke(hotSpotJVMCIRuntimeReflection, element);
                }
                return (AnnotatedElement)hotSpotResolvedJavaFieldImplToJava.invoke((Object)element, new Object[0]);
            }
            if (element instanceof AnnotationWrapper) {
                return SubstrateAnnotationExtracter.getRoot(((AnnotationWrapper)element).getAnnotationRoot());
            }
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof LinkageError) {
                throw (LinkageError)targetException;
            }
            if (targetException instanceof IllegalArgumentException) {
                return null;
            }
            throw new AnnotationMetadata.AnnotationExtractionError(e);
        }
        catch (IllegalAccessException e) {
            throw new AnnotationMetadata.AnnotationExtractionError(e);
        }
        return element;
    }

    private static AnnotatedElement getSecondaryRoot(AnnotatedElement element) {
        if (element instanceof AnnotationWrapper) {
            return SubstrateAnnotationExtracter.getRoot(((AnnotationWrapper)element).getSecondaryAnnotationRoot());
        }
        return null;
    }

    private static List<Annotation> getInjectedAnnotations(AnnotatedElement element) {
        ArrayList<Annotation> injectedAnnotations = new ArrayList<Annotation>();
        if (element instanceof AnnotationWrapper) {
            AnnotatedElement secondaryRoot;
            AnnotatedElement root;
            AnnotationWrapper wrapper = (AnnotationWrapper)element;
            Annotation[] wrapperInjectedAnnotations = wrapper.getInjectedAnnotations();
            if (wrapperInjectedAnnotations != null) {
                injectedAnnotations.addAll(Arrays.asList(wrapperInjectedAnnotations));
            }
            if ((root = wrapper.getAnnotationRoot()) != null) {
                injectedAnnotations.addAll(SubstrateAnnotationExtracter.getInjectedAnnotations(root));
            }
            if ((secondaryRoot = wrapper.getSecondaryAnnotationRoot()) != null) {
                injectedAnnotations.addAll(SubstrateAnnotationExtracter.getInjectedAnnotations(secondaryRoot));
            }
        }
        return injectedAnnotations;
    }

    private static List<Class<? extends Annotation>> getIgnoredAnnotations(AnnotatedElement element) {
        ArrayList<Class<? extends Annotation>> ignoredAnnotations = new ArrayList<Class<? extends Annotation>>();
        if (element instanceof AnnotationWrapper) {
            AnnotatedElement secondaryRoot;
            AnnotatedElement root;
            AnnotationWrapper wrapper = (AnnotationWrapper)element;
            Class[] wrapperIgnoredAnnotations = wrapper.getIgnoredAnnotations();
            if (wrapperIgnoredAnnotations != null) {
                ignoredAnnotations.addAll(Arrays.asList(wrapperIgnoredAnnotations));
            }
            if ((root = wrapper.getAnnotationRoot()) != null) {
                ignoredAnnotations.addAll(SubstrateAnnotationExtracter.getIgnoredAnnotations(root));
            }
            if ((secondaryRoot = wrapper.getSecondaryAnnotationRoot()) != null) {
                ignoredAnnotations.addAll(SubstrateAnnotationExtracter.getIgnoredAnnotations(secondaryRoot));
            }
        }
        return ignoredAnnotations;
    }

    static {
        packageGetPackageInfo = ReflectionUtil.lookupMethod(Package.class, (String)"getPackageInfo", (Class[])new Class[0]);
        recordComponentClass = ReflectionUtil.lookupClass((boolean)true, (String)"java.lang.reflect.RecordComponent");
        recordComponentAnnotations = recordComponentClass != null ? ReflectionUtil.lookupField(recordComponentClass, (String)"annotations") : null;
        recordComponentTypeAnnotations = recordComponentClass != null ? ReflectionUtil.lookupField(recordComponentClass, (String)"typeAnnotations") : null;
        recordComponentGetDeclaringRecord = recordComponentClass != null ? ReflectionUtil.lookupMethod(recordComponentClass, (String)"getDeclaringRecord", (Class[])new Class[0]) : null;
        Object temporaryHotSpotJVMCIRuntimeReflection = null;
        Method temporaryHotSpotJDKReflectionGetMirror = null;
        Method temporaryHotSpotJDKReflectionGetMethod = null;
        Method temporaryHotSpotJDKReflectionGetField = null;
        boolean temporaryIsHotSpotJDKReflectionAvailable = true;
        try {
            Object hotSpotJVMCIRuntime = ReflectionUtil.lookupMethod(HotSpotJVMCIRuntime.class, (String)"runtime", (Class[])new Class[0]).invoke(null, new Object[0]);
            temporaryHotSpotJVMCIRuntimeReflection = ReflectionUtil.lookupMethod(HotSpotJVMCIRuntime.class, (String)"getReflection", (Class[])new Class[0]).invoke(hotSpotJVMCIRuntime, new Object[0]);
            temporaryHotSpotJDKReflectionGetMirror = ReflectionUtil.lookupMethod(Class.forName("jdk.vm.ci.hotspot.HotSpotJDKReflection"), (String)"getMirror", (Class[])new Class[]{HotSpotResolvedJavaType.class});
            temporaryHotSpotJDKReflectionGetMethod = ReflectionUtil.lookupMethod(Class.forName("jdk.vm.ci.hotspot.HotSpotJDKReflection"), (String)"getMethod", (Class[])new Class[]{Class.forName("jdk.vm.ci.hotspot.HotSpotResolvedJavaMethodImpl")});
            temporaryHotSpotJDKReflectionGetField = ReflectionUtil.lookupMethod(Class.forName("jdk.vm.ci.hotspot.HotSpotJDKReflection"), (String)"getField", (Class[])new Class[]{Class.forName("jdk.vm.ci.hotspot.HotSpotResolvedJavaFieldImpl")});
        }
        catch (ReflectionUtil.ReflectionUtilError | ClassNotFoundException | IllegalAccessException | InvocationTargetException ex) {
            temporaryIsHotSpotJDKReflectionAvailable = false;
        }
        isHotSpotJDKReflectionAvailable = temporaryIsHotSpotJDKReflectionAvailable;
        hotSpotJVMCIRuntimeReflection = temporaryHotSpotJVMCIRuntimeReflection;
        hotSpotJDKReflectionGetMirror = temporaryHotSpotJDKReflectionGetMirror;
        hotSpotJDKReflectionGetMethod = temporaryHotSpotJDKReflectionGetMethod;
        hotSpotJDKReflectionGetField = temporaryHotSpotJDKReflectionGetField;
        if (isHotSpotJDKReflectionAvailable) {
            hotSpotResolvedObjectTypeImplMirror = null;
            hotSpotResolvedPrimitiveTypeMirror = null;
            hotSpotResolvedJavaMethodImplToJava = null;
            hotSpotResolvedJavaFieldImplToJava = null;
        } else {
            try {
                hotSpotResolvedObjectTypeImplMirror = ReflectionUtil.lookupMethod(Class.forName("jdk.vm.ci.hotspot.HotSpotResolvedObjectTypeImpl"), (String)"mirror", (Class[])new Class[0]);
                hotSpotResolvedPrimitiveTypeMirror = ReflectionUtil.lookupMethod(Class.forName("jdk.vm.ci.hotspot.HotSpotResolvedPrimitiveType"), (String)"mirror", (Class[])new Class[0]);
                hotSpotResolvedJavaMethodImplToJava = ReflectionUtil.lookupMethod(Class.forName("jdk.vm.ci.hotspot.HotSpotResolvedJavaMethodImpl"), (String)"toJava", (Class[])new Class[0]);
                hotSpotResolvedJavaFieldImplToJava = ReflectionUtil.lookupMethod(Class.forName("jdk.vm.ci.hotspot.HotSpotResolvedJavaFieldImpl"), (String)"toJava", (Class[])new Class[0]);
            }
            catch (ClassNotFoundException e) {
                throw GraalError.shouldNotReachHere((Throwable)e);
            }
        }
    }
}

