/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.heap.VMOperationInfo;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.events.ExecuteVMOperationEvent;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.thread.NativeVMOperationData;
import com.oracle.svm.core.thread.VMOperationControl;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;

public abstract class VMOperation {
    private final VMOperationInfo info;

    protected VMOperation(VMOperationInfo info) {
        assert (info.getVMOperationClass() == this.getClass());
        this.info = info;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final int getId() {
        return this.info.getId();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final String getName() {
        return this.info.getName();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isGC() {
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final boolean getCausesSafepoint() {
        return this.info.getCausesSafepoint();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final boolean isBlocking() {
        return this.info.isBlocking();
    }

    protected final void execute(NativeVMOperationData data) {
        Log trace;
        assert (VMOperationControl.mayExecuteVmOperations());
        assert (!this.isFinished(data));
        Log log = trace = SubstrateOptions.TraceVMOperations.getValue() != false ? Log.log() : Log.noopLog();
        if (!this.hasWork(data)) {
            trace.string("[Skipping operation ").string(this.getName()).string("]");
            return;
        }
        VMOperationControl control = (VMOperationControl)ImageSingletons.lookup(VMOperationControl.class);
        VMOperation prevOperation = control.getInProgress().getOperation();
        IsolateThread prevQueuingThread = control.getInProgress().getQueuingThread();
        IsolateThread prevExecutingThread = control.getInProgress().getExecutingThread();
        IsolateThread requestingThread = this.getQueuingThread(data);
        control.setInProgress(this, requestingThread, CurrentIsolate.getCurrentThread(), true);
        long startTicks = JfrTicks.elapsedTicks();
        try {
            trace.string("[Executing operation ").string(this.getName());
            this.operate(data);
            trace.string("]");
        }
        catch (Throwable t) {
            trace.string("[VMOperation.execute caught: ").string(t.getClass().getName()).string("]").newline();
            throw VMError.shouldNotReachHere(t);
        }
        finally {
            ExecuteVMOperationEvent.emit(this, requestingThread, startTicks);
            control.setInProgress(prevOperation, prevQueuingThread, prevExecutingThread, false);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isInProgress() {
        VMOperationControl.OpInProgress inProgress = VMOperationControl.get().getInProgress();
        return VMOperation.isInProgress(inProgress);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isInProgressAtSafepoint() {
        VMOperationControl.OpInProgress inProgress = VMOperationControl.get().getInProgress();
        return VMOperation.isInProgress(inProgress) && inProgress.operation.getCausesSafepoint();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static boolean isInProgress(VMOperationControl.OpInProgress inProgress) {
        return inProgress.getExecutingThread() == CurrentIsolate.getCurrentThread();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isGCInProgress() {
        VMOperation op = VMOperationControl.get().getInProgress().getOperation();
        return op != null && op.isGC();
    }

    public static void guaranteeInProgress(String message) {
        if (!VMOperation.isInProgress()) {
            throw VMError.shouldNotReachHere(message);
        }
    }

    public static void guaranteeNotInProgress(String message) {
        if (VMOperation.isInProgress()) {
            throw VMError.shouldNotReachHere(message);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void guaranteeInProgressAtSafepoint(String message) {
        if (!VMOperation.isInProgressAtSafepoint()) {
            throw VMError.shouldNotReachHere(message);
        }
    }

    public static void guaranteeGCInProgress(String message) {
        if (!VMOperation.isGCInProgress()) {
            throw VMError.shouldNotReachHere(message);
        }
    }

    protected boolean hasWork(NativeVMOperationData data) {
        return true;
    }

    protected abstract IsolateThread getQueuingThread(NativeVMOperationData var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract void setQueuingThread(NativeVMOperationData var1, IsolateThread var2);

    protected abstract boolean isFinished(NativeVMOperationData var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract void setFinished(NativeVMOperationData var1, boolean var2);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, reason="Whitelisted because some operations may allocate.")
    protected abstract void operate(NativeVMOperationData var1);

    public static enum SystemEffect {
        NONE,
        SAFEPOINT;


        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean getCausesSafepoint(SystemEffect value) {
            return value == SAFEPOINT;
        }
    }
}

