/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jdk.StackTraceUtils;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.Target_java_lang_Thread;
import com.oracle.svm.core.thread.Target_java_lang_VirtualThread;
import com.oracle.svm.core.thread.Target_jdk_internal_vm_Continuation;
import com.oracle.svm.core.thread.Target_sun_nio_ch_Interruptible;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VirtualThreadHelper;
import com.oracle.svm.core.thread.VirtualThreads;
import com.oracle.svm.core.util.VMError;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordFactory;

final class LoomVirtualThreads
implements VirtualThreads {
    LoomVirtualThreads() {
    }

    private static Target_java_lang_VirtualThread cast(Thread thread) {
        return SubstrateUtil.cast(thread, Target_java_lang_VirtualThread.class);
    }

    @Override
    public ThreadFactory createFactory() {
        return Target_java_lang_Thread.ofVirtual().factory();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    public boolean isVirtual(Thread thread) {
        return Target_java_lang_VirtualThread.class.isInstance(thread);
    }

    @Override
    public void join(Thread thread, long millis) throws InterruptedException {
        if (thread.isAlive()) {
            long nanos = TimeUnit.MILLISECONDS.toNanos(millis);
            LoomVirtualThreads.cast(thread).joinNanos(nanos);
        }
    }

    @Platforms(value={})
    private static RuntimeException unreachable() {
        return VMError.shouldNotReachHere();
    }

    @Override
    public boolean getAndClearInterrupt(Thread thread) {
        return LoomVirtualThreads.cast(thread).getAndClearInterrupt();
    }

    @Override
    public void yield() {
        throw LoomVirtualThreads.unreachable();
    }

    @Override
    public void sleepMillis(long millis) {
        throw LoomVirtualThreads.unreachable();
    }

    @Override
    public boolean isAlive(Thread thread) {
        throw LoomVirtualThreads.unreachable();
    }

    @Override
    public void unpark(Thread thread) {
        throw LoomVirtualThreads.unreachable();
    }

    @Override
    public void park() {
        throw LoomVirtualThreads.unreachable();
    }

    @Override
    public void parkNanos(long nanos) {
        throw LoomVirtualThreads.unreachable();
    }

    @Override
    public void parkUntil(long deadline) {
        throw LoomVirtualThreads.unreachable();
    }

    @Override
    public void pinCurrent() {
        Target_jdk_internal_vm_Continuation.pin();
    }

    @Override
    public void unpinCurrent() {
        Target_jdk_internal_vm_Continuation.unpin();
    }

    @Override
    public Executor getScheduler(Thread thread) {
        return LoomVirtualThreads.cast((Thread)thread).scheduler;
    }

    @Override
    public void blockedOn(Target_sun_nio_ch_Interruptible b) {
        VirtualThreadHelper.blockedOn(b);
    }

    @Override
    public StackTraceElement[] getVirtualOrPlatformThreadStackTrace(boolean filterExceptions, Thread thread, Pointer callerSP) {
        if (!this.isVirtual(thread)) {
            return LoomVirtualThreads.getPlatformThreadStackTrace(filterExceptions, thread, callerSP);
        }
        if (thread == Thread.currentThread()) {
            return LoomVirtualThreads.getVirtualThreadStackTrace(filterExceptions, thread, callerSP);
        }
        assert (!filterExceptions) : "exception stack traces can be taken only for the current thread";
        return LoomVirtualThreads.asyncGetStackTrace(LoomVirtualThreads.cast(thread));
    }

    @Override
    public StackTraceElement[] getVirtualOrPlatformThreadStackTraceAtSafepoint(Thread thread, Pointer callerSP) {
        if (!this.isVirtual(thread)) {
            return LoomVirtualThreads.getPlatformThreadStackTraceAtSafepoint(thread, callerSP);
        }
        return LoomVirtualThreads.getVirtualThreadStackTrace(false, thread, callerSP);
    }

    private static StackTraceElement[] getVirtualThreadStackTrace(boolean filterExceptions, Thread thread, Pointer callerSP) {
        Thread carrier = LoomVirtualThreads.cast((Thread)thread).carrierThread;
        if (carrier == null) {
            return null;
        }
        Pointer endSP = LoomVirtualThreads.getCarrierSPOrElse(carrier, (Pointer)WordFactory.nullPointer());
        if (endSP.isNull()) {
            return null;
        }
        if (carrier == PlatformThreads.currentThread.get()) {
            return StackTraceUtils.getStackTrace(filterExceptions, callerSP, endSP);
        }
        assert (VMOperation.isInProgressAtSafepoint());
        return StackTraceUtils.getThreadStackTraceAtSafepoint(PlatformThreads.getIsolateThread(carrier), endSP);
    }

    private static Pointer getCarrierSPOrElse(Thread carrier, Pointer other) {
        for (Target_jdk_internal_vm_Continuation cont = JavaThreads.toTarget((Thread)carrier).cont; cont != null; cont = cont.getParent()) {
            if (cont.getScope() != Target_java_lang_VirtualThread.VTHREAD_SCOPE) continue;
            return cont.internal.getBaseSP();
        }
        return other;
    }

    private static StackTraceElement[] asyncGetStackTrace(Target_java_lang_VirtualThread thread) {
        StackTraceElement[] stackTrace;
        do {
            if ((stackTrace = thread.carrierThread != null ? LoomVirtualThreads.asyncMountedGetStackTrace(thread) : thread.tryGetStackTrace()) != null) continue;
            Thread.yield();
        } while (stackTrace == null);
        return stackTrace;
    }

    @SuppressFBWarnings(value={"BC_IMPOSSIBLE_CAST"}, justification="substitution hides acual type")
    private static StackTraceElement[] asyncMountedGetStackTrace(Target_java_lang_VirtualThread thread) {
        return StackTraceUtils.asyncGetStackTrace(SubstrateUtil.cast(thread, Thread.class));
    }

    private static StackTraceElement[] getPlatformThreadStackTrace(boolean filterExceptions, Thread thread, Pointer callerSP) {
        if (thread == PlatformThreads.currentThread.get()) {
            Pointer startSP = LoomVirtualThreads.getCarrierSPOrElse(thread, callerSP);
            return StackTraceUtils.getStackTrace(filterExceptions, startSP, (Pointer)WordFactory.nullPointer());
        }
        assert (!filterExceptions) : "exception stack traces can be taken only for the current thread";
        return StackTraceUtils.asyncGetStackTrace(thread);
    }

    private static StackTraceElement[] getPlatformThreadStackTraceAtSafepoint(Thread thread, Pointer callerSP) {
        Pointer carrierSP = LoomVirtualThreads.getCarrierSPOrElse(thread, (Pointer)WordFactory.nullPointer());
        IsolateThread isolateThread = PlatformThreads.getIsolateThread(thread);
        if (isolateThread == CurrentIsolate.getCurrentThread()) {
            Pointer startSP = carrierSP.isNonNull() ? carrierSP : callerSP;
            return StackTraceUtils.getStackTrace(false, startSP, (Pointer)WordFactory.nullPointer());
        }
        if (carrierSP.isNonNull()) {
            CodePointer carrierIP = FrameAccess.singleton().readReturnAddress(carrierSP);
            return StackTraceUtils.getThreadStackTraceAtSafepoint(carrierSP, (Pointer)WordFactory.nullPointer(), carrierIP);
        }
        return StackTraceUtils.getThreadStackTraceAtSafepoint(isolateThread, (Pointer)WordFactory.nullPointer());
    }
}

