/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.localization;

import com.oracle.svm.core.jdk.localization.LocalizationSupport;
import com.oracle.svm.core.jdk.localization.bundles.DelayedBundle;
import com.oracle.svm.core.jdk.localization.bundles.ExtractedBundle;
import com.oracle.svm.core.jdk.localization.bundles.StoredBundle;
import com.oracle.svm.core.jdk.localization.compression.GzipBundleCompression;
import com.oracle.svm.core.jdk.localization.compression.utils.BundleSerializationUtils;
import com.oracle.svm.core.util.UserError;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import sun.util.resources.OpenListResourceBundle;
import sun.util.resources.ParallelListResourceBundle;

public class BundleContentSubstitutedLocalizationSupport
extends LocalizationSupport {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static final String INTERNAL_BUNDLES_PATTERN = "sun\\..*";
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final List<Pattern> compressBundlesPatterns;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final ForkJoinPool pool;
    private final Map<Class<?>, StoredBundle> storedBundles = new ConcurrentHashMap();

    public BundleContentSubstitutedLocalizationSupport(Locale defaultLocale, Set<Locale> locales, Charset defaultCharset, List<String> requestedPatterns, ForkJoinPool pool) {
        super(defaultLocale, locales, defaultCharset);
        this.pool = pool;
        this.compressBundlesPatterns = BundleContentSubstitutedLocalizationSupport.parseCompressBundlePatterns(requestedPatterns);
    }

    @Override
    public boolean substituteLoadLookup() {
        return true;
    }

    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected void onBundlePrepared(ResourceBundle bundle) {
        if (BundleContentSubstitutedLocalizationSupport.isBundleSupported(bundle)) {
            if (this.pool != null) {
                this.pool.execute(() -> this.storeBundleContentOf(bundle));
            } else {
                this.storeBundleContentOf(bundle);
            }
        }
    }

    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected void onClassBundlePrepared(Class<?> bundleClass) {
        if (BundleContentSubstitutedLocalizationSupport.isBundleSupported(bundleClass)) {
            this.prepareNonCompliant(bundleClass);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private void storeBundleContentOf(ResourceBundle bundle) {
        GraalError.guarantee((boolean)BundleContentSubstitutedLocalizationSupport.isBundleSupported(bundle), (String)"Unsupported bundle %s of type %s", (Object)bundle, bundle.getClass());
        this.storedBundles.put(bundle.getClass(), this.processBundle(bundle));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private StoredBundle processBundle(ResourceBundle bundle) {
        boolean isInDefaultLocale = bundle.getLocale().equals(this.defaultLocale);
        if (!isInDefaultLocale && this.shouldCompressBundle(bundle) && GzipBundleCompression.canCompress(bundle)) {
            return GzipBundleCompression.compress(bundle);
        }
        Map<String, Object> content = BundleSerializationUtils.extractContent(bundle);
        return new ExtractedBundle(content);
    }

    @Override
    public Map<String, Object> getBundleContentOf(Object bundle) {
        StoredBundle storedBundle = this.storedBundles.get(bundle.getClass());
        if (storedBundle != null) {
            return storedBundle.getContent(bundle);
        }
        return super.getBundleContentOf(bundle);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static boolean isBundleSupported(ResourceBundle bundle) {
        return BundleContentSubstitutedLocalizationSupport.isBundleSupported(bundle.getClass());
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static boolean isBundleSupported(Class<?> bundleClass) {
        return ListResourceBundle.class.isAssignableFrom(bundleClass) || OpenListResourceBundle.class.isAssignableFrom(bundleClass) || ParallelListResourceBundle.class.isAssignableFrom(bundleClass);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static List<Pattern> parseCompressBundlePatterns(List<String> userPatterns) {
        ArrayList<Pattern> compiled = new ArrayList<Pattern>();
        ArrayList<String> invalid = new ArrayList<String>();
        compiled.add(Pattern.compile(INTERNAL_BUNDLES_PATTERN));
        for (String pattern : userPatterns) {
            try {
                compiled.add(Pattern.compile(pattern));
            }
            catch (PatternSyntaxException ex) {
                invalid.add(pattern);
            }
        }
        if (!invalid.isEmpty()) {
            throw UserError.abort("Invalid patterns specified: %s", invalid);
        }
        return compiled;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public boolean shouldCompressBundle(ResourceBundle bundle) {
        String className = bundle.getClass().getName();
        return this.compressBundlesPatterns.stream().anyMatch(pattern -> pattern.matcher(className).matches());
    }

    @Override
    public void prepareNonCompliant(Class<?> clazz) {
        this.storedBundles.put(clazz, new DelayedBundle(clazz));
    }
}

