/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.util.GraphUtil;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public class MethodReturnNode
extends FixedWithNextNode
implements Lowerable {
    public static final NodeClass<MethodReturnNode> TYPE = NodeClass.create(MethodReturnNode.class);
    @Node.Input
    protected ValueNode result;

    protected MethodReturnNode(ValueNode result) {
        super(TYPE, StampFactory.object());
        this.result = result;
    }

    public void lower(LoweringTool tool) {
        FixedNode originalNext = this.next();
        this.replaceFirstSuccessor((Node)originalNext, null);
        GraphUtil.killCFG((FixedNode)originalNext);
        this.replaceAtPredecessor(this.graph().add((Node)new ReturnNode(this.result)));
        this.safeDelete();
    }

    @Node.NodeIntrinsic
    public static native RuntimeException methodReturn(Object var0);
}

