/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.aarch64;

import com.oracle.svm.core.CalleeSavedRegisters;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.aarch64.SubstrateAArch64RegisterConfig;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

final class AArch64CalleeSavedRegisters
extends CalleeSavedRegisters {
    @Fold
    public static AArch64CalleeSavedRegisters singleton() {
        return (AArch64CalleeSavedRegisters)CalleeSavedRegisters.singleton();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void createAndRegister() {
        SubstrateTargetDescription target = ConfigurationValues.getTarget();
        SubstrateAArch64RegisterConfig registerConfig = new SubstrateAArch64RegisterConfig(SubstrateRegisterConfig.ConfigKind.NORMAL, null, target, SubstrateOptions.PreserveFramePointer.getValue());
        Register frameRegister = registerConfig.getFrameRegister();
        ArrayList<Register> calleeSavedRegisters = new ArrayList<Register>(registerConfig.getAllocatableRegisters().asList());
        calleeSavedRegisters.remove(AArch64.lr);
        Collections.reverse(calleeSavedRegisters);
        int offset = 0;
        HashMap<Register, Integer> calleeSavedRegisterOffsets = new HashMap<Register, Integer>();
        for (Register register : calleeSavedRegisters) {
            int regByteSize = register.getRegisterCategory().equals((Object)AArch64.CPU) ? 8 : 16;
            offset += offset % regByteSize;
            calleeSavedRegisterOffsets.put(register, offset);
            offset += regByteSize;
        }
        int calleeSavedRegistersSizeInBytes = offset;
        int saveAreaOffsetInFrame = -(FrameAccess.returnAddressSize() + FrameAccess.wordSize() + calleeSavedRegistersSizeInBytes);
        ImageSingletons.add(CalleeSavedRegisters.class, (Object)new AArch64CalleeSavedRegisters(frameRegister, calleeSavedRegisters, calleeSavedRegisterOffsets, calleeSavedRegistersSizeInBytes, saveAreaOffsetInFrame));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private AArch64CalleeSavedRegisters(Register frameRegister, List<Register> calleeSavedRegisters, Map<Register, Integer> offsetsInSaveArea, int saveAreaSize, int saveAreaOffsetInFrame) {
        super(frameRegister, calleeSavedRegisters, offsetsInSaveArea, saveAreaSize, saveAreaOffsetInFrame);
    }

    public void emitSave(AArch64MacroAssembler masm, int frameSize) {
        try (AArch64MacroAssembler.ScratchRegister scratch = masm.getScratchRegister();){
            Register scratchReg = scratch.getRegister();
            ScratchRegState scratchState = ScratchRegState.initialize(masm, scratchReg, this.frameRegister, frameSize + this.saveAreaOffsetInFrame);
            for (Register register : this.calleeSavedRegisters) {
                AArch64Address address = this.calleeSaveAddress(scratchState, register);
                Register.RegisterCategory category = register.getRegisterCategory();
                if (category.equals((Object)AArch64.CPU)) {
                    masm.str(64, register, address);
                    continue;
                }
                assert (category.equals((Object)AArch64.SIMD));
                masm.fstr(128, register, address);
            }
        }
    }

    public void emitRestore(AArch64MacroAssembler masm, int frameSize, Register excludedRegister) {
        try (AArch64MacroAssembler.ScratchRegister scratch = masm.getScratchRegister();){
            Register scratchReg = scratch.getRegister();
            ScratchRegState scratchState = ScratchRegState.initialize(masm, scratchReg, this.frameRegister, frameSize + this.saveAreaOffsetInFrame);
            for (Register register : this.calleeSavedRegisters) {
                if (register.equals((Object)excludedRegister)) continue;
                AArch64Address address = this.calleeSaveAddress(scratchState, register);
                if (register.getRegisterCategory().equals((Object)AArch64.CPU)) {
                    masm.ldr(64, register, address);
                    continue;
                }
                assert (register.getRegisterCategory().equals((Object)AArch64.SIMD));
                masm.fldr(128, register, address);
            }
        }
    }

    private AArch64Address calleeSaveAddress(ScratchRegState scratchState, Register register) {
        int size = register.getRegisterCategory().equals((Object)AArch64.CPU) ? 64 : 128;
        int immOffset = scratchState.getAddressOffset(size, (Integer)this.offsetsInSaveArea.get(register));
        return AArch64Address.createImmediateAddress((int)size, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, (Register)scratchState.scratch, (int)immOffset);
    }

    private static final class ScratchRegState {
        final int maxUnscaledOffset = NumUtil.getNbitNumberInt((int)6);
        final Register scratch;
        final AArch64MacroAssembler masm;
        int curScratchOffset;

        private ScratchRegState(AArch64MacroAssembler masm, Register scratch, int initialOffset) {
            this.masm = masm;
            this.scratch = scratch;
            this.curScratchOffset = initialOffset;
        }

        static ScratchRegState initialize(AArch64MacroAssembler masm, Register scratch, Register frameRegister, int saveAreaBase) {
            masm.add(64, scratch, frameRegister, saveAreaBase);
            return new ScratchRegState(masm, scratch, 0);
        }

        int getAddressOffset(int regSize, int offset) {
            int offsetFromScratch = offset - this.curScratchOffset;
            assert (offsetFromScratch >= 0);
            if (offsetFromScratch > this.maxUnscaledOffset * regSize / 8) {
                this.masm.add(64, this.scratch, this.scratch, offsetFromScratch);
                this.curScratchOffset = offset;
                return 0;
            }
            return offsetFromScratch;
        }
    }
}

