/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.JfrGCEventSupport;
import com.oracle.svm.core.heap.GCCause;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.UnsignedWord;

class JfrGCEvents {
    JfrGCEvents() {
    }

    public static long startGCPhasePause() {
        if (JfrGCEvents.hasJfrSupport()) {
            return JfrGCEvents.jfrSupport().startGCPhasePause();
        }
        return 0L;
    }

    public static void emitGCPhasePauseEvent(UnsignedWord gcEpoch, String name, long start) {
        if (JfrGCEvents.hasJfrSupport()) {
            int level = JfrGCEvents.jfrSupport().stopGCPhasePause();
            if (start != 0L) {
                JfrGCEvents.jfrSupport().emitGCPhasePauseEvent(gcEpoch, level, name, start);
            }
        }
    }

    public static void emitGarbageCollectionEvent(UnsignedWord gcEpoch, GCCause cause, long start) {
        if (JfrGCEvents.hasJfrSupport() && start != 0L) {
            JfrGCEvents.jfrSupport().emitGarbageCollectionEvent(gcEpoch, cause, start);
        }
    }

    @Fold
    static boolean hasJfrSupport() {
        return ImageSingletons.contains(JfrGCEventSupport.class);
    }

    @Fold
    static JfrGCEventSupport jfrSupport() {
        return (JfrGCEventSupport)ImageSingletons.lookup(JfrGCEventSupport.class);
    }
}

