/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.util.UnsignedUtils;
import org.graalvm.word.UnsignedWord;

class AdaptiveWeightedAverage {
    static final int OLD_THRESHOLD = 100;
    private final int weight;
    private double average;
    private long sampleCount;
    private boolean isOld;

    AdaptiveWeightedAverage(int weight) {
        this(weight, 0.0);
    }

    AdaptiveWeightedAverage(int weight, double avg) {
        this.weight = weight;
        this.average = avg;
    }

    public double getAverage() {
        return this.average;
    }

    public void sample(double value) {
        ++this.sampleCount;
        if (!this.isOld && this.sampleCount > 100L) {
            this.isOld = true;
        }
        this.average = this.computeAdaptiveAverage(value, this.average);
    }

    public final void sample(UnsignedWord value) {
        this.sample(UnsignedUtils.toDouble(value));
    }

    protected double computeAdaptiveAverage(double sample, double avg) {
        long countWeight = 0L;
        if (!this.isOld) {
            countWeight = 100L / this.sampleCount;
        }
        long adaptiveWeight = Math.max((long)this.weight, countWeight);
        return AdaptiveWeightedAverage.expAvg(avg, sample, adaptiveWeight);
    }

    private static double expAvg(double avg, double sample, long adaptiveWeight) {
        assert (adaptiveWeight <= 100L) : "weight must be a percentage";
        return (100.0 - (double)adaptiveWeight) * avg / 100.0 + (double)adaptiveWeight * sample / 100.0;
    }
}

