/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.containers.cgroupv1;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.containers.CgroupSubsystem;
import com.oracle.svm.core.containers.CgroupSubsystemController;
import com.oracle.svm.core.containers.CgroupUtil;
import com.oracle.svm.core.containers.CgroupV1Metrics;
import com.oracle.svm.core.containers.cgroupv1.CgroupV1MemorySubSystemController;
import com.oracle.svm.core.containers.cgroupv1.CgroupV1SubsystemController;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class CgroupV1Subsystem
implements CgroupSubsystem,
CgroupV1Metrics {
    private CgroupV1MemorySubSystemController memory;
    private CgroupV1SubsystemController cpu;
    private CgroupV1SubsystemController cpuacct;
    private CgroupV1SubsystemController cpuset;
    private CgroupV1SubsystemController blkio;
    private boolean activeSubSystems = false;
    private static final CgroupV1Subsystem INSTANCE = CgroupV1Subsystem.initSubSystem();
    private static final String PROVIDER_NAME = "cgroupv1";

    private CgroupV1Subsystem() {
    }

    public static CgroupV1Subsystem getInstance() {
        return INSTANCE;
    }

    private static CgroupV1Subsystem initSubSystem() {
        String[] tokens;
        CgroupV1Subsystem subsystem = new CgroupV1Subsystem();
        try {
            for (String line : CgroupUtil.readAllLinesPrivileged(Paths.get("/proc/self/mountinfo", new String[0]))) {
                if (!line.contains(" - cgroup ")) continue;
                tokens = SubstrateUtil.split(line, " ");
                CgroupV1Subsystem.createSubSystemController(subsystem, tokens);
            }
        }
        catch (IOException e) {
            return null;
        }
        try {
            for (String line : CgroupUtil.readAllLinesPrivileged(Paths.get("/proc/self/cgroup", new String[0]))) {
                tokens = SubstrateUtil.split(line, ":");
                if (tokens.length < 3) continue;
                CgroupV1Subsystem.setSubSystemControllerPath(subsystem, tokens);
            }
        }
        catch (IOException e) {
            return null;
        }
        if (subsystem.activeSubSystems()) {
            return subsystem;
        }
        return null;
    }

    private static void createSubSystemController(CgroupV1Subsystem subsystem, String[] mountentry) {
        String[] subsystemNames;
        if (mountentry.length < 5) {
            return;
        }
        Path p = Paths.get(mountentry[4], new String[0]);
        String[] stringArray = subsystemNames = SubstrateUtil.split(p.getFileName().toString(), ",");
        int n = stringArray.length;
        block14: for (int i = 0; i < n; ++i) {
            String subsystemName;
            switch (subsystemName = stringArray[i]) {
                case "memory": {
                    subsystem.setMemorySubSystem(new CgroupV1MemorySubSystemController(mountentry[3], mountentry[4]));
                    continue block14;
                }
                case "cpuset": {
                    subsystem.setCpuSetController(new CgroupV1SubsystemController(mountentry[3], mountentry[4]));
                    continue block14;
                }
                case "cpuacct": {
                    subsystem.setCpuAcctController(new CgroupV1SubsystemController(mountentry[3], mountentry[4]));
                    continue block14;
                }
                case "cpu": {
                    subsystem.setCpuController(new CgroupV1SubsystemController(mountentry[3], mountentry[4]));
                    continue block14;
                }
                case "blkio": {
                    subsystem.setBlkIOController(new CgroupV1SubsystemController(mountentry[3], mountentry[4]));
                    continue block14;
                }
            }
        }
    }

    private static void setSubSystemControllerPath(CgroupV1Subsystem subsystem, String[] entry) {
        CgroupV1SubsystemController controller = null;
        CgroupV1SubsystemController controller2 = null;
        String controllerName = entry[1];
        String base = entry[2];
        if (controllerName != null && base != null) {
            switch (controllerName) {
                case "memory": {
                    controller = subsystem.memoryController();
                    break;
                }
                case "cpuset": {
                    controller = subsystem.cpuSetController();
                    break;
                }
                case "cpu,cpuacct": 
                case "cpuacct,cpu": {
                    controller = subsystem.cpuController();
                    controller2 = subsystem.cpuAcctController();
                    break;
                }
                case "cpuacct": {
                    controller = subsystem.cpuAcctController();
                    break;
                }
                case "cpu": {
                    controller = subsystem.cpuController();
                    break;
                }
                case "blkio": {
                    controller = subsystem.blkIOController();
                    break;
                }
            }
        }
        if (controller != null) {
            controller.setPath(base);
            if (controller instanceof CgroupV1MemorySubSystemController) {
                CgroupV1MemorySubSystemController memorySubSystem = (CgroupV1MemorySubSystemController)controller;
                boolean isHierarchial = CgroupV1Subsystem.getHierarchical(memorySubSystem);
                memorySubSystem.setHierarchical(isHierarchial);
            }
            subsystem.setActiveSubSystems();
        }
        if (controller2 != null) {
            controller2.setPath(base);
        }
    }

    private static boolean getHierarchical(CgroupV1MemorySubSystemController controller) {
        long hierarchical = CgroupV1Subsystem.getLongValue(controller, "memory.use_hierarchy");
        return hierarchical > 0L;
    }

    private void setActiveSubSystems() {
        this.activeSubSystems = true;
    }

    private boolean activeSubSystems() {
        return this.activeSubSystems;
    }

    private void setMemorySubSystem(CgroupV1MemorySubSystemController memory) {
        this.memory = memory;
    }

    private void setCpuController(CgroupV1SubsystemController cpu) {
        this.cpu = cpu;
    }

    private void setCpuAcctController(CgroupV1SubsystemController cpuacct) {
        this.cpuacct = cpuacct;
    }

    private void setCpuSetController(CgroupV1SubsystemController cpuset) {
        this.cpuset = cpuset;
    }

    private void setBlkIOController(CgroupV1SubsystemController blkio) {
        this.blkio = blkio;
    }

    private CgroupV1SubsystemController memoryController() {
        return this.memory;
    }

    private CgroupV1SubsystemController cpuController() {
        return this.cpu;
    }

    private CgroupV1SubsystemController cpuAcctController() {
        return this.cpuacct;
    }

    private CgroupV1SubsystemController cpuSetController() {
        return this.cpuset;
    }

    private CgroupV1SubsystemController blkIOController() {
        return this.blkio;
    }

    private static long getLongValue(CgroupSubsystemController controller, String parm) {
        return CgroupSubsystemController.getLongValue(controller, parm, CgroupV1SubsystemController::convertStringToLong, -1L);
    }

    @Override
    public String getProvider() {
        return PROVIDER_NAME;
    }

    @Override
    public long getCpuUsage() {
        return CgroupV1Subsystem.getLongValue(this.cpuacct, "cpuacct.usage");
    }

    @Override
    public long[] getPerCpuUsage() {
        String usagelist = CgroupSubsystemController.getStringValue(this.cpuacct, "cpuacct.usage_percpu");
        if (usagelist == null) {
            return null;
        }
        String[] list = SubstrateUtil.split(usagelist, " ");
        long[] percpu = new long[list.length];
        for (int i = 0; i < list.length; ++i) {
            percpu[i] = Long.parseLong(list[i]);
        }
        return percpu;
    }

    @Override
    public long getCpuUserUsage() {
        return CgroupV1SubsystemController.getLongEntry(this.cpuacct, "cpuacct.stat", "user");
    }

    @Override
    public long getCpuSystemUsage() {
        return CgroupV1SubsystemController.getLongEntry(this.cpuacct, "cpuacct.stat", "system");
    }

    @Override
    public long getCpuPeriod() {
        return CgroupV1Subsystem.getLongValue(this.cpu, "cpu.cfs_period_us");
    }

    @Override
    public long getCpuQuota() {
        return CgroupV1Subsystem.getLongValue(this.cpu, "cpu.cfs_quota_us");
    }

    @Override
    public long getCpuShares() {
        long retval = CgroupV1Subsystem.getLongValue(this.cpu, "cpu.shares");
        if (retval == 0L || retval == 1024L) {
            return -1L;
        }
        return retval;
    }

    @Override
    public long getCpuNumPeriods() {
        return CgroupV1SubsystemController.getLongEntry(this.cpu, "cpu.stat", "nr_periods");
    }

    @Override
    public long getCpuNumThrottled() {
        return CgroupV1SubsystemController.getLongEntry(this.cpu, "cpu.stat", "nr_throttled");
    }

    @Override
    public long getCpuThrottledTime() {
        return CgroupV1SubsystemController.getLongEntry(this.cpu, "cpu.stat", "throttled_time");
    }

    @Override
    public long getEffectiveCpuCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public int[] getCpuSetCpus() {
        return CgroupSubsystemController.stringRangeToIntArray(CgroupSubsystemController.getStringValue(this.cpuset, "cpuset.cpus"));
    }

    @Override
    public int[] getEffectiveCpuSetCpus() {
        return CgroupSubsystemController.stringRangeToIntArray(CgroupSubsystemController.getStringValue(this.cpuset, "cpuset.effective_cpus"));
    }

    @Override
    public int[] getCpuSetMems() {
        return CgroupSubsystemController.stringRangeToIntArray(CgroupSubsystemController.getStringValue(this.cpuset, "cpuset.mems"));
    }

    @Override
    public int[] getEffectiveCpuSetMems() {
        return CgroupSubsystemController.stringRangeToIntArray(CgroupSubsystemController.getStringValue(this.cpuset, "cpuset.effective_mems"));
    }

    @Override
    public double getCpuSetMemoryPressure() {
        return CgroupV1SubsystemController.getDoubleValue(this.cpuset, "cpuset.memory_pressure");
    }

    @Override
    public Boolean isCpuSetMemoryPressureEnabled() {
        long val = CgroupV1Subsystem.getLongValue(this.cpuset, "cpuset.memory_pressure_enabled");
        return val == 1L;
    }

    @Override
    public long getMemoryFailCount() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.failcnt");
    }

    @Override
    public long getMemoryLimit() {
        long retval = CgroupV1Subsystem.getLongValue(this.memory, "memory.limit_in_bytes");
        if (retval > CgroupV1SubsystemController.UNLIMITED_MIN && this.memory.isHierarchical()) {
            String match = "hierarchical_memory_limit";
            retval = CgroupV1SubsystemController.getLongValueMatchingLine(this.memory, "memory.stat", match);
        }
        return CgroupV1SubsystemController.longValOrUnlimited(retval);
    }

    @Override
    public long getMemoryMaxUsage() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.max_usage_in_bytes");
    }

    @Override
    public long getMemoryUsage() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.usage_in_bytes");
    }

    @Override
    public long getKernelMemoryFailCount() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.failcnt");
    }

    @Override
    public long getKernelMemoryLimit() {
        return CgroupV1SubsystemController.longValOrUnlimited(CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.limit_in_bytes"));
    }

    @Override
    public long getKernelMemoryMaxUsage() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.max_usage_in_bytes");
    }

    @Override
    public long getKernelMemoryUsage() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.usage_in_bytes");
    }

    @Override
    public long getTcpMemoryFailCount() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.tcp.failcnt");
    }

    @Override
    public long getTcpMemoryLimit() {
        return CgroupV1SubsystemController.longValOrUnlimited(CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.tcp.limit_in_bytes"));
    }

    @Override
    public long getTcpMemoryMaxUsage() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.tcp.max_usage_in_bytes");
    }

    @Override
    public long getTcpMemoryUsage() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.tcp.usage_in_bytes");
    }

    @Override
    public long getMemoryAndSwapFailCount() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.memsw.failcnt");
    }

    @Override
    public long getMemoryAndSwapLimit() {
        long retval = CgroupV1Subsystem.getLongValue(this.memory, "memory.memsw.limit_in_bytes");
        if (retval > CgroupV1SubsystemController.UNLIMITED_MIN && this.memory.isHierarchical()) {
            String match = "hierarchical_memsw_limit";
            retval = CgroupV1SubsystemController.getLongValueMatchingLine(this.memory, "memory.stat", match);
        }
        return CgroupV1SubsystemController.longValOrUnlimited(retval);
    }

    @Override
    public long getMemoryAndSwapMaxUsage() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.memsw.max_usage_in_bytes");
    }

    @Override
    public long getMemoryAndSwapUsage() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.memsw.usage_in_bytes");
    }

    @Override
    public Boolean isMemoryOOMKillEnabled() {
        long val = CgroupV1SubsystemController.getLongEntry(this.memory, "memory.oom_control", "oom_kill_disable");
        return val == 0L;
    }

    @Override
    public long getMemorySoftLimit() {
        return CgroupV1SubsystemController.longValOrUnlimited(CgroupV1Subsystem.getLongValue(this.memory, "memory.soft_limit_in_bytes"));
    }

    @Override
    public long getBlkIOServiceCount() {
        return CgroupV1SubsystemController.getLongEntry(this.blkio, "blkio.throttle.io_service_bytes", "Total");
    }

    @Override
    public long getBlkIOServiced() {
        return CgroupV1SubsystemController.getLongEntry(this.blkio, "blkio.throttle.io_serviced", "Total");
    }
}

