/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.ContainerInfo;
import com.oracle.svm.core.jdk.Jvm;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.RuntimeOptionKey;
import org.graalvm.nativeimage.Platform;

public class Containers {
    public static final int UNKNOWN = -1;
    private static final int PER_CPU_SHARES = 1024;

    public static int activeProcessorCount() {
        ContainerInfo info;
        int cpuCount;
        int limitCount = cpuCount = Jvm.JVM_ActiveProcessorCount();
        if (Options.UseContainerSupport.getValue().booleanValue() && Platform.includedIn(Platform.LINUX.class) && (info = new ContainerInfo()).isContainerized()) {
            long quota = info.getCpuQuota();
            long period = info.getCpuPeriod();
            long shares = Options.UseContainerCpuShares.getValue() != false ? info.getCpuShares() : -1L;
            int quotaCount = 0;
            if (quota > -1L && period > 0L) {
                quotaCount = (int)Math.ceil((double)quota / (double)period);
            }
            int shareCount = 0;
            if (shares > -1L) {
                shareCount = (int)Math.ceil((double)shares / 1024.0);
            }
            if (quotaCount != 0 && shareCount != 0) {
                limitCount = Options.PreferContainerQuotaForCPUCount.getValue().booleanValue() ? quotaCount : Math.min(quotaCount, shareCount);
            } else if (quotaCount != 0) {
                limitCount = quotaCount;
            } else if (shareCount != 0) {
                limitCount = shareCount;
            }
        }
        return Math.min(cpuCount, limitCount);
    }

    public static boolean isContainerized() {
        if (Options.UseContainerSupport.getValue().booleanValue() && Platform.includedIn(Platform.LINUX.class)) {
            ContainerInfo info = new ContainerInfo();
            return info.isContainerized();
        }
        return false;
    }

    public static long memoryLimitInBytes() {
        long memoryLimit;
        ContainerInfo info;
        if (Options.UseContainerSupport.getValue().booleanValue() && Platform.includedIn(Platform.LINUX.class) && (info = new ContainerInfo()).isContainerized() && (memoryLimit = info.getMemoryLimit()) > 0L) {
            return memoryLimit;
        }
        return -1L;
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> UseContainerSupport = new HostedOptionKey<Boolean>(true);
        public static final HostedOptionKey<Boolean> UseContainerCpuShares = new HostedOptionKey<Boolean>(false);
        public static final RuntimeOptionKey<Boolean> PreferContainerQuotaForCPUCount = new RuntimeOptionKey<Boolean>(Boolean.valueOf(true), RuntimeOptionKey.RuntimeOptionKeyFlag.RelevantForCompilationIsolates);
    }
}

