/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.typestate;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.EmptyTypeState;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;

final class NullTypeState
extends TypeState {
    static final TypeState SINGLETON = new NullTypeState();

    private NullTypeState() {
        super(0);
    }

    @Override
    public boolean hasExactTypes(BitSet typesBitSet) {
        return typesBitSet.isEmpty();
    }

    @Override
    public AnalysisType exactType() {
        return null;
    }

    @Override
    public int typesCount() {
        return 0;
    }

    @Override
    public Iterator<AnalysisType> typesIterator(BigBang bb) {
        return Collections.emptyIterator();
    }

    @Override
    protected Iterator<AnalysisObject> objectsIterator(BigBang bb) {
        return Collections.emptyIterator();
    }

    @Override
    public Iterator<AnalysisObject> objectsIterator(AnalysisType type) {
        return Collections.emptyIterator();
    }

    @Override
    public boolean containsType(AnalysisType exactType) {
        return false;
    }

    @Override
    public TypeState forCanBeNull(PointsToAnalysis bb, boolean stateCanBeNull) {
        return stateCanBeNull ? SINGLETON : EmptyTypeState.SINGLETON;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int objectsCount() {
        return 0;
    }

    @Override
    public boolean canBeNull() {
        return true;
    }

    public String toString() {
        return "Null";
    }
}

