/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.pkgtest;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.junit.jupiter.api.Assertions;

public abstract class JanusGraphAssemblyBaseIT {
    protected static final String BUILD_DIR;
    protected static final String EXPECT_DIR;
    protected static final String ZIPFILE_PATH;
    protected static final String ZIPFILE_EXTRACTED;
    protected static final String ZIPFILE_FULL_PATH;
    protected static final String ZIPFILE_FULL_EXTRACTED;

    protected void unzipAndRunExpect(String expectTemplateName, Map<String, String> contextVars, boolean full, boolean debug) throws Exception {
        if (full) {
            FileUtils.deleteQuietly((File)new File(ZIPFILE_FULL_EXTRACTED));
            JanusGraphAssemblyBaseIT.unzip(BUILD_DIR, ZIPFILE_FULL_PATH);
        } else {
            FileUtils.deleteQuietly((File)new File(ZIPFILE_EXTRACTED));
            JanusGraphAssemblyBaseIT.unzip(BUILD_DIR, ZIPFILE_PATH);
        }
        this.parseTemplateAndRunExpect(expectTemplateName, contextVars, full, debug);
    }

    protected void parseTemplateAndRunExpect(String expectTemplateName, Map<String, String> contextVars) throws IOException, InterruptedException {
        this.parseTemplateAndRunExpect(expectTemplateName, contextVars, true, false);
    }

    protected void parseTemplateAndRunExpect(String expectTemplateName, Map<String, String> contextVars, boolean full, boolean debug) throws IOException, InterruptedException {
        VelocityContext context = new VelocityContext();
        for (Map.Entry<String, String> ent : contextVars.entrySet()) {
            context.put(ent.getKey(), (Object)ent.getValue());
        }
        Template template = Velocity.getTemplate((String)expectTemplateName);
        String inputPath = EXPECT_DIR + File.separator + expectTemplateName;
        String outputPath = inputPath.substring(0, inputPath.length() - 3);
        FileWriter output = new FileWriter(outputPath);
        template.merge((Context)context, (Writer)output);
        ((Writer)output).close();
        if (full) {
            JanusGraphAssemblyBaseIT.expect(ZIPFILE_FULL_EXTRACTED, outputPath, debug);
        } else {
            JanusGraphAssemblyBaseIT.expect(ZIPFILE_EXTRACTED, outputPath, debug);
        }
    }

    protected void unzipAndRunExpect(String expectTemplateName, boolean full) throws Exception {
        this.unzipAndRunExpect(expectTemplateName, Collections.emptyMap(), full, false);
    }

    protected void unzipAndRunExpect(String expectTemplateName, String graphConfig, String graphToString, boolean full, boolean debug) throws Exception {
        this.unzipAndRunExpect(expectTemplateName, graphConfig, "", graphToString, full, debug);
    }

    protected void unzipAndRunExpect(String expectTemplateName, String graphConfig, String sparkGraphConfig, String graphToString, boolean full, boolean debug) throws Exception {
        this.unzipAndRunExpect(expectTemplateName, (Map<String, String>)ImmutableMap.of((Object)"graphConfig", (Object)graphConfig, (Object)"sparkGraphConfig", (Object)sparkGraphConfig, (Object)"graphToString", (Object)graphToString), full, debug);
    }

    private static void expect(String dir, String expectScript, boolean debug) throws IOException, InterruptedException {
        if (debug) {
            JanusGraphAssemblyBaseIT.command(new File(dir), "expect", "-d", expectScript);
        } else {
            JanusGraphAssemblyBaseIT.command(new File(dir), "expect", expectScript);
        }
    }

    protected static void unzip(String dir, String zipFile) throws IOException, InterruptedException {
        JanusGraphAssemblyBaseIT.command(new File(dir), "unzip", "-q", zipFile);
    }

    protected static void command(File dir, String ... command) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder(command);
        Map<String, String> env = pb.environment();
        env.put("JAVA_OPTIONS", "-Xms1024m -Xmx1024m");
        pb.directory(dir);
        Process p = pb.start();
        p.getOutputStream().close();
        Thread outPrinter = new Thread(new SubprocessPipePrinter(p.getInputStream(), System.out));
        Thread errPrinter = new Thread(new SubprocessPipePrinter(p.getErrorStream(), System.out));
        outPrinter.start();
        errPrinter.start();
        int stat = p.waitFor();
        outPrinter.join();
        errPrinter.join();
        Assertions.assertEquals((int)0, (int)stat);
    }

    static {
        Properties props;
        try {
            props = new Properties();
            FileReader fr = new FileReader(Joiner.on((String)File.separator).join((Object[])new String[]{"target", "test-classes", "target.properties"}));
            props.load(fr);
            fr.close();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        BUILD_DIR = props.getProperty("build.dir");
        EXPECT_DIR = props.getProperty("expect.dir");
        ZIPFILE_PATH = props.getProperty("zipfile.path");
        ZIPFILE_EXTRACTED = ZIPFILE_PATH.substring(0, ZIPFILE_PATH.length() - 4);
        ZIPFILE_FULL_PATH = props.getProperty("zipfile-full.path");
        ZIPFILE_FULL_EXTRACTED = ZIPFILE_FULL_PATH.substring(0, ZIPFILE_FULL_PATH.length() - 4);
        Properties p = new Properties();
        p.put("file.resource.loader.path", EXPECT_DIR);
        Velocity.init((Properties)p);
    }

    private static class SubprocessPipePrinter
    implements Runnable {
        private final BufferedReader source;
        private final PrintStream sink;

        private SubprocessPipePrinter(InputStream source, PrintStream sink) {
            this.source = new BufferedReader(new InputStreamReader(source));
            this.sink = sink;
        }

        @Override
        public void run() {
            try {
                this.runUnsafe();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runUnsafe() throws IOException {
            String line;
            while (null != (line = this.source.readLine())) {
                PrintStream printStream = this.sink;
                synchronized (printStream) {
                    this.sink.println(line);
                }
            }
        }
    }
}

