/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationListener;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeerImpl;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationQueueInfo;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ReplicationTracker;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationGlobalSourceSource;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceFactory;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceFactory;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceInterface;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSyncUp;
import org.apache.hadoop.hbase.replication.regionserver.WALEntryBatch;
import org.apache.hadoop.hbase.replication.regionserver.WALFileLengthProvider;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ReplicationSourceManager
implements ReplicationListener {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationSourceManager.class);
    private final ConcurrentMap<String, ReplicationSourceInterface> sources;
    private final List<ReplicationSourceInterface> oldsources;
    private final ReplicationQueueStorage queueStorage;
    private final ReplicationTracker replicationTracker;
    private final ReplicationPeers replicationPeers;
    private final UUID clusterId;
    private final Server server;
    private final ConcurrentMap<String, Map<String, NavigableSet<String>>> walsById;
    private final ConcurrentMap<String, Map<String, NavigableSet<String>>> walsByIdRecoveredQueues;
    private final Configuration conf;
    private final FileSystem fs;
    private final Set<Path> latestPaths;
    private final Path logDir;
    private final Path oldLogDir;
    private final WALFileLengthProvider walFileLengthProvider;
    private final long sleepBeforeFailover;
    private final ThreadPoolExecutor executor;
    private final boolean replicationForBulkLoadDataEnabled;
    private AtomicLong totalBufferUsed = new AtomicLong();
    private final long totalBufferLimit;
    private final MetricsReplicationGlobalSourceSource globalMetrics;

    public ReplicationSourceManager(ReplicationQueueStorage queueStorage, ReplicationPeers replicationPeers, ReplicationTracker replicationTracker, Configuration conf, Server server, FileSystem fs, Path logDir, Path oldLogDir, UUID clusterId, WALFileLengthProvider walFileLengthProvider, MetricsReplicationGlobalSourceSource globalMetrics) throws IOException {
        this.sources = new ConcurrentHashMap<String, ReplicationSourceInterface>();
        this.queueStorage = queueStorage;
        this.replicationPeers = replicationPeers;
        this.replicationTracker = replicationTracker;
        this.server = server;
        this.walsById = new ConcurrentHashMap<String, Map<String, NavigableSet<String>>>();
        this.walsByIdRecoveredQueues = new ConcurrentHashMap<String, Map<String, NavigableSet<String>>>();
        this.oldsources = new ArrayList<ReplicationSourceInterface>();
        this.conf = conf;
        this.fs = fs;
        this.logDir = logDir;
        this.oldLogDir = oldLogDir;
        this.sleepBeforeFailover = conf.getLong("replication.sleep.before.failover", 30000L);
        this.clusterId = clusterId;
        this.walFileLengthProvider = walFileLengthProvider;
        this.replicationTracker.registerListener(this);
        int nbWorkers = conf.getInt("replication.executor.workers", 1);
        this.executor = new ThreadPoolExecutor(nbWorkers, nbWorkers, 100L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder();
        tfb.setNameFormat("ReplicationExecutor-%d");
        tfb.setDaemon(true);
        this.executor.setThreadFactory(tfb.build());
        this.latestPaths = new HashSet<Path>();
        this.replicationForBulkLoadDataEnabled = conf.getBoolean("hbase.replication.bulkload.enabled", false);
        this.totalBufferLimit = conf.getLong("replication.total.buffer.quota", 0x10000000L);
        this.globalMetrics = globalMetrics;
    }

    Future<?> init() throws IOException {
        for (String id : this.replicationPeers.getAllPeerIds()) {
            this.addSource(id);
            if (!this.replicationForBulkLoadDataEnabled) continue;
            this.throwIOExceptionWhenFail(() -> this.queueStorage.addPeerToHFileRefs(id));
        }
        return this.executor.submit(this::adoptAbandonedQueues);
    }

    private void adoptAbandonedQueues() {
        List<ServerName> currentReplicators = null;
        try {
            currentReplicators = this.queueStorage.getListOfReplicators();
        }
        catch (ReplicationException e) {
            this.server.abort("Failed to get all replicators", e);
            return;
        }
        if (currentReplicators == null || currentReplicators.isEmpty()) {
            return;
        }
        List<ServerName> otherRegionServers = this.replicationTracker.getListOfRegionServers();
        LOG.info("Current list of replicators: " + currentReplicators + " other RSs: " + otherRegionServers);
        for (ServerName rs : currentReplicators) {
            if (otherRegionServers.contains(rs)) continue;
            this.transferQueues(rs);
        }
    }

    public void addPeer(String peerId) throws IOException {
        boolean added = false;
        try {
            added = this.replicationPeers.addPeer(peerId);
        }
        catch (ReplicationException e) {
            throw new IOException(e);
        }
        if (added) {
            this.addSource(peerId);
            if (this.replicationForBulkLoadDataEnabled) {
                this.throwIOExceptionWhenFail(() -> this.queueStorage.addPeerToHFileRefs(peerId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePeer(String peerId) {
        this.replicationPeers.removePeer(peerId);
        String terminateMessage = "Replication stream was removed by a user";
        ArrayList<ReplicationSourceInterface> oldSourcesToDelete = new ArrayList<ReplicationSourceInterface>();
        List<ReplicationSourceInterface> list = this.oldsources;
        synchronized (list) {
            for (ReplicationSourceInterface src : this.oldsources) {
                if (!peerId.equals(src.getPeerId())) continue;
                oldSourcesToDelete.add(src);
            }
            for (ReplicationSourceInterface src : oldSourcesToDelete) {
                src.terminate(terminateMessage);
                this.removeRecoveredSource(src);
            }
        }
        LOG.info("Number of deleted recovered sources for " + peerId + ": " + oldSourcesToDelete.size());
        ReplicationSourceInterface srcToRemove = (ReplicationSourceInterface)this.sources.get(peerId);
        if (srcToRemove != null) {
            srcToRemove.terminate(terminateMessage);
            this.removeSource(srcToRemove);
        } else {
            this.deleteQueue(peerId);
            this.walsById.remove(peerId);
        }
        this.abortWhenFail(() -> this.queueStorage.removePeerFromHFileRefs(peerId));
    }

    private ReplicationSourceInterface createSource(String queueId, ReplicationPeer replicationPeer) throws IOException {
        ReplicationSourceInterface src = ReplicationSourceFactory.create(this.conf, queueId);
        MetricsSource metrics = new MetricsSource(queueId);
        src.init(this.conf, this.fs, this, this.queueStorage, replicationPeer, this.server, queueId, this.clusterId, this.walFileLengthProvider, metrics);
        return src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    ReplicationSourceInterface addSource(String peerId) throws IOException {
        ReplicationPeerImpl peer = this.replicationPeers.getPeer(peerId);
        ReplicationSourceInterface src = this.createSource(peerId, peer);
        Set<Path> set = this.latestPaths;
        synchronized (set) {
            this.sources.put(peerId, src);
            HashMap walsByGroup = new HashMap();
            this.walsById.put(peerId, walsByGroup);
            if (this.latestPaths.size() > 0) {
                for (Path logPath : this.latestPaths) {
                    String name = logPath.getName();
                    String walPrefix = AbstractFSWALProvider.getWALPrefixFromWALName(name);
                    TreeSet<String> logs = new TreeSet<String>();
                    logs.add(name);
                    walsByGroup.put(walPrefix, logs);
                    this.abortAndThrowIOExceptionWhenFail(() -> this.queueStorage.addWAL(this.server.getServerName(), peerId, name));
                    src.enqueueLog(logPath);
                }
            }
        }
        src.startup();
        return src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshSources(String peerId) throws IOException {
        String terminateMessage = "Peer " + peerId + " state or config changed. Will close the previous replication source and open a new one";
        ReplicationPeerImpl peer = this.replicationPeers.getPeer(peerId);
        ReplicationSourceInterface src = this.createSource(peerId, peer);
        Set<Path> set = this.latestPaths;
        synchronized (set) {
            ReplicationSourceInterface toRemove = this.sources.put(peerId, src);
            if (toRemove != null) {
                LOG.info("Terminate replication source for " + toRemove.getPeerId());
                toRemove.terminate(terminateMessage, null, false);
            }
            for (SortedSet walsByGroup : ((Map)this.walsById.get(peerId)).values()) {
                walsByGroup.forEach(wal -> src.enqueueLog(new Path(this.logDir, wal)));
            }
        }
        LOG.info("Startup replication source for " + src.getPeerId());
        src.startup();
        ArrayList<ReplicationSourceInterface> toStartup = new ArrayList<ReplicationSourceInterface>();
        List<ReplicationSourceInterface> list = this.oldsources;
        synchronized (list) {
            ArrayList<String> previousQueueIds = new ArrayList<String>();
            Iterator<ReplicationSourceInterface> iter = this.oldsources.iterator();
            while (iter.hasNext()) {
                ReplicationSourceInterface oldSource = iter.next();
                if (!oldSource.getPeerId().equals(peerId)) continue;
                previousQueueIds.add(oldSource.getQueueId());
                oldSource.terminate(terminateMessage);
                iter.remove();
            }
            for (String queueId : previousQueueIds) {
                ReplicationSourceInterface recoveredReplicationSource = this.createSource(queueId, peer);
                this.oldsources.add(recoveredReplicationSource);
                for (SortedSet walsByGroup : ((Map)this.walsByIdRecoveredQueues.get(queueId)).values()) {
                    walsByGroup.forEach(wal -> recoveredReplicationSource.enqueueLog(new Path(wal)));
                }
                toStartup.add(recoveredReplicationSource);
            }
        }
        for (ReplicationSourceInterface replicationSource : toStartup) {
            replicationSource.startup();
        }
    }

    void removeRecoveredSource(ReplicationSourceInterface src) {
        LOG.info("Done with the recovered queue " + src.getQueueId());
        this.oldsources.remove(src);
        this.deleteQueue(src.getQueueId());
        this.walsByIdRecoveredQueues.remove(src.getQueueId());
    }

    void removeSource(ReplicationSourceInterface src) {
        LOG.info("Done with the queue " + src.getQueueId());
        this.sources.remove(src.getPeerId());
        this.deleteQueue(src.getQueueId());
        this.walsById.remove(src.getQueueId());
    }

    private void deleteQueue(String queueId) {
        this.abortWhenFail(() -> this.queueStorage.removeQueue(this.server.getServerName(), queueId));
    }

    private void interruptOrAbortWhenFail(ReplicationQueueOperation op) {
        try {
            op.exec();
        }
        catch (ReplicationException e) {
            if (e.getCause() != null && e.getCause() instanceof KeeperException.SystemErrorException && e.getCause().getCause() != null && e.getCause().getCause() instanceof InterruptedException) {
                throw new RuntimeException("Thread is interrupted, the replication source may be terminated");
            }
            this.server.abort("Failed to operate on replication queue", e);
        }
    }

    private void abortWhenFail(ReplicationQueueOperation op) {
        try {
            op.exec();
        }
        catch (ReplicationException e) {
            this.server.abort("Failed to operate on replication queue", e);
        }
    }

    private void throwIOExceptionWhenFail(ReplicationQueueOperation op) throws IOException {
        try {
            op.exec();
        }
        catch (ReplicationException e) {
            throw new IOException(e);
        }
    }

    private void abortAndThrowIOExceptionWhenFail(ReplicationQueueOperation op) throws IOException {
        try {
            op.exec();
        }
        catch (ReplicationException e) {
            this.server.abort("Failed to operate on replication queue", e);
            throw new IOException(e);
        }
    }

    public void logPositionAndCleanOldLogs(String queueId, boolean queueRecovered, WALEntryBatch entryBatch) {
        String fileName = entryBatch.getLastWalPath().getName();
        this.interruptOrAbortWhenFail(() -> this.queueStorage.setWALPosition(this.server.getServerName(), queueId, fileName, entryBatch.getLastWalPosition(), entryBatch.getLastSeqIds()));
        this.cleanOldLogs(fileName, entryBatch.isEndOfFile(), queueId, queueRecovered);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void cleanOldLogs(String log, boolean inclusive, String queueId, boolean queueRecovered) {
        String logPrefix = AbstractFSWALProvider.getWALPrefixFromWALName(log);
        if (queueRecovered) {
            NavigableSet wals = (NavigableSet)((Map)this.walsByIdRecoveredQueues.get(queueId)).get(logPrefix);
            if (wals != null) {
                this.cleanOldLogs(wals, log, inclusive, queueId);
            }
        } else {
            ConcurrentMap<String, Map<String, NavigableSet<String>>> concurrentMap = this.walsById;
            synchronized (concurrentMap) {
                NavigableSet wals = (NavigableSet)((Map)this.walsById.get(queueId)).get(logPrefix);
                if (wals != null) {
                    this.cleanOldLogs(wals, log, inclusive, queueId);
                }
            }
        }
    }

    private void cleanOldLogs(NavigableSet<String> wals, String key, boolean inclusive, String id) {
        NavigableSet<String> walSet = wals.headSet(key, inclusive);
        if (walSet.isEmpty()) {
            return;
        }
        LOG.debug("Removing {} logs in the list: {}", (Object)walSet.size(), walSet);
        for (String wal : walSet) {
            this.interruptOrAbortWhenFail(() -> this.queueStorage.removeWAL(this.server.getServerName(), id, wal));
        }
        walSet.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void preLogRoll(Path newLog) throws IOException {
        String logName = newLog.getName();
        String logPrefix = AbstractFSWALProvider.getWALPrefixFromWALName(logName);
        Set<Path> set = this.latestPaths;
        synchronized (set) {
            for (Object source : this.sources.values()) {
                this.abortAndThrowIOExceptionWhenFail(() -> this.lambda$preLogRoll$9((ReplicationSourceInterface)source, logName));
            }
            ConcurrentMap<String, Map<String, NavigableSet<String>>> concurrentMap = this.walsById;
            synchronized (concurrentMap) {
                for (Map.Entry entry : this.walsById.entrySet()) {
                    String peerId = (String)entry.getKey();
                    Map walsByPrefix = (Map)entry.getValue();
                    boolean existingPrefix = false;
                    for (Map.Entry walsEntry : walsByPrefix.entrySet()) {
                        SortedSet wals = (SortedSet)walsEntry.getValue();
                        if (this.sources.isEmpty()) {
                            wals.clear();
                        }
                        if (!logPrefix.equals(walsEntry.getKey())) continue;
                        wals.add(logName);
                        existingPrefix = true;
                    }
                    if (existingPrefix) continue;
                    LOG.debug("Start tracking logs for wal group {} for peer {}", (Object)logPrefix, (Object)peerId);
                    TreeSet<String> wals = new TreeSet<String>();
                    wals.add(logName);
                    walsByPrefix.put(logPrefix, wals);
                }
            }
            Iterator<Path> iterator = this.latestPaths.iterator();
            while (iterator.hasNext()) {
                Path path = iterator.next();
                if (!path.getName().contains(logPrefix)) continue;
                iterator.remove();
                break;
            }
            this.latestPaths.add(newLog);
        }
    }

    @VisibleForTesting
    public void postLogRoll(Path newLog) throws IOException {
        for (ReplicationSourceInterface source : this.sources.values()) {
            source.enqueueLog(newLog);
        }
    }

    @Override
    public void regionServerRemoved(String regionserver) {
        this.transferQueues(ServerName.valueOf(regionserver));
    }

    private void transferQueues(ServerName deadRS) {
        if (this.server.getServerName().equals(deadRS)) {
            return;
        }
        NodeFailoverWorker transfer = new NodeFailoverWorker(deadRS);
        try {
            this.executor.execute(transfer);
        }
        catch (RejectedExecutionException ex) {
            CompatibilitySingletonFactory.getInstance(MetricsReplicationSourceFactory.class).getGlobalSource().incrFailedRecoveryQueue();
            LOG.info("Cancelling the transfer of " + deadRS + " because of " + ex.getMessage());
        }
    }

    public void join() {
        this.executor.shutdown();
        for (ReplicationSourceInterface source : this.sources.values()) {
            source.terminate("Region server is closing");
        }
        for (ReplicationSourceInterface source : this.oldsources) {
            source.terminate("Region server is closing");
        }
    }

    @VisibleForTesting
    public Map<String, Map<String, NavigableSet<String>>> getWALs() {
        return Collections.unmodifiableMap(this.walsById);
    }

    @VisibleForTesting
    Map<String, Map<String, NavigableSet<String>>> getWalsByIdRecoveredQueues() {
        return Collections.unmodifiableMap(this.walsByIdRecoveredQueues);
    }

    public List<ReplicationSourceInterface> getSources() {
        return new ArrayList<ReplicationSourceInterface>(this.sources.values());
    }

    public List<ReplicationSourceInterface> getOldSources() {
        return this.oldsources;
    }

    @VisibleForTesting
    public ReplicationSourceInterface getSource(String peerId) {
        return (ReplicationSourceInterface)this.sources.get(peerId);
    }

    @VisibleForTesting
    List<String> getAllQueues() throws IOException {
        List<String> allQueues = Collections.emptyList();
        try {
            allQueues = this.queueStorage.getAllQueues(this.server.getServerName());
        }
        catch (ReplicationException e) {
            throw new IOException(e);
        }
        return allQueues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getSizeOfLatestPath() {
        Set<Path> set = this.latestPaths;
        synchronized (set) {
            return this.latestPaths.size();
        }
    }

    @VisibleForTesting
    public AtomicLong getTotalBufferUsed() {
        return this.totalBufferUsed;
    }

    public long getTotalBufferLimit() {
        return this.totalBufferLimit;
    }

    public Path getOldLogDir() {
        return this.oldLogDir;
    }

    public Path getLogDir() {
        return this.logDir;
    }

    public FileSystem getFs() {
        return this.fs;
    }

    public ReplicationPeers getReplicationPeers() {
        return this.replicationPeers;
    }

    public String getStats() {
        StringBuilder stats = new StringBuilder();
        stats.append("Global stats: ");
        stats.append("WAL Edits Buffer Used=").append(this.getTotalBufferUsed().get()).append("B, Limit=").append(this.getTotalBufferLimit()).append("B\n");
        for (ReplicationSourceInterface source : this.sources.values()) {
            stats.append("Normal source for cluster " + source.getPeerId() + ": ");
            stats.append(source.getStats() + "\n");
        }
        for (ReplicationSourceInterface oldSource : this.oldsources) {
            stats.append("Recovered source for cluster/machine(s) " + oldSource.getPeerId() + ": ");
            stats.append(oldSource.getStats() + "\n");
        }
        return stats.toString();
    }

    public void addHFileRefs(TableName tableName, byte[] family, List<Pair<Path, Path>> pairs) throws IOException {
        for (ReplicationSourceInterface source : this.sources.values()) {
            this.throwIOExceptionWhenFail(() -> source.addHFileRefs(tableName, family, pairs));
        }
    }

    public void cleanUpHFileRefs(String peerId, List<String> files) {
        this.interruptOrAbortWhenFail(() -> this.queueStorage.removeHFileRefs(peerId, files));
    }

    int activeFailoverTaskCount() {
        return this.executor.getActiveCount();
    }

    MetricsReplicationGlobalSourceSource getGlobalMetrics() {
        return this.globalMetrics;
    }

    private /* synthetic */ void lambda$preLogRoll$9(ReplicationSourceInterface source, String logName) throws ReplicationException {
        this.queueStorage.addWAL(this.server.getServerName(), source.getQueueId(), logName);
    }

    class NodeFailoverWorker
    extends Thread {
        private final ServerName deadRS;
        private final Map<String, ReplicationPeerImpl> peersSnapshot;

        @VisibleForTesting
        public NodeFailoverWorker(ServerName deadRS) {
            super("Failover-for-" + deadRS);
            this.deadRS = deadRS;
            this.peersSnapshot = new HashMap<String, ReplicationPeerImpl>(ReplicationSourceManager.this.replicationPeers.getPeerCache());
        }

        private boolean isOldPeer(String peerId, ReplicationPeerImpl newPeerRef) {
            ReplicationPeerImpl oldPeerRef = this.peersSnapshot.get(peerId);
            return oldPeerRef != null && oldPeerRef == newPeerRef;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Thread.sleep(ReplicationSourceManager.this.sleepBeforeFailover + (long)(ThreadLocalRandom.current().nextFloat() * (float)ReplicationSourceManager.this.sleepBeforeFailover));
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while waiting before transferring a queue.");
                Thread.currentThread().interrupt();
            }
            if (ReplicationSourceManager.this.server.isStopped()) {
                LOG.info("Not transferring queue since we are shutting down");
                return;
            }
            HashMap<String, SortedSet<String>> newQueues = new HashMap<String, SortedSet<String>>();
            try {
                List<String> queues = ReplicationSourceManager.this.queueStorage.getAllQueues(this.deadRS);
                while (!queues.isEmpty()) {
                    Pair<String, SortedSet<String>> peer = ReplicationSourceManager.this.queueStorage.claimQueue(this.deadRS, queues.get(ThreadLocalRandom.current().nextInt(queues.size())), ReplicationSourceManager.this.server.getServerName());
                    long sleep = ReplicationSourceManager.this.sleepBeforeFailover / 2L;
                    if (!peer.getSecond().isEmpty()) {
                        newQueues.put(peer.getFirst(), peer.getSecond());
                        sleep = ReplicationSourceManager.this.sleepBeforeFailover;
                    }
                    try {
                        Thread.sleep(sleep);
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Interrupted while waiting before transferring a queue.");
                        Thread.currentThread().interrupt();
                    }
                    queues = ReplicationSourceManager.this.queueStorage.getAllQueues(this.deadRS);
                }
                if (queues.isEmpty()) {
                    ReplicationSourceManager.this.queueStorage.removeReplicatorIfQueueIsEmpty(this.deadRS);
                }
            }
            catch (ReplicationException e) {
                LOG.error(String.format("ReplicationException: cannot claim dead region (%s)'s replication queue. Znode : (%s) Possible solution: check if znode size exceeds jute.maxBuffer value.  If so, increase it for both client and server side." + e, new Object[0]), (Object)this.deadRS, (Object)ReplicationSourceManager.this.queueStorage.getRsNode(this.deadRS));
                ReplicationSourceManager.this.server.abort("Failed to claim queue from dead regionserver.", e);
                return;
            }
            if (newQueues.isEmpty()) {
                return;
            }
            for (Map.Entry entry : newQueues.entrySet()) {
                String queueId = (String)entry.getKey();
                Set walsSet = (Set)entry.getValue();
                try {
                    ReplicationQueueInfo replicationQueueInfo = new ReplicationQueueInfo(queueId);
                    String actualPeerId = replicationQueueInfo.getPeerId();
                    ReplicationPeerImpl peer = ReplicationSourceManager.this.replicationPeers.getPeer(actualPeerId);
                    if (peer == null || !this.isOldPeer(actualPeerId, peer)) {
                        LOG.warn("Skipping failover for peer {} of node {}, peer is null", (Object)actualPeerId, (Object)this.deadRS);
                        ReplicationSourceManager.this.abortWhenFail(() -> ReplicationSourceManager.this.queueStorage.removeQueue(ReplicationSourceManager.this.server.getServerName(), queueId));
                        continue;
                    }
                    if (ReplicationSourceManager.this.server instanceof ReplicationSyncUp.DummyServer && peer.getPeerState().equals((Object)ReplicationPeer.PeerState.DISABLED)) {
                        LOG.warn("Peer {} is disabled. ReplicationSyncUp tool will skip replicating data to this peer.", (Object)actualPeerId);
                        continue;
                    }
                    HashMap<String, TreeSet<String>> walsByGroup = new HashMap<String, TreeSet<String>>();
                    ReplicationSourceManager.this.walsByIdRecoveredQueues.put(queueId, walsByGroup);
                    for (String wal : walsSet) {
                        String walPrefix = AbstractFSWALProvider.getWALPrefixFromWALName(wal);
                        TreeSet<String> wals = (TreeSet<String>)walsByGroup.get(walPrefix);
                        if (wals == null) {
                            wals = new TreeSet<String>();
                            walsByGroup.put(walPrefix, wals);
                        }
                        wals.add(wal);
                    }
                    ReplicationSourceInterface src = ReplicationSourceManager.this.createSource(queueId, peer);
                    List list = ReplicationSourceManager.this.oldsources;
                    synchronized (list) {
                        peer = ReplicationSourceManager.this.replicationPeers.getPeer(src.getPeerId());
                        if (peer == null || !this.isOldPeer(src.getPeerId(), peer)) {
                            src.terminate("Recovered queue doesn't belong to any current peer");
                            ReplicationSourceManager.this.removeRecoveredSource(src);
                            continue;
                        }
                        ReplicationSourceManager.this.oldsources.add(src);
                        for (String wal : walsSet) {
                            src.enqueueLog(new Path(ReplicationSourceManager.this.oldLogDir, wal));
                        }
                        src.startup();
                    }
                }
                catch (IOException e) {
                    LOG.error("Failed creating a source", (Throwable)e);
                }
            }
        }
    }

    @FunctionalInterface
    private static interface ReplicationQueueOperation {
        public void exec() throws ReplicationException;
    }
}

