/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hadoop.hbase.exceptions.IllegalArgumentIOException;
import org.apache.hadoop.hbase.regionserver.AbstractMemStore;
import org.apache.hadoop.hbase.regionserver.CompactionPipeline;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreCompactionStrategy;
import org.apache.hadoop.hbase.regionserver.MemStoreCompactor;
import org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.MutableSegment;
import org.apache.hadoop.hbase.regionserver.NonThreadSafeMemStoreSizing;
import org.apache.hadoop.hbase.regionserver.RegionServicesForStores;
import org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hadoop.hbase.regionserver.SegmentFactory;
import org.apache.hadoop.hbase.regionserver.VersionedSegmentsList;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CompactingMemStore
extends AbstractMemStore {
    public static final String COMPACTING_MEMSTORE_TYPE_KEY = "hbase.hregion.compacting.memstore.type";
    public static final String COMPACTING_MEMSTORE_TYPE_DEFAULT = String.valueOf((Object)MemoryCompactionPolicy.NONE);
    public static final String IN_MEMORY_FLUSH_THRESHOLD_FACTOR_KEY = "hbase.memstore.inmemoryflush.threshold.factor";
    private static final int IN_MEMORY_FLUSH_MULTIPLIER = 1;
    public static final String IN_MEMORY_CONPACTION_POOL_SIZE_KEY = "hbase.regionserver.inmemory.compaction.pool.size";
    public static final int IN_MEMORY_CONPACTION_POOL_SIZE_DEFAULT = 10;
    private static final Logger LOG = LoggerFactory.getLogger(CompactingMemStore.class);
    private HStore store;
    private CompactionPipeline pipeline;
    protected MemStoreCompactor compactor;
    private long inmemoryFlushSize;
    private final AtomicBoolean inMemoryCompactionInProgress = new AtomicBoolean(false);
    private boolean inWalReplay = false;
    @VisibleForTesting
    protected final AtomicBoolean allowCompaction = new AtomicBoolean(true);
    private boolean compositeSnapshot = true;
    private IndexType indexType = IndexType.ARRAY_MAP;
    public static final long DEEP_OVERHEAD = ClassSize.align(AbstractMemStore.DEEP_OVERHEAD + (long)(6 * ClassSize.REFERENCE) + 8L + 2L + (long)(2 * ClassSize.ATOMIC_BOOLEAN) + CompactionPipeline.DEEP_OVERHEAD + MemStoreCompactor.DEEP_OVERHEAD);

    public CompactingMemStore(Configuration conf, CellComparator c, HStore store, RegionServicesForStores regionServices, MemoryCompactionPolicy compactionPolicy) throws IOException {
        super(conf, c, regionServices);
        this.store = store;
        this.regionServices = regionServices;
        this.pipeline = new CompactionPipeline(this.getRegionServices());
        this.compactor = this.createMemStoreCompactor(compactionPolicy);
        this.indexType = conf.getBoolean("hbase.hregion.memstore.mslab.enabled", true) ? IndexType.CHUNK_MAP : IndexType.ARRAY_MAP;
        this.initInmemoryFlushSize(conf);
        LOG.info("Store={}, in-memory flush size threshold={}, immutable segments index type={}, compactor={}", new Object[]{this.store.getColumnFamilyName(), StringUtils.byteDesc((long)this.inmemoryFlushSize), this.indexType, this.compactor == null ? "NULL" : this.compactor.toString()});
    }

    @VisibleForTesting
    protected MemStoreCompactor createMemStoreCompactor(MemoryCompactionPolicy compactionPolicy) throws IllegalArgumentIOException {
        return new MemStoreCompactor(this, compactionPolicy);
    }

    private void initInmemoryFlushSize(Configuration conf) {
        double factor = 0.0;
        long memstoreFlushSize = this.getRegionServices().getMemStoreFlushSize();
        int numStores = this.getRegionServices().getNumStores();
        if (numStores <= 1) {
            numStores = 1;
        }
        if ((factor = conf.getDouble(IN_MEMORY_FLUSH_THRESHOLD_FACTOR_KEY, 0.0)) != 0.0) {
            this.inmemoryFlushSize = (long)(factor * (double)memstoreFlushSize) / (long)numStores;
        } else {
            this.inmemoryFlushSize = 1L * conf.getLong("hbase.hregion.memstore.mslab.chunksize", 0x200000L);
            this.inmemoryFlushSize -= 4L;
        }
    }

    @Override
    public MemStoreSize size() {
        NonThreadSafeMemStoreSizing memstoreSizing = new NonThreadSafeMemStoreSizing();
        memstoreSizing.incMemStoreSize(this.getActive().getMemStoreSize());
        for (Segment segment : this.pipeline.getSegments()) {
            memstoreSizing.incMemStoreSize(segment.getMemStoreSize());
        }
        return memstoreSizing.getMemStoreSize();
    }

    @Override
    public long preFlushSeqIDEstimation() {
        if (this.compositeSnapshot) {
            return -1L;
        }
        Segment segment = this.getLastSegment();
        if (segment == null) {
            return -1L;
        }
        return segment.getMinSequenceId();
    }

    @Override
    public boolean isSloppy() {
        return true;
    }

    @Override
    public MemStoreSnapshot snapshot() {
        if (!this.snapshot.isEmpty()) {
            LOG.warn("Snapshot called again without clearing previous. Doing nothing. Another ongoing flush or did we fail last attempt?");
        } else {
            LOG.debug("FLUSHING TO DISK {}, store={}", (Object)this.getRegionServices().getRegionInfo().getEncodedName(), (Object)this.getFamilyName());
            this.stopCompaction();
            this.pushActiveToPipeline(this.getActive());
            this.resetTimeOfOldestEdit();
            this.snapshotId = EnvironmentEdgeManager.currentTime();
            if (this.compositeSnapshot) {
                this.pushPipelineToSnapshot();
            } else {
                this.pushTailToSnapshot();
            }
            this.compactor.resetStats();
        }
        return new MemStoreSnapshot(this.snapshotId, this.snapshot);
    }

    @Override
    public MemStoreSize getFlushableSize() {
        MemStoreSize mss = this.getSnapshotSize();
        if (mss.getDataSize() == 0L) {
            if (this.compositeSnapshot) {
                NonThreadSafeMemStoreSizing memStoreSizing = new NonThreadSafeMemStoreSizing(this.pipeline.getPipelineSize());
                MutableSegment currActive = this.getActive();
                if (!currActive.isEmpty()) {
                    memStoreSizing.incMemStoreSize(currActive.getMemStoreSize());
                }
                mss = memStoreSizing.getMemStoreSize();
            } else {
                mss = this.pipeline.getTailSize();
            }
        }
        return mss.getDataSize() > 0L ? mss : this.getActive().getMemStoreSize();
    }

    public void setInMemoryCompactionCompleted() {
        this.inMemoryCompactionInProgress.set(false);
    }

    protected boolean setInMemoryCompactionFlag() {
        return this.inMemoryCompactionInProgress.compareAndSet(false, true);
    }

    @Override
    protected long keySize() {
        long keySize = this.getActive().getDataSize();
        for (Segment segment : this.pipeline.getSegments()) {
            keySize += segment.getDataSize();
        }
        return keySize;
    }

    @Override
    protected long heapSize() {
        long h = this.getActive().getHeapSize();
        for (Segment segment : this.pipeline.getSegments()) {
            h += segment.getHeapSize();
        }
        return h;
    }

    @Override
    public void updateLowestUnflushedSequenceIdInWAL(boolean onlyIfGreater) {
        long minSequenceId = this.pipeline.getMinSequenceId();
        if (minSequenceId != Long.MAX_VALUE) {
            byte[] encodedRegionName = this.getRegionServices().getRegionInfo().getEncodedNameAsBytes();
            byte[] familyName = this.getFamilyNameInBytes();
            WAL WAL2 = this.getRegionServices().getWAL();
            if (WAL2 != null) {
                WAL2.updateStore(encodedRegionName, familyName, minSequenceId, onlyIfGreater);
            }
        }
    }

    @Override
    public void startReplayingFromWAL() {
        this.inWalReplay = true;
    }

    @Override
    public void stopReplayingFromWAL() {
        this.inWalReplay = false;
    }

    @Override
    protected boolean preUpdate(MutableSegment currentActive, Cell cell, MemStoreSizing memstoreSizing) {
        if (currentActive.sharedLock()) {
            if (this.checkAndAddToActiveSize(currentActive, cell, memstoreSizing)) {
                return true;
            }
            currentActive.sharedUnlock();
        }
        return false;
    }

    @Override
    protected void postUpdate(MutableSegment currentActive) {
        currentActive.sharedUnlock();
    }

    @Override
    protected boolean sizeAddedPreOperation() {
        return true;
    }

    @Override
    @VisibleForTesting
    protected List<Segment> getSegments() {
        List<? extends Segment> pipelineList = this.pipeline.getSegments();
        ArrayList<Segment> list = new ArrayList<Segment>(pipelineList.size() + 2);
        list.add(this.getActive());
        list.addAll(pipelineList);
        list.addAll(this.snapshot.getAllSegments());
        return list;
    }

    public void setCompositeSnapshot(boolean useCompositeSnapshot) {
        this.compositeSnapshot = useCompositeSnapshot;
    }

    public boolean swapCompactedSegments(VersionedSegmentsList versionedList, ImmutableSegment result, boolean merge) {
        return this.pipeline.swap(versionedList, result, !merge, true);
    }

    public void flattenOneSegment(long requesterVersion, MemStoreCompactionStrategy.Action action) {
        this.pipeline.flattenOneSegment(requesterVersion, this.indexType, action);
    }

    @VisibleForTesting
    void setIndexType(IndexType type) {
        this.indexType = type;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public boolean hasImmutableSegments() {
        return !this.pipeline.isEmpty();
    }

    public VersionedSegmentsList getImmutableSegments() {
        return this.pipeline.getVersionedList();
    }

    public long getSmallestReadPoint() {
        return this.store.getSmallestReadPoint();
    }

    public HStore getStore() {
        return this.store;
    }

    public String getFamilyName() {
        return Bytes.toString(this.getFamilyNameInBytes());
    }

    @Override
    public List<KeyValueScanner> getScanners(long readPt) throws IOException {
        MutableSegment activeTmp = this.getActive();
        List<? extends Segment> pipelineList = this.pipeline.getSegments();
        List<Segment> snapshotList = this.snapshot.getAllSegments();
        long numberOfSegments = 1L + (long)pipelineList.size() + (long)snapshotList.size();
        List<KeyValueScanner> list = this.createList((int)numberOfSegments);
        CompactingMemStore.addToScanners(activeTmp, readPt, list);
        CompactingMemStore.addToScanners(pipelineList, readPt, list);
        CompactingMemStore.addToScanners(snapshotList, readPt, list);
        return list;
    }

    @VisibleForTesting
    protected List<KeyValueScanner> createList(int capacity) {
        return new ArrayList<KeyValueScanner>(capacity);
    }

    private boolean checkAndAddToActiveSize(MutableSegment currActive, Cell cellToAdd, MemStoreSizing memstoreSizing) {
        if (this.shouldFlushInMemory(currActive, cellToAdd, memstoreSizing)) {
            if (currActive.setInMemoryFlushed()) {
                this.flushInMemory(currActive);
                if (this.setInMemoryCompactionFlag()) {
                    InMemoryCompactionRunnable runnable = new InMemoryCompactionRunnable();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Dispatching the MemStore in-memory flush for store " + this.store.getColumnFamilyName());
                    }
                    this.getPool().execute(runnable);
                }
            }
            return false;
        }
        return true;
    }

    @VisibleForTesting
    void flushInMemory() {
        MutableSegment currActive = this.getActive();
        if (currActive.setInMemoryFlushed()) {
            this.flushInMemory(currActive);
        }
        this.inMemoryCompaction();
    }

    private void flushInMemory(MutableSegment currActive) {
        LOG.trace("IN-MEMORY FLUSH: Pushing active segment into compaction pipeline");
        this.pushActiveToPipeline(currActive);
    }

    void inMemoryCompaction() {
        this.inMemoryCompactionInProgress.set(true);
        if (!this.allowCompaction.get()) {
            return;
        }
        try {
            if (!this.compactor.start()) {
                this.setInMemoryCompactionCompleted();
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to run in-memory compaction on {}/{}; exception={}", new Object[]{this.getRegionServices().getRegionInfo().getEncodedName(), this.getFamilyName(), e});
        }
    }

    private Segment getLastSegment() {
        MutableSegment localActive = this.getActive();
        Segment tail = this.pipeline.getTail();
        return tail == null ? localActive : tail;
    }

    private byte[] getFamilyNameInBytes() {
        return this.store.getColumnFamilyDescriptor().getName();
    }

    private ThreadPoolExecutor getPool() {
        return this.getRegionServices().getInMemoryCompactionPool();
    }

    @VisibleForTesting
    protected boolean shouldFlushInMemory(MutableSegment currActive, Cell cellToAdd, MemStoreSizing memstoreSizing) {
        long cellSize = MutableSegment.getCellLength(cellToAdd);
        long segmentDataSize = currActive.getDataSize();
        while (segmentDataSize + cellSize < this.inmemoryFlushSize || this.inWalReplay) {
            if (currActive.compareAndSetDataSize(segmentDataSize, segmentDataSize + cellSize)) {
                if (memstoreSizing != null) {
                    memstoreSizing.incMemStoreSize(cellSize, 0L, 0L, 0);
                }
                return false;
            }
            segmentDataSize = currActive.getDataSize();
        }
        return true;
    }

    private void stopCompaction() {
        if (this.inMemoryCompactionInProgress.get()) {
            this.compactor.stop();
        }
    }

    protected void pushActiveToPipeline(MutableSegment currActive) {
        if (!currActive.isEmpty()) {
            this.pipeline.pushHead(currActive);
            this.resetActive();
        }
    }

    private void pushTailToSnapshot() {
        VersionedSegmentsList segments = this.pipeline.getVersionedTail();
        this.pushToSnapshot(segments.getStoreSegments());
        this.pipeline.swap(segments, null, false, false);
    }

    private void pushPipelineToSnapshot() {
        int iterationsCnt = 0;
        boolean done = false;
        while (!done) {
            VersionedSegmentsList segments = this.pipeline.getVersionedList();
            this.pushToSnapshot(segments.getStoreSegments());
            done = this.pipeline.swap(segments, null, false, false);
            if (++iterationsCnt <= 2) continue;
            LOG.warn("Multiple unsuccessful attempts to push the compaction pipeline to snapshot, while flushing to disk.");
            this.snapshot = SegmentFactory.instance().createImmutableSegment(this.getComparator());
            break;
        }
    }

    private void pushToSnapshot(List<ImmutableSegment> segments) {
        if (segments.isEmpty()) {
            return;
        }
        if (segments.size() == 1 && !segments.get(0).isEmpty()) {
            this.snapshot = segments.get(0);
            return;
        }
        this.snapshot = SegmentFactory.instance().createCompositeImmutableSegment(this.getComparator(), segments);
    }

    private RegionServicesForStores getRegionServices() {
        return this.regionServices;
    }

    @VisibleForTesting
    boolean isMemStoreFlushingInMemory() {
        return this.inMemoryCompactionInProgress.get();
    }

    Cell getNextRow(Cell cell) {
        Cell lowest = null;
        List<Segment> segments = this.getSegments();
        for (Segment segment : segments) {
            if (lowest == null) {
                lowest = this.getNextRow(cell, segment.getCellSet());
                continue;
            }
            lowest = this.getLowest(lowest, this.getNextRow(cell, segment.getCellSet()));
        }
        return lowest;
    }

    @VisibleForTesting
    long getInmemoryFlushSize() {
        return this.inmemoryFlushSize;
    }

    public void debug() {
        String msg = "active size=" + this.getActive().getDataSize();
        msg = msg + " allow compaction is " + (this.allowCompaction.get() ? "true" : "false");
        msg = msg + " inMemoryCompactionInProgress is " + (this.inMemoryCompactionInProgress.get() ? "true" : "false");
        LOG.debug(msg);
    }

    private class InMemoryCompactionRunnable
    implements Runnable {
        private InMemoryCompactionRunnable() {
        }

        @Override
        public void run() {
            CompactingMemStore.this.inMemoryCompaction();
        }
    }

    public static enum IndexType {
        CSLM_MAP,
        ARRAY_MAP,
        CHUNK_MAP;

    }
}

