/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Mutating;
import org.apache.tinkerpop.gremlin.process.traversal.step.Scoping;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.CallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.Event;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.ListCallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.EventStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class AddVertexStep<S>
extends ScalarMapStep<S, Vertex>
implements Mutating<Event.VertexAddedEvent>,
TraversalParent,
Scoping {
    private Parameters parameters = new Parameters();
    private CallbackRegistry<Event.VertexAddedEvent> callbackRegistry;

    public AddVertexStep(Traversal.Admin traversal, String label) {
        super(traversal);
        this.parameters.set(this, T.label, null == label ? "vertex" : label);
    }

    public AddVertexStep(Traversal.Admin traversal, Traversal.Admin<S, String> vertexLabelTraversal) {
        super(traversal);
        this.parameters.set(this, T.label, null == vertexLabelTraversal ? "vertex" : vertexLabelTraversal);
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public Set<String> getScopeKeys() {
        return this.parameters.getReferencedLabels();
    }

    @Override
    public <S, E> List<Traversal.Admin<S, E>> getLocalChildren() {
        return this.parameters.getTraversals();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void configure(Object ... keyValues) {
        if (keyValues[0] == T.label && this.parameters.contains(T.label)) {
            if (!this.parameters.contains(T.label, "vertex")) throw new IllegalArgumentException(String.format("Vertex T.label has already been set to [%s] and cannot be overridden with [%s]", this.parameters.getRaw(new Object[0]).get(T.label).get(0), keyValues[1]));
            this.parameters.remove(T.label);
            this.parameters.set(this, keyValues);
            return;
        } else {
            if (keyValues[0] == T.id && this.parameters.contains(T.id)) {
                throw new IllegalArgumentException(String.format("Vertex T.id has already been set to [%s] and cannot be overridden with [%s]", this.parameters.getRaw(new Object[0]).get(T.id).get(0), keyValues[1]));
            }
            this.parameters.set(this, keyValues);
        }
    }

    @Override
    protected Vertex map(Traverser.Admin<S> traverser) {
        Vertex vertex = this.getTraversal().getGraph().get().addVertex(this.parameters.getKeyValues(traverser, new Object[0]));
        if (this.callbackRegistry != null && !this.callbackRegistry.getCallbacks().isEmpty()) {
            EventStrategy eventStrategy = this.getTraversal().getStrategies().getStrategy(EventStrategy.class).get();
            Event.VertexAddedEvent vae = new Event.VertexAddedEvent(eventStrategy.detach(vertex));
            this.callbackRegistry.getCallbacks().forEach(c -> c.accept(vae));
        }
        return vertex;
    }

    @Override
    public CallbackRegistry<Event.VertexAddedEvent> getMutatingCallbackRegistry() {
        if (null == this.callbackRegistry) {
            this.callbackRegistry = new ListCallbackRegistry<Event.VertexAddedEvent>();
        }
        return this.callbackRegistry;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.parameters.hashCode();
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(new TraverserRequirement[0]);
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.parameters);
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.parameters.getTraversals().forEach(this::integrateChild);
    }

    @Override
    public AddVertexStep<S> clone() {
        AddVertexStep clone = (AddVertexStep)super.clone();
        clone.parameters = this.parameters.clone();
        return clone;
    }
}

