/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff;

import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.pecoff.PECoffRelocationTable;
import com.oracle.objectfile.pecoff.PECoffX86_64Relocation;

public enum PECoffMachine {
    X86_64{

        @Override
        Class<? extends Enum<? extends ObjectFile.RelocationMethod>> relocationTypes() {
            return PECoffX86_64Relocation.class;
        }
    };


    abstract Class<? extends Enum<? extends ObjectFile.RelocationMethod>> relocationTypes();

    public static PECoffRelocationTable.PECoffRelocationMethod getRelocation(PECoffMachine m, ObjectFile.RelocationKind k) {
        switch (m) {
            case X86_64: {
                switch (k) {
                    case DIRECT_8: {
                        return PECoffX86_64Relocation.ADDR64;
                    }
                    case DIRECT_4: {
                        return PECoffX86_64Relocation.ADDR32;
                    }
                    case PC_RELATIVE_4: {
                        return PECoffX86_64Relocation.REL32;
                    }
                    case SECTION_2: {
                        return PECoffX86_64Relocation.SECTION;
                    }
                    case SECREL_4: {
                        return PECoffX86_64Relocation.SECREL;
                    }
                }
                throw new IllegalArgumentException("cannot map unknown relocation kind to an PECoff x86-64 relocation type");
            }
        }
        throw new IllegalStateException("unknown PECoff machine type");
    }

    public static PECoffMachine from(int m) {
        switch (m) {
            case 34404: {
                return X86_64;
            }
        }
        throw new IllegalStateException("unknown PECoff machine type");
    }

    public short toShort() {
        if (this == X86_64) {
            return -31132;
        }
        throw new IllegalStateException("should not reach here");
    }

    public static PECoffMachine getSystemNativeValue() {
        String archStr = System.getProperty("os.arch").toLowerCase();
        if (archStr.equals("amd64") || archStr.equals("x86_64")) {
            return X86_64;
        }
        throw new IllegalStateException("unknown PECoff machine type");
    }
}

