/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.nativebridge;

import org.graalvm.nativebridge.BinaryOutput;
import org.graalvm.nativeimage.c.type.CCharPointer;

public abstract class BinaryInput {
    private static final int EOF = -1;
    private byte[] byteBuffer;
    private char[] charBuffer;
    protected final int length;
    protected int pos;

    private BinaryInput(int length) {
        this.length = length;
    }

    public final boolean readBoolean() throws IndexOutOfBoundsException {
        int b = this.read();
        if (b < 0) {
            throw new IndexOutOfBoundsException();
        }
        return b != 0;
    }

    public final byte readByte() throws IndexOutOfBoundsException {
        int b = this.read();
        if (b < 0) {
            throw new IndexOutOfBoundsException();
        }
        return (byte)b;
    }

    public final short readShort() throws IndexOutOfBoundsException {
        int b2;
        int b1 = this.read();
        if ((b1 | (b2 = this.read())) < 0) {
            throw new IndexOutOfBoundsException();
        }
        return (short)((b1 << 8) + b2);
    }

    public final char readChar() throws IndexOutOfBoundsException {
        int b2;
        int b1 = this.read();
        if ((b1 | (b2 = this.read())) < 0) {
            throw new IndexOutOfBoundsException();
        }
        return (char)((b1 << 8) + b2);
    }

    public final int readInt() throws IndexOutOfBoundsException {
        int b4;
        int b3;
        int b2;
        int b1 = this.read();
        if ((b1 | (b2 = this.read()) | (b3 = this.read()) | (b4 = this.read())) < 0) {
            throw new IndexOutOfBoundsException();
        }
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
    }

    public final long readLong() throws IndexOutOfBoundsException {
        int b8;
        int b7;
        int b6;
        int b5;
        int b4;
        int b3;
        int b2;
        int b1 = this.read();
        if ((b1 | (b2 = this.read()) | (b3 = this.read()) | (b4 = this.read()) | (b5 = this.read()) | (b6 = this.read()) | (b7 = this.read()) | (b8 = this.read())) < 0) {
            throw new IndexOutOfBoundsException();
        }
        return ((long)b1 << 56) + ((long)b2 << 48) + ((long)b3 << 40) + ((long)b4 << 32) + ((long)b5 << 24) + ((long)b6 << 16) + ((long)b7 << 8) + (long)b8;
    }

    public final float readFloat() throws IndexOutOfBoundsException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IndexOutOfBoundsException {
        return Double.longBitsToDouble(this.readLong());
    }

    public abstract int read();

    public abstract int read(byte[] var1, int var2, int var3);

    public final void readFully(byte[] b, int off, int len) throws IndexOutOfBoundsException {
        int count;
        if (len < 0) {
            throw new IllegalArgumentException(String.format("Len must be non negative but was %d", len));
        }
        for (int n = 0; n < len; n += count) {
            count = this.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new IndexOutOfBoundsException();
        }
    }

    public final String readUTF() throws IndexOutOfBoundsException, IllegalArgumentException {
        int c1;
        int byteCount;
        int len;
        int b2;
        int b1 = this.read();
        if ((b1 | (b2 = this.read())) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if ((b1 & 0x80) == 128) {
            int b4;
            int b3 = this.read();
            if ((b3 | (b4 = this.read())) < 0) {
                throw new IndexOutOfBoundsException();
            }
            len = ((b1 & 0xFFFFFF7F) << 24) + (b2 << 16) + (b3 << 8) + b4;
        } else {
            len = (b1 << 8) + b2;
        }
        if (this.byteBuffer == null || this.byteBuffer.length < len) {
            int bufSize = Math.max(BinaryOutput.bufferSize(0, len), 80);
            this.byteBuffer = new byte[bufSize];
            this.charBuffer = new char[bufSize];
        }
        int charCount = 0;
        this.readFully(this.byteBuffer, 0, len);
        for (byteCount = 0; byteCount < len && (c1 = this.byteBuffer[byteCount] & 0xFF) <= 127; ++byteCount) {
            this.charBuffer[charCount++] = (char)c1;
        }
        block6: while (byteCount < len) {
            c1 = this.byteBuffer[byteCount] & 0xFF;
            switch (c1 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++byteCount;
                    this.charBuffer[charCount++] = (char)c1;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((byteCount += 2) > len) {
                        throw new IllegalArgumentException("Partial character at end");
                    }
                    byte c2 = this.byteBuffer[byteCount - 1];
                    if ((c2 & 0xC0) != 128) {
                        throw new IllegalArgumentException("malformed input around byte " + byteCount);
                    }
                    this.charBuffer[charCount++] = (char)((c1 & 0x1F) << 6 | c2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((byteCount += 3) > len) {
                        throw new IllegalArgumentException("malformed input: partial character at end");
                    }
                    byte c2 = this.byteBuffer[byteCount - 2];
                    byte c3 = this.byteBuffer[byteCount - 1];
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        throw new IllegalArgumentException("malformed input around byte " + (byteCount - 1));
                    }
                    this.charBuffer[charCount++] = (char)((c1 & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                    continue block6;
                }
            }
            throw new IllegalArgumentException("malformed input around byte " + byteCount);
        }
        return new String(this.charBuffer, 0, charCount);
    }

    public final Object readTypedValue() throws IndexOutOfBoundsException, IllegalArgumentException {
        byte tag = this.readByte();
        switch (tag) {
            case 10: {
                int len = this.readInt();
                Object[] arr = new Object[len];
                for (int i = 0; i < len; ++i) {
                    arr[i] = this.readTypedValue();
                }
                return arr;
            }
            case 0: {
                return null;
            }
            case 1: {
                return this.readBoolean();
            }
            case 2: {
                return this.readByte();
            }
            case 3: {
                return this.readShort();
            }
            case 4: {
                return Character.valueOf(this.readChar());
            }
            case 5: {
                return this.readInt();
            }
            case 6: {
                return this.readLong();
            }
            case 7: {
                return Float.valueOf(this.readFloat());
            }
            case 8: {
                return this.readDouble();
            }
            case 9: {
                return this.readUTF();
            }
        }
        throw new IllegalArgumentException(String.format("Unknown tag %d", tag));
    }

    public static BinaryInput create(byte[] buffer) {
        return new ByteArrayBinaryInput(buffer);
    }

    public static BinaryInput create(CCharPointer address, int length) {
        return new CCharPointerInput(address, length);
    }

    private static final class CCharPointerInput
    extends BinaryInput {
        private final CCharPointer address;

        CCharPointerInput(CCharPointer address, int length) {
            super(length);
            this.address = address;
        }

        @Override
        public int read() {
            if (this.pos >= this.length) {
                return -1;
            }
            return this.address.read(this.pos++) & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) {
            if (this.pos >= this.length) {
                return -1;
            }
            int i = 0;
            for (int j = this.pos; i < len && j < this.length; ++i, ++j) {
                b[off + i] = this.address.read(j);
            }
            this.pos += i;
            return i;
        }
    }

    private static final class ByteArrayBinaryInput
    extends BinaryInput {
        private final byte[] buffer;

        ByteArrayBinaryInput(byte[] buffer) {
            super(buffer.length);
            this.buffer = buffer;
        }

        @Override
        public int read() {
            if (this.pos >= this.length) {
                return -1;
            }
            return this.buffer[this.pos++] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) {
            if (this.pos >= this.length) {
                return -1;
            }
            int toRead = Math.min(len, this.length - this.pos);
            System.arraycopy(this.buffer, this.pos, b, off, toRead);
            this.pos += toRead;
            return toRead;
        }
    }
}

