/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.AbstractFastThreadLocal;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.impl.FrameWithoutBoxing;
import com.oracle.truffle.api.impl.ThreadLocalHandshake;
import com.oracle.truffle.api.nodes.BlockNode;
import com.oracle.truffle.api.nodes.BytecodeOSRNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.function.Function;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.BackgroundCompileQueue;
import org.graalvm.compiler.truffle.runtime.BaseOSRRootNode;
import org.graalvm.compiler.truffle.runtime.BytecodeOSRMetadata;
import org.graalvm.compiler.truffle.runtime.EngineCacheSupport;
import org.graalvm.compiler.truffle.runtime.EngineData;
import org.graalvm.compiler.truffle.runtime.GraalRuntimeAccessor;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedAssumption;
import org.graalvm.compiler.truffle.runtime.OptimizedBlockNode;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.OptimizedOSRLoopNode;
import org.graalvm.compiler.truffle.runtime.TruffleSplittingStrategy;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionValues;

final class GraalRuntimeSupport
extends Accessor.RuntimeSupport {
    static final String CALL_INLINED_METHOD_NAME = "callInlined";

    GraalRuntimeSupport(Object permission) {
        super(permission);
    }

    public RootCallTarget newCallTarget(CallTarget source, RootNode rootNode) {
        assert (GraalRuntimeAccessor.NODES.getCallTargetWithoutInitialization(rootNode) == null) : "CallTarget for root node already initialized.";
        CompilerAsserts.neverPartOfCompilation();
        return GraalTruffleRuntime.getRuntime().createOptimizedCallTarget((OptimizedCallTarget)source, rootNode);
    }

    public boolean isLoaded(CallTarget callTarget) {
        return ((OptimizedCallTarget)callTarget).isLoaded();
    }

    public void notifyOnLoad(CallTarget callTarget) {
        CompilerAsserts.neverPartOfCompilation();
        OptimizedCallTarget target = (OptimizedCallTarget)callTarget;
        GraalRuntimeAccessor.INSTRUMENT.onLoad(target.getRootNode());
        if (target.engine.compileAOTOnCreate && target.prepareForAOT()) {
            target.compile(true);
        }
        TruffleSplittingStrategy.newTargetCreated(target);
        target.setLoaded();
    }

    @ExplodeLoop
    public void onLoopCount(Node source, int count) {
        RootCallTarget target;
        Node parentNode;
        CompilerAsserts.partialEvaluationConstant((Object)source);
        Node node = parentNode = source != null ? source.getParent() : null;
        for (Node node2 = source; node2 != null; node2 = node2.getParent()) {
            if (node2 instanceof OptimizedOSRLoopNode) {
                ((OptimizedOSRLoopNode)node2).reportChildLoopCount(count);
            }
            parentNode = node2;
        }
        if (parentNode instanceof RootNode && (target = ((RootNode)parentNode).getCallTarget()) instanceof OptimizedCallTarget) {
            ((OptimizedCallTarget)target).onLoopCount(count);
        }
    }

    public boolean pollBytecodeOSRBackEdge(BytecodeOSRNode osrNode) {
        CompilerAsserts.neverPartOfCompilation();
        TruffleSafepoint.poll((Node)((Node)osrNode));
        BytecodeOSRMetadata osrMetadata = (BytecodeOSRMetadata)osrNode.getOSRMetadata();
        if (osrMetadata == null) {
            osrMetadata = GraalRuntimeSupport.initializeBytecodeOSRMetadata(osrNode);
        }
        if (osrMetadata.isDisabled()) {
            return false;
        }
        return osrMetadata.incrementAndPoll();
    }

    private static BytecodeOSRMetadata initializeBytecodeOSRMetadata(BytecodeOSRNode osrNode) {
        Node node = (Node)osrNode;
        return (BytecodeOSRMetadata)node.atomic(() -> {
            BytecodeOSRMetadata metadata = (BytecodeOSRMetadata)osrNode.getOSRMetadata();
            if (metadata == null) {
                OptimizedCallTarget callTarget = (OptimizedCallTarget)node.getRootNode().getCallTarget();
                metadata = callTarget.engine.compilation && callTarget.getOptionValue(PolyglotCompilerOptions.OSR) != false ? new BytecodeOSRMetadata(osrNode, callTarget.getOptionValue(PolyglotCompilerOptions.OSRCompilationThreshold), callTarget.getOptionValue(PolyglotCompilerOptions.OSRMaxCompilationReAttempts)) : BytecodeOSRMetadata.DISABLED;
                osrNode.setOSRMetadata((Object)metadata);
            }
            return metadata;
        });
    }

    public Object tryBytecodeOSR(BytecodeOSRNode osrNode, int target, Object interpreterState, Runnable beforeTransfer, VirtualFrame parentFrame) {
        CompilerAsserts.neverPartOfCompilation();
        BytecodeOSRMetadata osrMetadata = (BytecodeOSRMetadata)osrNode.getOSRMetadata();
        return osrMetadata.tryOSR(target, interpreterState, beforeTransfer, parentFrame);
    }

    public void onOSRNodeReplaced(BytecodeOSRNode osrNode, Node oldNode, Node newNode, CharSequence reason) {
        BytecodeOSRMetadata osrMetadata = (BytecodeOSRMetadata)osrNode.getOSRMetadata();
        if (osrMetadata != null) {
            osrMetadata.nodeReplaced(oldNode, newNode, reason);
        }
    }

    public void transferOSRFrame(BytecodeOSRNode osrNode, Frame source, Frame target, int bytecodeTarget) {
        BytecodeOSRMetadata osrMetadata = (BytecodeOSRMetadata)osrNode.getOSRMetadata();
        BytecodeOSRMetadata.OsrEntryDescription targetMetadata = osrMetadata.getLazyState().get(bytecodeTarget);
        osrMetadata.transferFrame((FrameWithoutBoxing)source, (FrameWithoutBoxing)target, bytecodeTarget, targetMetadata);
    }

    public void transferOSRFrame(BytecodeOSRNode osrNode, Frame source, Frame target, int bytecodeTarget, Object targetMetadata) {
        BytecodeOSRMetadata osrMetadata = (BytecodeOSRMetadata)osrNode.getOSRMetadata();
        osrMetadata.transferFrame((FrameWithoutBoxing)source, (FrameWithoutBoxing)target, bytecodeTarget, targetMetadata);
    }

    public void restoreOSRFrame(BytecodeOSRNode osrNode, Frame source, Frame target) {
        BytecodeOSRMetadata osrMetadata = (BytecodeOSRMetadata)osrNode.getOSRMetadata();
        osrMetadata.restoreFrame((FrameWithoutBoxing)source, (FrameWithoutBoxing)target);
    }

    public ThreadLocalHandshake getThreadLocalHandshake() {
        return GraalTruffleRuntime.getRuntime().getThreadLocalHandshake();
    }

    public OptionDescriptors getEngineOptionDescriptors() {
        return GraalTruffleRuntime.getRuntime().getEngineOptionDescriptors();
    }

    public boolean isGuestCallStackFrame(StackTraceElement e) {
        return e.getMethodName().equals("executeRootNode") && e.getClassName().equals(OptimizedCallTarget.class.getName());
    }

    public void initializeProfile(CallTarget target, Class<?>[] argumentTypes) {
        ((OptimizedCallTarget)target).initializeUnsafeArgumentTypes(argumentTypes);
    }

    public <T extends Node> BlockNode<T> createBlockNode(T[] elements, BlockNode.ElementExecutor<T> executor) {
        return new OptimizedBlockNode(elements, executor);
    }

    public Assumption createAlwaysValidAssumption() {
        return OptimizedAssumption.createAlwaysValid();
    }

    public String getSavedProperty(String key) {
        return (String)Services.getSavedProperties().get(key);
    }

    public void reportPolymorphicSpecialize(Node source) {
        OptimizedCallTarget callTarget;
        RootNode rootNode = source.getRootNode();
        OptimizedCallTarget optimizedCallTarget = callTarget = rootNode == null ? null : (OptimizedCallTarget)rootNode.getCallTarget();
        if (callTarget == null) {
            return;
        }
        TruffleSplittingStrategy.newPolymorphicSpecialize(source, callTarget.engine);
        callTarget.polymorphicSpecialize(source);
    }

    public Object callInlined(Node callNode, CallTarget target, Object ... arguments) {
        OptimizedCallTarget optimizedCallTarget = (OptimizedCallTarget)target;
        try {
            return optimizedCallTarget.callInlined(callNode, arguments);
        }
        catch (Throwable t) {
            GraalRuntimeAccessor.LANGUAGE.onThrowable(callNode, (RootCallTarget)optimizedCallTarget, t, null);
            throw OptimizedCallTarget.rethrow(t);
        }
    }

    public Object callProfiled(CallTarget target, Object ... arguments) {
        OptimizedCallTarget castTarget = (OptimizedCallTarget)target;
        assert (castTarget.isValidArgumentProfile(arguments)) : "Invalid argument profile. callProfiled requires to explicity initialize the profile.";
        return castTarget.doInvoke(arguments);
    }

    public Object[] castArrayFixedLength(Object[] args, int length) {
        return OptimizedCallTarget.castArrayFixedLength(args, length);
    }

    public <T> T unsafeCast(Object value, Class<T> type, boolean condition, boolean nonNull, boolean exact) {
        return OptimizedCallTarget.unsafeCast(value, type, condition, nonNull, exact);
    }

    public void flushCompileQueue(Object runtimeData) {
        EngineData engine = (EngineData)runtimeData;
        BackgroundCompileQueue queue = GraalTruffleRuntime.getRuntime().getCompileQueue();
        if (queue != null) {
            for (OptimizedCallTarget target : queue.getQueuedTargets(engine)) {
                target.cancelCompilation("Polyglot engine was closed.");
            }
        }
    }

    public Object tryLoadCachedEngine(OptionValues options, Function<String, TruffleLogger> loggerFactory) {
        return GraalTruffleRuntime.getRuntime().getEngineCacheSupport().tryLoadingCachedEngine(options, loggerFactory);
    }

    public boolean isStoreEnabled(OptionValues options) {
        return EngineCacheSupport.get().isStoreEnabled(options);
    }

    public Object createRuntimeData(OptionValues options, Function<String, TruffleLogger> loggerFactory) {
        return new EngineData(options, loggerFactory);
    }

    public void onEngineCreate(Object engine, Object runtimeData) {
        ((EngineData)runtimeData).onEngineCreated(engine);
    }

    public void onEnginePatch(Object runtimeData, OptionValues options, Function<String, TruffleLogger> loggerFactory) {
        ((EngineData)runtimeData).onEnginePatch(options, loggerFactory);
    }

    public boolean onEngineClosing(Object runtimeData) {
        return ((EngineData)runtimeData).onEngineClosing();
    }

    public void onEngineClosed(Object runtimeData) {
        ((EngineData)runtimeData).onEngineClosed();
    }

    public boolean isOSRRootNode(RootNode rootNode) {
        return rootNode instanceof BaseOSRRootNode;
    }

    public int getObjectAlignment() {
        return GraalTruffleRuntime.getRuntime().getObjectAlignment();
    }

    public int getArrayBaseOffset(Class<?> componentType) {
        return GraalTruffleRuntime.getRuntime().getArrayBaseOffset(componentType);
    }

    public int getArrayIndexScale(Class<?> componentType) {
        return GraalTruffleRuntime.getRuntime().getArrayIndexScale(componentType);
    }

    public int getBaseInstanceSize(Class<?> type) {
        return GraalTruffleRuntime.getRuntime().getBaseInstanceSize(type);
    }

    public Object[] getResolvedFields(Class<?> type, boolean includePrimitive, boolean includeSuperclasses) {
        return GraalTruffleRuntime.getRuntime().getResolvedFields(type, includePrimitive, includeSuperclasses);
    }

    public Object getFieldValue(Object resolvedJavaField, Object obj) {
        return GraalTruffleRuntime.getRuntime().getFieldValue((ResolvedJavaField)resolvedJavaField, obj);
    }

    public AbstractFastThreadLocal getContextThreadLocal() {
        AbstractFastThreadLocal local = GraalTruffleRuntime.getRuntime().getFastThreadLocalImpl();
        if (local == null) {
            return super.getContextThreadLocal();
        }
        return local;
    }
}

