/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RepeatingNode;
import java.util.Objects;

abstract class AbstractOptimizedLoopNode
extends LoopNode {
    @Node.Child
    protected RepeatingNode repeatingNode;
    @CompilerDirectives.CompilationFinal
    private long trueCount;
    @CompilerDirectives.CompilationFinal
    private int falseCount;

    protected AbstractOptimizedLoopNode(RepeatingNode repeatingNode) {
        this.repeatingNode = Objects.requireNonNull(repeatingNode);
    }

    public final RepeatingNode getRepeatingNode() {
        return this.repeatingNode;
    }

    protected final void profileCounted(long iterations) {
        long trueCountLocal;
        if (CompilerDirectives.inInterpreter() && (trueCountLocal = this.trueCount + iterations) >= 0L) {
            this.trueCount = trueCountLocal;
            int falseCountLocal = this.falseCount;
            if (falseCountLocal < Integer.MAX_VALUE) {
                this.falseCount = falseCountLocal + 1;
            }
        }
    }

    protected final boolean inject(boolean condition) {
        if (CompilerDirectives.inCompiledCode()) {
            return CompilerDirectives.injectBranchProbability((double)AbstractOptimizedLoopNode.calculateProbability(this.trueCount, this.falseCount), (boolean)condition);
        }
        return condition;
    }

    private static double calculateProbability(long trueCountLocal, int falseCountLocal) {
        if (falseCountLocal == 0 && trueCountLocal == 0L) {
            return 0.5;
        }
        return (double)trueCountLocal / (double)(trueCountLocal + (long)falseCountLocal);
    }
}

