/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases.inlining;

import org.graalvm.compiler.truffle.compiler.phases.inlining.CallNode;
import org.graalvm.compiler.truffle.compiler.phases.inlining.CallTree;
import org.graalvm.compiler.truffle.compiler.phases.inlining.InliningPolicy;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.options.OptionValues;

final class TrivialOnlyInliningPolicy
implements InliningPolicy {
    private final OptionValues options;

    TrivialOnlyInliningPolicy(OptionValues options) {
        this.options = options;
    }

    @Override
    public void run(CallTree tree) {
        String inlineOnly = (String)this.options.get(PolyglotCompilerOptions.InlineOnly);
        for (CallNode child : tree.getRoot().getChildren()) {
            if (!InliningPolicy.acceptForInline(child, inlineOnly) || !child.isTrivial()) continue;
            child.expand();
            child.inline();
        }
    }
}

