/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases.inlining;

import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.TruffleInliningData;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;
import org.graalvm.compiler.truffle.compiler.PostPartialEvaluationSuite;
import org.graalvm.compiler.truffle.compiler.TruffleTierContext;
import org.graalvm.compiler.truffle.compiler.phases.inlining.CallNode;
import org.graalvm.compiler.truffle.compiler.phases.inlining.GraphManager;
import org.graalvm.compiler.truffle.compiler.phases.inlining.InliningPolicy;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;

public final class CallTree
extends Graph {
    private final InliningPolicy policy;
    private final GraphManager graphManager;
    private final CallNode root;
    private final TruffleTierContext context;
    final boolean useSize;
    int expanded = 1;
    int inlined = 1;
    int frontierSize;
    private int nextId = 0;

    CallTree(PartialEvaluator partialEvaluator, PostPartialEvaluationSuite postPartialEvaluationSuite, TruffleTierContext context, InliningPolicy policy) {
        super(context.graph.getOptions(), context.debug);
        this.policy = policy;
        this.context = context;
        this.graphManager = new GraphManager(partialEvaluator, postPartialEvaluationSuite, context);
        this.useSize = (Boolean)context.options.get(PolyglotCompilerOptions.InliningUseSize);
        this.root = CallNode.makeRoot(this, context);
    }

    int nextId() {
        return this.nextId++;
    }

    InliningPolicy getPolicy() {
        return this.policy;
    }

    public CallNode getRoot() {
        return this.root;
    }

    public int getInlinedCount() {
        return this.inlined;
    }

    public int getExpandedCount() {
        return this.expanded;
    }

    GraphManager getGraphManager() {
        return this.graphManager;
    }

    void trace() {
        Boolean details = (Boolean)this.context.options.get(PolyglotCompilerOptions.TraceInliningDetails);
        if (((Boolean)this.context.options.get(PolyglotCompilerOptions.TraceInlining)).booleanValue() || details.booleanValue()) {
            TruffleCompilerRuntime runtime = TruffleCompilerRuntime.getRuntime();
            runtime.logEvent(this.root.getDirectCallTarget(), 0, "Inline start", this.root.getName(), this.root.getStringProperties(), null);
            this.traceRecursive(runtime, this.root, details, 0);
            runtime.logEvent(this.root.getDirectCallTarget(), 0, "Inline done", this.root.getName(), this.root.getStringProperties(), null);
        }
    }

    private void traceRecursive(TruffleCompilerRuntime runtime, CallNode node, boolean details, int depth) {
        if (depth != 0) {
            runtime.logEvent(this.root.getDirectCallTarget(), depth, node.getState().toString(), node.getName(), node.getStringProperties(), null);
        }
        if (node.getState() == CallNode.State.Inlined || details) {
            for (CallNode child : node.getChildren()) {
                this.traceRecursive(runtime, child, details, depth + 1);
            }
        }
    }

    @Override
    public String toString() {
        return "Call Tree";
    }

    void dumpBasic(String format) {
        this.getDebug().dump(1, (Object)this, format, "");
    }

    public void dumpInfo(String format, Object arg) {
        this.getDebug().dump(2, (Object)this, format, arg);
    }

    public void finalizeGraph() {
        this.root.finalizeGraph();
    }

    void collectTargetsToDequeue(TruffleInliningData provider) {
        this.root.collectTargetsToDequeue(provider);
    }

    public void updateTracingInfo(TruffleInliningData inliningPlan) {
        int inlinedWithoutRoot = this.inlined - 1;
        inliningPlan.setCallCounts(inlinedWithoutRoot + this.frontierSize, inlinedWithoutRoot);
        if (this.loggingInlinedTargets()) {
            this.root.collectInlinedTargets(inliningPlan);
        }
    }

    private boolean loggingInlinedTargets() {
        return this.context.debug.isDumpEnabled(1) || (Boolean)this.context.options.get(PolyglotCompilerOptions.CompilationStatistics) != false || (Boolean)this.context.options.get(PolyglotCompilerOptions.CompilationStatisticDetails) != false;
    }
}

