/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import java.util.Objects;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;
import org.graalvm.compiler.truffle.compiler.PerformanceInformationHandler;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerImpl;
import org.graalvm.compiler.truffle.compiler.nodes.TruffleAssumption;
import org.graalvm.options.OptionValues;

public final class TruffleTierContext
extends HighTierContext {
    public final OptionValues options;
    public final DebugContext debug;
    public final CompilableTruffleAST compilable;
    public final CompilationIdentifier compilationId;
    public final SpeculationLog log;
    public final TruffleCompilerImpl.CancellableTruffleCompilationTask task;
    public final StructuredGraph graph;
    public final PerformanceInformationHandler handler;

    public TruffleTierContext(PartialEvaluator partialEvaluator, OptionValues options, DebugContext debug, CompilableTruffleAST compilable, ResolvedJavaMethod method, CompilationIdentifier compilationId, SpeculationLog log, TruffleCompilerImpl.CancellableTruffleCompilationTask task, PerformanceInformationHandler handler) {
        super(partialEvaluator.getProviders(), new PhaseSuite<HighTierContext>(), OptimisticOptimizations.NONE);
        Objects.requireNonNull(options);
        Objects.requireNonNull(debug);
        Objects.requireNonNull(compilable);
        Objects.requireNonNull(compilationId);
        Objects.requireNonNull(task);
        this.options = options;
        this.debug = debug;
        this.compilable = compilable;
        this.compilationId = compilationId;
        this.log = log;
        this.task = task;
        StructuredGraph.Builder builder = new StructuredGraph.Builder(this.debug.getOptions(), this.debug, StructuredGraph.AllowAssumptions.YES).name(this.compilable.getName()).method(method).speculationLog(this.log).compilationId(this.compilationId).trackNodeSourcePosition(partialEvaluator.configForParsing.trackNodeSourcePosition()).cancellable(this.task);
        builder = partialEvaluator.customizeStructuredGraphBuilder(builder);
        this.graph = builder.build();
        this.graph.getAssumptions().record((Assumptions.Assumption)new TruffleAssumption(compilable.getValidRootAssumptionConstant()));
        this.graph.getAssumptions().record((Assumptions.Assumption)new TruffleAssumption(compilable.getNodeRewritingAssumptionConstant()));
        this.handler = handler;
    }

    public TruffleTierContext(PartialEvaluator partialEvaluator, TruffleCompilerImpl.TruffleCompilationWrapper wrapper, DebugContext debug, PerformanceInformationHandler handler) {
        this(partialEvaluator, wrapper.options, debug, wrapper.compilable, partialEvaluator.rootForCallTarget(wrapper.compilable), wrapper.compilationId, TruffleTierContext.getSpeculationLog(wrapper), wrapper.task, handler);
    }

    public boolean isFirstTier() {
        return this.task.isFirstTier();
    }

    private static SpeculationLog getSpeculationLog(TruffleCompilerImpl.TruffleCompilationWrapper wrapper) {
        SpeculationLog speculationLog = wrapper.compilable.getCompilationSpeculationLog();
        if (speculationLog != null) {
            speculationLog.collectFailedSpeculations();
        }
        return speculationLog;
    }
}

