/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import java.util.EnumSet;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.Stride;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.lir.GenerateStub;
import org.graalvm.compiler.lir.GenerateStubs;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.util.ConstantReflectionUtil;
import org.graalvm.compiler.replacements.nodes.ArrayIndexOfForeignCalls;
import org.graalvm.compiler.replacements.nodes.PureFunctionStubIntrinsicNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_16)
public class ArrayIndexOfNode
extends PureFunctionStubIntrinsicNode
implements Canonicalizable {
    public static final NodeClass<ArrayIndexOfNode> TYPE = NodeClass.create(ArrayIndexOfNode.class);
    private final Stride stride;
    private final boolean findTwoConsecutive;
    private final boolean withMask;
    @Node.Input
    private ValueNode arrayPointer;
    @Node.Input
    private ValueNode arrayOffset;
    @Node.Input
    private ValueNode arrayLength;
    @Node.Input
    private ValueNode fromIndex;
    @Node.Input
    private NodeInputList<ValueNode> searchValues;

    public ArrayIndexOfNode(@Node.ConstantNodeParameter JavaKind arrayKind, @Node.ConstantNodeParameter Stride stride, @Node.ConstantNodeParameter boolean findTwoConsecutive, @Node.ConstantNodeParameter boolean withMask, ValueNode arrayPointer, ValueNode arrayOffset, ValueNode arrayLength, ValueNode fromIndex, ValueNode ... searchValues) {
        this(TYPE, stride, findTwoConsecutive, withMask, null, ArrayIndexOfNode.defaultLocationIdentity(arrayKind), arrayPointer, arrayOffset, arrayLength, fromIndex, searchValues);
    }

    public ArrayIndexOfNode(@Node.ConstantNodeParameter JavaKind arrayKind, @Node.ConstantNodeParameter Stride stride, @Node.ConstantNodeParameter boolean findTwoConsecutive, @Node.ConstantNodeParameter boolean withMask, @Node.ConstantNodeParameter EnumSet<?> runtimeCheckedCPUFeatures, ValueNode arrayPointer, ValueNode arrayOffset, ValueNode arrayLength, ValueNode fromIndex, ValueNode ... searchValues) {
        this(TYPE, stride, findTwoConsecutive, withMask, runtimeCheckedCPUFeatures, ArrayIndexOfNode.defaultLocationIdentity(arrayKind), arrayPointer, arrayOffset, arrayLength, fromIndex, searchValues);
    }

    public ArrayIndexOfNode(Stride stride, boolean findTwoConsecutive, boolean withMask, EnumSet<?> runtimeCheckedCPUFeatures, LocationIdentity locationIdentity, ValueNode arrayPointer, ValueNode arrayOffset, ValueNode arrayLength, ValueNode fromIndex, ValueNode ... searchValues) {
        this(TYPE, stride, findTwoConsecutive, withMask, runtimeCheckedCPUFeatures, locationIdentity, arrayPointer, arrayOffset, arrayLength, fromIndex, searchValues);
    }

    public ArrayIndexOfNode(NodeClass<? extends ArrayIndexOfNode> c, Stride stride, boolean findTwoConsecutive, boolean withMask, EnumSet<?> runtimeCheckedCPUFeatures, LocationIdentity locationIdentity, ValueNode arrayPointer, ValueNode arrayOffset, ValueNode arrayLength, ValueNode fromIndex, ValueNode ... searchValues) {
        super(c, StampFactory.forKind(JavaKind.Int), runtimeCheckedCPUFeatures, locationIdentity);
        GraalError.guarantee(stride.value <= 4, "unsupported stride");
        GraalError.guarantee(withMask || !findTwoConsecutive || searchValues.length == 2, "findTwoConsecutive without mask requires exactly two search values");
        GraalError.guarantee(!withMask || !findTwoConsecutive || searchValues.length == 4, "findTwoConsecutive with mask requires exactly four search values");
        GraalError.guarantee(!withMask || findTwoConsecutive || searchValues.length == 2, "indexOf with mask requires exactly two search values");
        this.stride = stride;
        this.findTwoConsecutive = findTwoConsecutive;
        this.withMask = withMask;
        this.arrayPointer = arrayPointer;
        this.arrayOffset = arrayOffset;
        this.arrayLength = arrayLength;
        this.fromIndex = fromIndex;
        this.searchValues = new NodeInputList((Node)this, (Node[])searchValues);
    }

    public static ArrayIndexOfNode createIndexOfSingle(GraphBuilderContext b, JavaKind arrayKind, Stride stride, ValueNode array, ValueNode arrayLength, ValueNode fromIndex, ValueNode searchValue) {
        ConstantNode baseOffset = ConstantNode.forLong(b.getMetaAccess().getArrayBaseOffset(arrayKind), b.getGraph());
        return new ArrayIndexOfNode(TYPE, stride, false, false, null, ArrayIndexOfNode.defaultLocationIdentity(arrayKind), array, (ValueNode)baseOffset, arrayLength, fromIndex, searchValue);
    }

    private static LocationIdentity defaultLocationIdentity(JavaKind arrayKind) {
        return arrayKind == JavaKind.Void ? LocationIdentity.any() : NamedLocationIdentity.getArrayLocation(arrayKind);
    }

    public boolean isFindTwoConsecutive() {
        return this.findTwoConsecutive;
    }

    public boolean isWithMask() {
        return this.withMask;
    }

    public ValueNode getArrayPointer() {
        return this.arrayPointer;
    }

    public ValueNode getArrayOffset() {
        return this.arrayOffset;
    }

    public ValueNode getArrayLength() {
        return this.arrayLength;
    }

    public ValueNode getFromIndex() {
        return this.fromIndex;
    }

    public NodeInputList<ValueNode> getSearchValues() {
        return this.searchValues;
    }

    public int getNumberOfValues() {
        return this.searchValues.size();
    }

    public Stride getStride() {
        return this.stride;
    }

    @Override
    public ForeignCallDescriptor getForeignCallDescriptor() {
        return ArrayIndexOfForeignCalls.getStub(this);
    }

    @Override
    public ValueNode[] getForeignCallArguments() {
        ValueNode[] args = new ValueNode[4 + this.searchValues.size()];
        args[0] = this.arrayPointer;
        args[1] = this.arrayOffset;
        args[2] = this.arrayLength;
        args[3] = this.fromIndex;
        for (int i = 0; i < this.searchValues.size(); ++i) {
            args[4 + i] = (ValueNode)this.searchValues.get(i);
        }
        return args;
    }

    @Override
    public void emitIntrinsic(NodeLIRBuilderTool gen) {
        gen.setResult(this, (Value)gen.getLIRGeneratorTool().emitArrayIndexOf(this.stride, this.findTwoConsecutive, this.withMask, this.getRuntimeCheckedCPUFeatures(), gen.operand(this.arrayPointer), gen.operand(this.arrayOffset), gen.operand(this.arrayLength), gen.operand(this.fromIndex), this.searchValuesAsOperands(gen)));
    }

    protected int getArrayBaseOffset(MetaAccessProvider metaAccessProvider, ValueNode array, JavaKind kind) {
        return metaAccessProvider.getArrayBaseOffset(kind);
    }

    private Value[] searchValuesAsOperands(NodeLIRBuilderTool gen) {
        Value[] searchValueOperands = new Value[this.searchValues.size()];
        for (int i = 0; i < this.searchValues.size(); ++i) {
            searchValueOperands[i] = gen.operand((Node)this.searchValues.get(i));
        }
        return searchValueOperands;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (tool.allUsagesAvailable() && this.hasNoUsages()) {
            return null;
        }
        if (this.arrayPointer.isJavaConstant() && ((ConstantNode)this.arrayPointer).getStableDimension() > 0 && this.arrayOffset.isJavaConstant() && this.arrayLength.isJavaConstant() && this.fromIndex.isJavaConstant() && this.searchValuesConstant()) {
            int i;
            ConstantReflectionProvider provider = tool.getConstantReflection();
            JavaConstant arrayConstant = this.arrayPointer.asJavaConstant();
            JavaKind constantArrayKind = this.arrayPointer.stamp(NodeView.DEFAULT).javaType(tool.getMetaAccess()).getComponentType().getJavaKind();
            int actualArrayLength = provider.readArrayLength(arrayConstant);
            long arrayBaseOffsetBytesConstant = this.arrayOffset.asJavaConstant().asLong();
            long arrayOffsetConstant = (arrayBaseOffsetBytesConstant -= (long)this.getArrayBaseOffset(tool.getMetaAccess(), this.arrayPointer, constantArrayKind)) / (long)this.stride.value;
            int arrayLengthConstant = this.arrayLength.asJavaConstant().asInt();
            assert (arrayLengthConstant * this.stride.value <= actualArrayLength * constantArrayKind.getByteCount());
            int fromIndexConstant = this.fromIndex.asJavaConstant().asInt();
            int[] valuesConstant = new int[this.searchValues.size()];
            for (i = 0; i < this.searchValues.size(); ++i) {
                valuesConstant[i] = ((ValueNode)this.searchValues.get(i)).asJavaConstant().asInt();
            }
            if (arrayLengthConstant * this.stride.value < GraalOptions.StringIndexOfConstantLimit.getValue(tool.getOptions())) {
                if (this.findTwoConsecutive) {
                    assert (valuesConstant.length == (this.withMask ? 4 : 2));
                    for (i = fromIndexConstant; i < arrayLengthConstant - 1; ++i) {
                        int v0 = ConstantReflectionUtil.readTypePunned(provider, arrayConstant, constantArrayKind, this.stride, (int)(arrayOffsetConstant + (long)i));
                        int v1 = ConstantReflectionUtil.readTypePunned(provider, arrayConstant, constantArrayKind, this.stride, (int)(arrayOffsetConstant + (long)i + 1L));
                        if (!(this.withMask ? (v0 | valuesConstant[2]) == valuesConstant[0] && (v1 | valuesConstant[3]) == valuesConstant[1] : v0 == valuesConstant[0] && v1 == valuesConstant[1])) continue;
                        return ConstantNode.forInt(i);
                    }
                } else {
                    assert (!this.withMask || valuesConstant.length == 2);
                    for (i = fromIndexConstant; i < arrayLengthConstant; ++i) {
                        int value = ConstantReflectionUtil.readTypePunned(provider, arrayConstant, constantArrayKind, this.stride, (int)(arrayOffsetConstant + (long)i));
                        if (this.withMask) {
                            if ((value | valuesConstant[1]) != valuesConstant[0]) continue;
                            return ConstantNode.forInt(i);
                        }
                        for (int searchValue : valuesConstant) {
                            if (value != searchValue) continue;
                            return ConstantNode.forInt(i);
                        }
                    }
                }
                return ConstantNode.forInt(-1);
            }
        }
        return this;
    }

    private boolean searchValuesConstant() {
        for (ValueNode s : this.searchValues) {
            if (s.isJavaConstant()) continue;
            return false;
        }
        return true;
    }

    @Node.NodeIntrinsic
    @GenerateStubs(value={@GenerateStub(name="indexOf1S1", parameters={"Void", "S1", "false", "false"}), @GenerateStub(name="indexOf1S2", parameters={"Void", "S2", "false", "false"}), @GenerateStub(name="indexOf1S4", parameters={"Void", "S4", "false", "false"})})
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter Stride var1, @Node.ConstantNodeParameter boolean var2, @Node.ConstantNodeParameter boolean var3, Object var4, long var5, int var7, int var8, int var9);

    @Node.NodeIntrinsic
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter Stride var1, @Node.ConstantNodeParameter boolean var2, @Node.ConstantNodeParameter boolean var3, @Node.ConstantNodeParameter EnumSet<?> var4, Object var5, long var6, int var8, int var9, int var10);

    @Node.NodeIntrinsic
    @GenerateStubs(value={@GenerateStub(name="indexOf2S1", parameters={"Void", "S1", "false", "false"}), @GenerateStub(name="indexOf2S2", parameters={"Void", "S2", "false", "false"}), @GenerateStub(name="indexOf2S4", parameters={"Void", "S4", "false", "false"}), @GenerateStub(name="indexOfWithMaskS1", parameters={"Void", "S1", "false", "true"}), @GenerateStub(name="indexOfWithMaskS2", parameters={"Void", "S2", "false", "true"}), @GenerateStub(name="indexOfWithMaskS4", parameters={"Void", "S4", "false", "true"}), @GenerateStub(name="indexOfTwoConsecutiveS1", parameters={"Void", "S1", "true", "false"}), @GenerateStub(name="indexOfTwoConsecutiveS2", parameters={"Void", "S2", "true", "false"}), @GenerateStub(name="indexOfTwoConsecutiveS4", parameters={"Void", "S4", "true", "false"})})
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter Stride var1, @Node.ConstantNodeParameter boolean var2, @Node.ConstantNodeParameter boolean var3, Object var4, long var5, int var7, int var8, int var9, int var10);

    @Node.NodeIntrinsic
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter Stride var1, @Node.ConstantNodeParameter boolean var2, @Node.ConstantNodeParameter boolean var3, @Node.ConstantNodeParameter EnumSet<?> var4, Object var5, long var6, int var8, int var9, int var10, int var11);

    @Node.NodeIntrinsic
    @GenerateStubs(value={@GenerateStub(name="indexOf3S1", parameters={"Void", "S1", "false", "false"}), @GenerateStub(name="indexOf3S2", parameters={"Void", "S2", "false", "false"}), @GenerateStub(name="indexOf3S4", parameters={"Void", "S4", "false", "false"})})
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter Stride var1, @Node.ConstantNodeParameter boolean var2, @Node.ConstantNodeParameter boolean var3, Object var4, long var5, int var7, int var8, int var9, int var10, int var11);

    @Node.NodeIntrinsic
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter Stride var1, @Node.ConstantNodeParameter boolean var2, @Node.ConstantNodeParameter boolean var3, @Node.ConstantNodeParameter EnumSet<?> var4, Object var5, long var6, int var8, int var9, int var10, int var11, int var12);

    @Node.NodeIntrinsic
    @GenerateStubs(value={@GenerateStub(name="indexOf4S1", parameters={"Void", "S1", "false", "false"}), @GenerateStub(name="indexOf4S2", parameters={"Void", "S2", "false", "false"}), @GenerateStub(name="indexOf4S4", parameters={"Void", "S4", "false", "false"}), @GenerateStub(name="indexOfTwoConsecutiveWithMaskS1", parameters={"Void", "S1", "true", "true"}), @GenerateStub(name="indexOfTwoConsecutiveWithMaskS2", parameters={"Void", "S2", "true", "true"}), @GenerateStub(name="indexOfTwoConsecutiveWithMaskS4", parameters={"Void", "S4", "true", "true"})})
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter Stride var1, @Node.ConstantNodeParameter boolean var2, @Node.ConstantNodeParameter boolean var3, Object var4, long var5, int var7, int var8, int var9, int var10, int var11, int var12);

    @Node.NodeIntrinsic
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter Stride var1, @Node.ConstantNodeParameter boolean var2, @Node.ConstantNodeParameter boolean var3, @Node.ConstantNodeParameter EnumSet<?> var4, Object var5, long var6, int var8, int var9, int var10, int var11, int var12, int var13);
}

