/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.classfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.bytecode.Bytecode;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.replacements.classfile.Classfile;
import org.graalvm.compiler.replacements.classfile.ClassfileBytecodeProvider;
import org.graalvm.compiler.replacements.classfile.ClassfileConstant;
import org.graalvm.compiler.replacements.classfile.ClassfileConstantPool;

public class ClassfileBytecode
implements Bytecode {
    private static final int EXCEPTION_HANDLER_TABLE_SIZE_IN_BYTES = 8;
    private static final int LINE_NUMBER_TABLE_ENTRY_SIZE_IN_BYTES = 4;
    private static final int LOCAL_VARIABLE_TABLE_SIZE_IN_BYTES = 10;
    private final ResolvedJavaMethod method;
    private final ClassfileConstantPool constantPool;
    private byte[] code;
    private int maxLocals;
    private int maxStack;
    private byte[] exceptionTableBytes;
    private byte[] lineNumberTableBytes;
    private byte[] localVariableTableBytes;

    public ClassfileBytecode(ResolvedJavaMethod method, DataInputStream stream, ClassfileConstantPool constantPool) throws IOException {
        this.method = method;
        this.constantPool = constantPool;
        this.maxStack = stream.readUnsignedShort();
        this.maxLocals = stream.readUnsignedShort();
        int codeLength = stream.readInt();
        this.code = new byte[codeLength];
        stream.readFully(this.code);
        int exceptionTableLength = stream.readUnsignedShort();
        this.exceptionTableBytes = new byte[exceptionTableLength * 8];
        stream.readFully(this.exceptionTableBytes);
        this.readCodeAttributes(stream);
    }

    @Override
    public BytecodeProvider getOrigin() {
        return this.constantPool.context;
    }

    private void readCodeAttributes(DataInputStream stream) throws IOException {
        int count = stream.readUnsignedShort();
        block8: for (int i = 0; i < count; ++i) {
            String attributeName = this.constantPool.get(ClassfileConstant.Utf8.class, (int)stream.readUnsignedShort()).value;
            int attributeLength = stream.readInt();
            switch (attributeName) {
                case "LocalVariableTable": {
                    int length = stream.readUnsignedShort();
                    this.localVariableTableBytes = new byte[length * 10];
                    stream.readFully(this.localVariableTableBytes);
                    continue block8;
                }
                case "LineNumberTable": {
                    int length = stream.readUnsignedShort();
                    this.lineNumberTableBytes = new byte[length * 4];
                    stream.readFully(this.lineNumberTableBytes);
                    continue block8;
                }
                default: {
                    Classfile.skipFully(stream, attributeLength);
                }
            }
        }
    }

    @Override
    public byte[] getCode() {
        return this.code;
    }

    @Override
    public int getCodeSize() {
        return this.code.length;
    }

    @Override
    public int getMaxLocals() {
        return this.maxLocals;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public ExceptionHandler[] getExceptionHandlers() {
        if (this.exceptionTableBytes == null) {
            return new ExceptionHandler[0];
        }
        int exceptionTableLength = this.exceptionTableBytes.length / 8;
        ExceptionHandler[] handlers = new ExceptionHandler[exceptionTableLength];
        DataInputStream stream = new DataInputStream(new ByteArrayInputStream(this.exceptionTableBytes));
        for (int i = 0; i < exceptionTableLength; ++i) {
            try {
                JavaType catchType;
                int startPc = stream.readUnsignedShort();
                int endPc = stream.readUnsignedShort();
                int handlerPc = stream.readUnsignedShort();
                int catchTypeIndex = stream.readUnsignedShort();
                if (catchTypeIndex == 0) {
                    catchType = null;
                } else {
                    int opcode = -1;
                    catchType = this.constantPool.lookupType(catchTypeIndex, -1);
                    if (catchType.toJavaName().equals("java.lang.Throwable")) {
                        catchTypeIndex = 0;
                        catchType = null;
                    }
                }
                handlers[i] = new ExceptionHandler(startPc, endPc, handlerPc, catchTypeIndex, catchType);
                continue;
            }
            catch (IOException e) {
                throw new GraalError(e);
            }
        }
        return handlers;
    }

    @Override
    public StackTraceElement asStackTraceElement(int bci) {
        int line = this.getLineNumberTable().getLineNumber(bci);
        return new StackTraceElement(this.method.getDeclaringClass().toJavaName(), this.method.getName(), this.method.getDeclaringClass().getSourceFileName(), line);
    }

    @Override
    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    @Override
    public LineNumberTable getLineNumberTable() {
        if (this.lineNumberTableBytes == null) {
            return null;
        }
        int lineNumberTableLength = this.lineNumberTableBytes.length / 4;
        DataInputStream stream = new DataInputStream(new ByteArrayInputStream(this.lineNumberTableBytes));
        int[] bci = new int[lineNumberTableLength];
        int[] line = new int[lineNumberTableLength];
        for (int i = 0; i < lineNumberTableLength; ++i) {
            try {
                bci[i] = stream.readUnsignedShort();
                line[i] = stream.readUnsignedShort();
                continue;
            }
            catch (IOException e) {
                throw new GraalError(e);
            }
        }
        return new LineNumberTable(line, bci);
    }

    @Override
    public LocalVariableTable getLocalVariableTable() {
        if (this.localVariableTableBytes == null) {
            return null;
        }
        int localVariableTableLength = this.localVariableTableBytes.length / 10;
        DataInputStream stream = new DataInputStream(new ByteArrayInputStream(this.localVariableTableBytes));
        Local[] locals = new Local[localVariableTableLength];
        for (int i = 0; i < localVariableTableLength; ++i) {
            try {
                int startBci = stream.readUnsignedShort();
                int endBci = startBci + stream.readUnsignedShort();
                int nameCpIndex = stream.readUnsignedShort();
                int typeCpIndex = stream.readUnsignedShort();
                int slot = stream.readUnsignedShort();
                String localName = this.constantPool.lookupUtf8(nameCpIndex);
                String localType = this.constantPool.lookupUtf8(typeCpIndex);
                ClassfileBytecodeProvider context = this.constantPool.context;
                Class<?> c = context.resolveToClass(localType);
                locals[i] = new Local(localName, (JavaType)context.metaAccess.lookupJavaType(c), startBci, endBci, slot);
                continue;
            }
            catch (IOException e) {
                throw new GraalError(e);
            }
        }
        return new LocalVariableTable(locals);
    }

    @Override
    public ResolvedJavaMethod getMethod() {
        return this.method;
    }

    public String toString() {
        return this.getClass().getName() + this.method.format("<%H.%n(%p)>");
    }
}

