/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import java.util.List;
import java.util.Optional;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.Phase;
import org.graalvm.compiler.phases.graph.ReentrantNodeIterator;

public class FrameStateAssignmentPhase
extends Phase {
    @Override
    public Optional<BasePhase.NotApplicable> canApply(GraphState graphState) {
        return BasePhase.NotApplicable.combineConstraints(BasePhase.NotApplicable.canOnlyApplyOnce(this, GraphState.StageFlag.FSA, graphState), BasePhase.NotApplicable.notApplicableIf(graphState.getGuardsStage().allowsFloatingGuards(), Optional.of(new BasePhase.NotApplicable("Floating guards should not be allowed."))), BasePhase.NotApplicable.notApplicableIf(graphState.getGuardsStage().areFrameStatesAtDeopts(), Optional.of(new BasePhase.NotApplicable("This phase must run before FSA."))));
    }

    @Override
    protected void run(StructuredGraph graph) {
        assert (!FrameStateAssignmentPhase.hasFloatingDeopts(graph));
        ReentrantNodeIterator.apply(new FrameStateAssignmentClosure(), graph.start(), null);
        graph.getNodes(FrameState.TYPE).filter(state -> state.hasNoUsages()).forEach(GraphUtil::killWithUnusedFloatingInputs);
    }

    @Override
    public void updateGraphState(GraphState graphState) {
        super.updateGraphState(graphState);
        graphState.setAfterFSA();
        graphState.weakenFrameStateVerification(GraphState.FrameStateVerification.NONE);
        graphState.addFutureStageRequirement(GraphState.StageFlag.CANONICALIZATION);
    }

    private static boolean hasFloatingDeopts(StructuredGraph graph) {
        for (Node n : graph.getNodes()) {
            DeoptimizingNode deoptimizingNode;
            if (!(n instanceof DeoptimizingNode) || !GraphUtil.isFloatingNode(n) || !(deoptimizingNode = (DeoptimizingNode)((Object)n)).canDeoptimize()) continue;
            return true;
        }
        return false;
    }

    private static FrameState singleFrameState(List<FrameState> states) {
        FrameState singleState = states.get(0);
        for (int i = 1; i < states.size(); ++i) {
            if (states.get(i) == singleState) continue;
            return null;
        }
        if (singleState != null && singleState.bci != -6) {
            return singleState;
        }
        return null;
    }

    @Override
    public boolean checkContract() {
        return false;
    }

    private static class FrameStateAssignmentClosure
    extends ReentrantNodeIterator.NodeIteratorClosure<FrameState> {
        private FrameStateAssignmentClosure() {
        }

        @Override
        protected FrameState processNode(FixedNode node, FrameState previousState) {
            StateSplit stateSplit;
            FrameState stateAfter;
            DeoptimizingNode deopt;
            FrameState currentState = previousState;
            if (node instanceof DeoptimizingNode.DeoptBefore) {
                deopt = (DeoptimizingNode.DeoptBefore)((Object)node);
                if (deopt.canDeoptimize() && deopt.stateBefore() == null) {
                    GraalError.guarantee(currentState != null, "no FrameState at DeoptimizingNode %s", (Object)deopt);
                    deopt.setStateBefore(currentState);
                }
                if (deopt.canDeoptimize() && deopt.validateDeoptFrameStates() && !deopt.stateBefore().isValidForDeoptimization()) {
                    throw GraalError.shouldNotReachHere(String.format("Invalid framestate for %s: %s", deopt, deopt.stateBefore()));
                }
            }
            if (node instanceof StateSplit && (stateAfter = (stateSplit = (StateSplit)((Object)node)).stateAfter()) != null) {
                currentState = stateAfter.bci == -6 ? null : stateAfter;
                stateSplit.setStateAfter(null);
            }
            if (node instanceof DeoptimizingNode.DeoptDuring) {
                deopt = (DeoptimizingNode.DeoptDuring)((Object)node);
                if (deopt.canDeoptimize() && deopt.stateDuring() == null) {
                    GraalError.guarantee(currentState != null, "no FrameState at DeoptimizingNode %s", (Object)deopt);
                    deopt.computeStateDuring(currentState);
                }
                if (deopt.canDeoptimize() && deopt.validateDeoptFrameStates() && !deopt.stateDuring().isValidForDeoptimization()) {
                    throw GraalError.shouldNotReachHere(String.format("Invalid framestate for %s: %s", deopt, deopt.stateDuring()));
                }
            }
            if (node instanceof DeoptimizingNode.DeoptAfter) {
                deopt = (DeoptimizingNode.DeoptAfter)((Object)node);
                if (deopt.canDeoptimize() && deopt.stateAfter() == null) {
                    GraalError.guarantee(currentState != null, "no FrameState at DeoptimizingNode %s", (Object)deopt);
                    deopt.setStateAfter(currentState);
                }
                if (deopt.canDeoptimize() && deopt.validateDeoptFrameStates() && !deopt.stateAfter().isValidForDeoptimization()) {
                    throw GraalError.shouldNotReachHere(String.format("Invalid framestate for %s: %s", deopt, deopt.stateAfter()));
                }
            }
            return currentState;
        }

        @Override
        protected FrameState merge(AbstractMergeNode merge, List<FrameState> states) {
            FrameState singleFrameState = FrameStateAssignmentPhase.singleFrameState(states);
            return singleFrameState == null ? merge.stateAfter() : singleFrameState;
        }

        @Override
        protected FrameState afterSplit(AbstractBeginNode node, FrameState oldState) {
            return oldState;
        }

        @Override
        protected EconomicMap<LoopExitNode, FrameState> processLoop(LoopBeginNode loop, FrameState initialState) {
            return ReentrantNodeIterator.processLoop(this, (LoopBeginNode)loop, initialState).exitStates;
        }
    }
}

