/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.loop;

import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.IntegerConvertNode;
import org.graalvm.compiler.nodes.calc.NegateNode;
import org.graalvm.compiler.nodes.calc.SubNode;
import org.graalvm.compiler.nodes.loop.DerivedConvertedInductionVariable;
import org.graalvm.compiler.nodes.loop.DerivedInductionVariable;
import org.graalvm.compiler.nodes.loop.DerivedScaledInductionVariable;
import org.graalvm.compiler.nodes.loop.InductionVariable;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.loop.MathUtil;

public class DerivedOffsetInductionVariable
extends DerivedInductionVariable {
    protected final ValueNode offset;
    protected final BinaryArithmeticNode<?> value;

    public DerivedOffsetInductionVariable(LoopEx loop, InductionVariable base, ValueNode offset, BinaryArithmeticNode<?> value) {
        super(loop, base);
        this.offset = offset;
        this.value = value;
    }

    public ValueNode getOffset() {
        return this.offset;
    }

    @Override
    public InductionVariable.Direction direction() {
        InductionVariable.Direction baseDirection = this.base.direction();
        if (baseDirection == null) {
            return null;
        }
        if (this.value instanceof SubNode && this.base.valueNode() == this.value.getY()) {
            return baseDirection.opposite();
        }
        return baseDirection;
    }

    @Override
    public ValueNode valueNode() {
        return this.value;
    }

    @Override
    public boolean isConstantInit() {
        return this.offset.isConstant() && this.base.isConstantInit();
    }

    @Override
    public boolean isConstantStride() {
        return this.base.isConstantStride();
    }

    @Override
    public long constantInit() {
        return this.op(this.base.constantInit(), this.offset.asJavaConstant().asLong());
    }

    @Override
    public long constantStride() {
        if (this.value instanceof SubNode && this.base.valueNode() == this.value.getY()) {
            return -this.base.constantStride();
        }
        return this.base.constantStride();
    }

    @Override
    public ValueNode initNode() {
        return this.op(this.base.initNode(), this.offset);
    }

    @Override
    public ValueNode strideNode() {
        if (this.value instanceof SubNode && this.base.valueNode() == this.value.getY()) {
            return this.graph().addOrUniqueWithInputs(NegateNode.create(this.base.strideNode(), NodeView.DEFAULT));
        }
        return this.base.strideNode();
    }

    @Override
    public ValueNode extremumNode(boolean assumeLoopEntered, Stamp stamp) {
        return this.op(this.base.extremumNode(assumeLoopEntered, stamp), IntegerConvertNode.convert(this.offset, stamp, this.graph(), NodeView.DEFAULT));
    }

    @Override
    public ValueNode exitValueNode() {
        return this.op(this.base.exitValueNode(), this.offset);
    }

    @Override
    public boolean isConstantExtremum() {
        return this.offset.isConstant() && this.base.isConstantExtremum();
    }

    @Override
    public long constantExtremum() {
        return this.op(this.base.constantExtremum(), this.offset.asJavaConstant().asLong());
    }

    private long op(long b, long o) {
        if (this.value instanceof AddNode) {
            return b + o;
        }
        if (this.value instanceof SubNode) {
            if (this.base.valueNode() == this.value.getX()) {
                return b - o;
            }
            assert (this.base.valueNode() == this.value.getY());
            return o - b;
        }
        throw GraalError.shouldNotReachHere();
    }

    public ValueNode op(ValueNode b, ValueNode o) {
        return this.op(b, o, true);
    }

    public ValueNode op(ValueNode b, ValueNode o, boolean gvn) {
        if (this.value instanceof AddNode) {
            return MathUtil.add(this.graph(), b, o, gvn);
        }
        if (this.value instanceof SubNode) {
            if (this.base.valueNode() == this.value.getX()) {
                return MathUtil.sub(this.graph(), b, o, gvn);
            }
            assert (this.base.valueNode() == this.value.getY());
            return MathUtil.sub(this.graph(), o, b, gvn);
        }
        throw GraalError.shouldNotReachHere();
    }

    @Override
    public void deleteUnusedNodes() {
    }

    @Override
    public boolean isConstantScale(InductionVariable ref) {
        return super.isConstantScale(ref) || this.base.isConstantScale(ref);
    }

    @Override
    public long constantScale(InductionVariable ref) {
        assert (this.isConstantScale(ref));
        if (this == ref) {
            return 1L;
        }
        return this.base.constantScale(ref) * (long)(this.value instanceof SubNode && this.base.valueNode() == this.value.getY() ? -1 : 1);
    }

    @Override
    public boolean offsetIsZero(InductionVariable ref) {
        return this == ref;
    }

    @Override
    public ValueNode offsetNode(InductionVariable ref) {
        assert (!this.offsetIsZero(ref));
        if (!this.base.offsetIsZero(ref)) {
            return null;
        }
        return this.offset;
    }

    public String toString() {
        return String.format("DerivedOffsetInductionVariable base (%s) %s %s", this.base, this.value.getNodeClass().shortName(), this.offset);
    }

    @Override
    public ValueNode copyValue(InductionVariable newBase) {
        return this.copyValue(newBase, true);
    }

    @Override
    public ValueNode copyValue(InductionVariable newBase, boolean gvn) {
        return this.op(newBase.valueNode(), this.offset, gvn);
    }

    @Override
    public InductionVariable copy(InductionVariable newBase, ValueNode newValue) {
        if (newValue instanceof BinaryArithmeticNode) {
            return new DerivedOffsetInductionVariable(this.loop, newBase, this.offset, (BinaryArithmeticNode)newValue);
        }
        if (newValue instanceof NegateNode) {
            return new DerivedScaledInductionVariable(this.loop, newBase, (NegateNode)newValue);
        }
        assert (newValue instanceof IntegerConvertNode) : "Expected integer convert operation. New baseIV=" + newBase + " newValue=" + newValue;
        return new DerivedConvertedInductionVariable(this.loop, newBase, newValue.stamp(NodeView.DEFAULT), newValue);
    }

    @Override
    public ValueNode entryTripValue() {
        return this.op(this.getBase().entryTripValue(), this.offset);
    }
}

