/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.java;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.graph.iterators.NodePredicates;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.CompressionNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;

@NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED)
public final class ReachabilityFenceNode
extends FixedWithNextNode
implements Virtualizable,
Canonicalizable,
LIRLowerable {
    public static final NodeClass<ReachabilityFenceNode> TYPE = NodeClass.create(ReachabilityFenceNode.class);
    @Node.Input
    NodeInputList<ValueNode> values;

    public static ValueNode create(ValueNode value) {
        return new ReachabilityFenceNode(new ValueNode[]{value});
    }

    public static ReachabilityFenceNode create(ValueNode[] values) {
        return new ReachabilityFenceNode(values);
    }

    protected ReachabilityFenceNode(ValueNode[] values) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forVoid());
        this.values = new NodeInputList((Node)this, (Node[])values);
    }

    public NodeInputList<ValueNode> getValues() {
        return this.values;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        EconomicSet newValues = EconomicSet.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE, (int)this.values.size());
        boolean modified = false;
        for (ValueNode originalValue : this.values) {
            if (originalValue instanceof VirtualObjectNode) {
                newValues.add((Object)originalValue);
                modified = true;
                continue;
            }
            ValueNode aliasValue = tool.getAlias(originalValue);
            if (originalValue == aliasValue) {
                newValues.add((Object)originalValue);
                continue;
            }
            this.processValue(aliasValue, (EconomicSet<ValueNode>)newValues, tool);
            modified = true;
        }
        if (modified) {
            tool.replaceWith(new ReachabilityFenceNode((ValueNode[])newValues.toArray((Object[])new ValueNode[newValues.size()])));
        }
    }

    private void processValue(ValueNode value, EconomicSet<ValueNode> newValues, VirtualizerTool tool) {
        if (!value.isConstant() && value.getStackKind() == JavaKind.Object) {
            if (value instanceof VirtualObjectNode) {
                VirtualObjectNode virtualObject = (VirtualObjectNode)value;
                if (newValues.add((Object)virtualObject)) {
                    for (int i = 0; i < virtualObject.entryCount(); ++i) {
                        this.processValue(tool.getEntry(virtualObject, i), newValues, tool);
                    }
                }
            } else {
                newValues.add((Object)value);
            }
        }
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        int droppedInputs = 0;
        int compressionInputs = 0;
        for (ValueNode value : this.values) {
            if (value.isConstant()) {
                ++droppedInputs;
                continue;
            }
            if (!tool.allUsagesAvailable() || !(value instanceof CompressionNode) && !(value instanceof VirtualObjectNode) || !ReachabilityFenceNode.hasOnlyReachabilityFenceUsages(value)) continue;
            if (value instanceof CompressionNode) {
                ++compressionInputs;
                continue;
            }
            assert (value instanceof VirtualObjectNode);
            ++droppedInputs;
        }
        if (this.values.size() == 0 || this.values.size() == droppedInputs) {
            return null;
        }
        if (droppedInputs > 0 || compressionInputs > 0) {
            int newInputSize = this.values.size() - droppedInputs;
            ValueNode[] newInputs = new ValueNode[newInputSize];
            int i = 0;
            for (ValueNode value : this.values) {
                ValueNode v = value;
                if (v.isConstant()) continue;
                if (tool.allUsagesAvailable() && (v instanceof CompressionNode || v instanceof VirtualObjectNode) && ReachabilityFenceNode.hasOnlyReachabilityFenceUsages(v)) {
                    if (v instanceof CompressionNode) {
                        v = ((CompressionNode)v).getValue();
                    } else {
                        assert (v instanceof VirtualObjectNode);
                        continue;
                    }
                }
                newInputs[i++] = v;
            }
            assert (i == newInputSize);
            return new ReachabilityFenceNode(newInputs);
        }
        return this;
    }

    private static boolean hasOnlyReachabilityFenceUsages(ValueNode value) {
        if (value.hasExactlyOneUsage()) {
            assert (value.singleUsage() instanceof ReachabilityFenceNode);
            return true;
        }
        return value.usages().filter(NodePredicates.isNotA(ReachabilityFenceNode.class)).isEmpty();
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        for (ValueNode value : this.values) {
            if (value instanceof VirtualObjectNode) continue;
            gen.getLIRGeneratorTool().emitBlackhole(gen.operand(value));
        }
    }
}

